<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: portal.xsl,v 1.3 2003/09/09 14:31:32 adam Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="tkl_authenticated"/>

<xsl:template match="portal">
    <xsl:call-template name="main-page"/>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<!--
  The display routine for the main subject hierarchy will necessarily
  depend somewhat on the nature of the hierarchy. This one is good
  for a small, flat one
  -->

<xsl:template name="main-body">
    <xsl:variable name="subjects" select="document(concat('tkl-find://',
        '?path=links/*',
	'&amp;mask=index.tkl',
	'&amp;select=title',
	'&amp;level=2'))"/>

    <xsl:for-each select="$subjects/*/dir">
        <xsl:sort select="@path"/>
        <p/>
	<b><a href="{@path}"><xsl:value-of select="file"/></a></b>
	<br/>
	<xsl:for-each select="dir">
	    <xsl:sort select="@path"/>
	    <a href="{file/@path}"><xsl:value-of select="file"/></a>
	    <br/>
	</xsl:for-each>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
