<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: link2oai_dc.xsl,v 1.1 2003/10/06 11:29:20 marc Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    version="1.0">

    <xsl:output method="xml" encoding="UTF-8"/>

<xsl:template match="/link">
    <oai_dc:dc 
        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xsi:schemaLocation="http://www.openarchives.org/OAI/2.0/oai_dc/
	http://www.openarchives.org/OAI/2.0/oai_dc.xsd">

	<xsl:apply-templates/>

    </oai_dc:dc>
</xsl:template>

<xsl:template match="title">
    <dc:title>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:title>
</xsl:template>

<xsl:template match="creator">
    <dc:creator>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:creator>
</xsl:template>

<xsl:template match="subject">
    <dc:subject>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:subject>
</xsl:template>

<xsl:template match="description">
    <dc:description>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:description>
</xsl:template>

<xsl:template match="publisher">
    <dc:publisher>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:publisher>
</xsl:template>

<xsl:template match="contributor">
    <dc:contributor>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:contributor>
</xsl:template>

<xsl:template match="date">
    <dc:date>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:date>
</xsl:template>

<xsl:template match="type">
    <dc:type>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:type>
</xsl:template>

<xsl:template match="format">
    <dc:format>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:format>
</xsl:template>

<xsl:template match="identifier">
    <dc:identifier>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:identifier>
</xsl:template>

<xsl:template match="source">
    <dc:source>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:source>
</xsl:template>

<xsl:template match="language">
    <dc:language>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:language>
</xsl:template>

<xsl:template match="relation">
    <dc:relation>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:relation>
</xsl:template>

<xsl:template match="coverage">
    <dc:coverage>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:coverage>
</xsl:template>

<xsl:template match="rights">
    <dc:rights>
        <xsl:copy-of select="@xml:lang"/>
        <xsl:value-of select="."/>
    </dc:rights>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
