<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: subject.xsl,v 1.11 2003/09/10 10:51:24 marc Exp $
-->
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:portcom="http://www.indexdata.dk/TKL"
    xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    version="1.0">

    <xsl:import href="tkl-file://interface.xsl"/>
    <xsl:include href="tkl-file://news.xsl"/>

    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="start" select="1"/>
    <xsl:param name="number" select="6"/>
    <xsl:param name="sort"/>
    <portcom:session-var name="sort" default="title"/>

    <xsl:param name="tkl_cwd"/>
    <xsl:param name="tkl_authenticated"/>
    <xsl:param name="tkl_bin"/>
    <xsl:param name="tkl_docroot"/>


<xsl:template match="/subject">
    <xsl:call-template name="main-page">
        <xsl:with-param name="title" select="title"/>
    </xsl:call-template>
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>

<!-- The main body of the screen -->

<xsl:template name="main-body">
    <xsl:variable name="types"
      select="document('tkl-file://authorities/def-typer.tkl')"/>

    <xsl:call-template name="insert-path"/>

    <!-- Show subject headings -->

    <xsl:variable name="subject" select="document('tkl-find://?name=subjecs&amp;path=*/index.tkl&amp;select=title')"/>


    <xsl:if test="$start = '1'">
      <xsl:if test="$subject">
       <p/>
       <p>
       <xsl:for-each select="$subject/*/file">
          <xsl:sort select="@path"/>
	  <img height="8" width="10" src="{$root}/gfx/square.gif"/>
	  <a href="{@path}"><xsl:value-of select="."/></a><br/>
       </xsl:for-each>
       </p>
      </xsl:if>
    </xsl:if>

    <!-- Show number of records and next/prev -->
    
    <!--
    <xsl:variable name="links">
      <xsl:for-each
          select="document('tkl-find://?path=link*.tkl&amp;select=title/@alphasort|identifier|description')/tkl-find/file">
        <xsl:sort select="title/@alphasort"/>
	<xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:variable>
    -->

    <xsl:variable name="links">
      <xsl:if test="$sort = 'title'">
        <xsl:for-each
            select="document('tkl-find://?path=link*.tkl&amp;select=title/@alphasort|identifier|description')/tkl-find/file">
          <xsl:sort select="title/@alphasort"/>
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:if>
      <xsl:if test="$sort = 'type'">

        <!-- First we collapse the types with their sortcode -->
        <xsl:variable name="typesfolded">
          <list>
            <xsl:for-each
                select="document('tkl-find://?path=link*.tkl&amp;select=title|identifier|description|type')/tkl-find/file">
              <file path="{@path}">
                <xsl:copy-of select="*"/>
                <sorttype>
                  <xsl:variable name="mytype" select="type[1]"/>
                  <xsl:variable name="trans" select="$types/*/enum[@value=$mytype]"/>
                  <xsl:value-of select="$trans/@sortcode"/>
                  <xsl:value-of select="$trans/@value"/>
                </sorttype>
              </file>
            </xsl:for-each>
          </list>
        </xsl:variable>

        <!-- THEN we sort the records -->

        <xsl:for-each select="$typesfolded/*/file">
          <xsl:sort select="sorttype"/>
          <xsl:copy-of select="."/>
        </xsl:for-each>
      </xsl:if>
    </xsl:variable>


    <xsl:if test="$links/file">
     <p/>

     <xsl:call-template name="show-header">
       <xsl:with-param name="links" select="$links"/>
     </xsl:call-template>

     <!-- Show pointers -->

     <p/>
     <xsl:for-each select="$links/file
         [position() &gt;= $start and position() &lt; $start+$number]">

	 <xsl:variable name="ident">
	   <xsl:choose>
	     <xsl:when test="string-length(identifier) &gt; 50">
		 <xsl:value-of select="substring(identifier, 1, 50)"/>
		 <xsl:text>...</xsl:text>
	     </xsl:when>
	     <xsl:otherwise>
		 <xsl:value-of select="identifier"/>
	     </xsl:otherwise>
	   </xsl:choose>
	 </xsl:variable>

         <xsl:if test="$sort = 'type'">
           <xsl:if test="type[1] != preceding-sibling::file[1]/type[1] or
                position() = 1">
             <xsl:variable name="mytype" select="type[1]"/>
             <xsl:variable name="trans" select="$types/*/enum[@value=$mytype]"/>
             <b>
               <xsl:choose>
                 <xsl:when test="$trans">
                   <xsl:value-of select="$trans"/>
                 </xsl:when>
                 <xsl:otherwise>
                    <xsl:text xml:lang="da">Klassifikation : </xsl:text>
                    <xsl:text xml:lang="en">Subject type: </xsl:text>
                    <xsl:value-of select="$mytype"/>
                 </xsl:otherwise>
               </xsl:choose>
             </b><br/>
             <!-- <hr/> -->
             <p/>
           </xsl:if>
         </xsl:if> 

          <img height="8" width="10" src="{$root}/gfx/arrow_brown_right.gif"/>
          <xsl:choose>
            <!-- link specific stuff here -->
            <xsl:when test="identifier">
	      <a href="{identifier}"><xsl:value-of select="title"/></a>
	      <xsl:if test="$tkl_authenticated">
	        <a href="{$tkl_bin}/xform2.php?xml_file={$tkl_docroot}/{$tkl_cwd}/{@path}"
	          onClick="window.open('', 'xform', 'width=800,height=600,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes')" target="xform">
	          <img border="0" src="{$root}/gfx/edit.gif"/>
	        </a>
	      </xsl:if>

	      <br/><xsl:value-of select="$ident"/>
	      <br/>- <xsl:copy-of select="description"/>
              <!-- end link specific stuff -->
            </xsl:when>
            <!-- oai specific stuff here -->
            <xsl:when test="oai_dc:dc/dc:identifier">
	      <a href="{oai_dc:dc/dc:identifier}"><xsl:value-of select="oai_dc:dc/dc:title"/></a>
	      <xsl:if test="$tkl_authenticated">
	        <a href="{$tkl_bin}/xform2.php?xml_file={$tkl_docroot}/{$tkl_cwd}/{@path}"
	          onClick="window.open('', 'xform', 'width=800,height=600,screenX=1,screenY=1,top=1,left=1,resizable=yes,scrollbars=1,scrolling=yes')" target="xform">
	          <img border="0" src="{$root}/gfx/edit.gif"/>
	        </a>
	      </xsl:if>

	      <br/><xsl:value-of select="$ident"/>
	      <br/>- <xsl:copy-of select="oai_dc:dc/dc:description"/>
              <!-- end oai specific stuff -->
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose>

          
	  <br/>&#xa0;<br/>
     </xsl:for-each>

     <xsl:call-template name="show-header">
       <xsl:with-param name="links" select="$links"/>
     </xsl:call-template>
     <p/>

    </xsl:if>

</xsl:template>


<!-- Show hit count and next/prev links -->
<xsl:template name="show-header">
  <xsl:param name="links"/>

  <xsl:value-of select="count($links/file)"/>
    <span xml:lang="en"> links. Showing </span>
    <span xml:lang="da"> links. Viser </span>
  <xsl:value-of select="$start"/>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="$number+$start &gt; count($links/file)">
      <xsl:value-of select="count($links/file)"/>
    </xsl:when>
    <xsl:otherwise>
	<xsl:value-of select="$number + $start - 1"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:text>. </xsl:text>

  <!-- Next/previous -->

  <xsl:if test="$start &gt; 1">
    <xsl:text> --- </xsl:text>
    <a href="?start={$start - $number}">
      <span xml:lang="da">Tilbage</span>
      <span xml:lang="en">Back</span>
    </a>
  </xsl:if>
  <xsl:if test="$start + $number - 1 &lt; count($links/file)">
     <xsl:text> --- </xsl:text>
     <a href="?start={$start + $number}">
      <span xml:lang="da">Flere</span>
      <span xml:lang="en">More</span>
    </a>
  </xsl:if>

  <xsl:text> --- </xsl:text>

  <xsl:if test="$sort = 'title'">
    <a href="?sort=type">
      <span xml:lang="da">Sorter efter ressourcetype</span>
      <span xml:lang="en">Sort by resource type</span>
    </a>
  </xsl:if>
  <xsl:if test="$sort = 'type'">
    <a href="?sort=title">
      <span xml:lang="da">Sorter efter titel</span>
      <span xml:lang="en">Sort by title</span>
    </a>
  </xsl:if>

  <xsl:if test="$tkl_authenticated">
      <a
	href="{$tkl_cwd}/?admin=1"
	 target="_blank">
	  <img border="0" src="{$root}/gfx/edit.gif"/>
      </a>
  </xsl:if>

</xsl:template>


</xsl:stylesheet>
