<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: full.php,v 1.13 2003/09/10 09:50:41 anders Exp $
*/

require 'util.phpi';      // Utility file
set_lang();

include 'targets.php';    // Definitions of Z39.50 targets using sql.
require 'config.phpi';      // Config file
require 'tkl_tools.php';
require 'globals.phpi';
require 'yaz_util.php';
require 'record.php';
require '../lang/lang.php';      // Text strings in the supported languages


header("Content-Type: text/html; charset=utf-8");

// Set default values
$number = $_GET["number"];
$start = $_GET["start"];
$host = $_GET["host"];
$sort = $_GET["sort"];
$query = stripslashes($_GET["query"]);

// Set default values
if (!$number) $number = $default_hits;
if (!$start) $start = 1;
if (!$host) $host = array();

$num_hosts = count($host);
$hits = array();
$pos = array();
$view_pos = array();
$host_done = 0;

$myurl = $_SERVER["PHP_SELF"];
$myurl .= "?host[]=".$host[0]."&query=" . urlencode($query) . "&number=$number";
function  print_record($h,$p) {
    global $id,$host,$res,$query,$start;

    $res = yaz_srecord($id[$h],$p,"structure");
    $record = new MARC_USMARC($res); // Make a new record object out of the raw $rec

	echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"370\">";
    echo $record->ffields('title', "<tr><td style=\"width: 75px; vertical-align: top;\" height=\"30\"><span class=\"big\" style=\"font-size: 14px;\">".trans_text(2).":</span></td><td style=\"width: 295px; vertical-align: top;\"><span class=\"big\" style=\"font-size: 14px;\">", "</span></td></tr>", "", ""), "\n";
    echo $record->ffields_complex('author', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(11).":</td><td style=\"vertical-align: top;\">", "<span class=\"item\"","</td></tr>", ", ", ""), "\n";
    $place_publication = $record->ffields('place_publication');
    $name_publication = $record->ffields('name_publication');
    $date_publication = $record->ffields('date_publication');
    if ($place_publication != "" | $name_publication != ""| $date_publication != "") {
        echo "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(10).":</td><td style=\"vertical-align: top;\">$name_publication $place_publication $date_publication</td></tr>";
    }
    echo $record->ffields('edition', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(9).":</td><td style=\"vertical-align: top;\">","</td></tr>", ", ", ""), "\n";
    echo $record->ffields('medium', "<tr><td style=\"vertical-align: top;\" height=\"20\">Medium:</td><td style=\"vertical-align: top;\">","</td></tr>", ", ", ""), "\n";
    echo $record->ffields('corporate_name', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(8).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('meeting_name', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(7).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('topical_name', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(6).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('bib_note', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(3).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('gen_note', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(3).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('formated_note', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(3).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('isbn', "<tr><td style=\"vertical-align: top;\" height=\"20\">ISBN:</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    $url = $record->ffields('online');
    $online_text = $record->ffields('online_text');
    if ($online_text != "") {
        $online_text = " ($online_text)";
    }
    echo $record->ffields_complex('online', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(12).":</td><td style=\"vertical-align: top;\">", "<a class=\"item\" href=\"$url","$online_text</td></tr>", ", ", ""), "\n";
    echo $record->ffields('phys_format', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(13).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
     echo $record->ffields('oth_phys_format', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(14).":</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo $record->ffields('cartho_data', "<tr><td style=\"vertical-align: top;\" height=\"20\">".trans_text(15)."Scale:</td><td style=\"vertical-align: top;\">", "</td></tr>", ", ", ""), "\n";
    echo "</table>";



}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

<?php
if (!$debug) {
    echo "<link href=\"../css/styles.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen, all\" />
	        <link rel=\"stylesheet\" type=\"text/css\" href=\"../css/record_handler.css\"></link>";
}
?>
<title>LoT</title>
</head>
<?php
echo "<body onload=\"top.framegui.incoming('$host[0]');\" >";
print "<div class=\"record\" id=\"record\" start=\"".$start."\" number=\"".$number."\">\n";
// headline 
echo "<a href=\"#\" class=\"big\">". $targets[$host[0]]["title"] ."</a><br /><br />";

// Do it
$pos = array();

$yopt = array();
$yopt['proxy'] = $z_proxy;

$i = 0;
foreach ($host as $h) {
    $info = $targets[$h];
    //for ($i = 0; $i < $num_hosts; $i++) {
    $id[$i] = yaz_connect($info['identifier'],$yopt);
    $pos[$i] = 0;
    $hits[$i] = -1;
    if($id[$i]){
	tkl_prepare($id[$i], $info, $query);
    } else {
    	print "Failed to create endpoint for $h (" . $thistarget['identifier'] . ")<br />\n";
    }
    $i++;
}

$opt["timeout"] = 15;
$res = yaz_wait($opt);
$error = yaz_error($id[0]);

if (!empty($error)) {
    echo "Error: $error";
} else {
    $hits = yaz_hits($id[0]);
    for ($p = $start; $p <= ($number+$start-1); $p++)
    {
	if($p <= $hits) $rec = print_record(0,$p);
    }
}

$go_up = ($default_hits*floor(($start-1)/$default_hits))+1;


echo '<img src="../gfx/arrow_orange_left.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(5).'">&nbsp;&nbsp;<a href="../php/search_record.php?host[]='.$host[0].'&query='.$query.'&number='.$default_hits.'&start='.$go_up.'" TARGET="framedata">' . trans_text(16) . '</a>&nbsp;&nbsp;&nbsp;';
if($hits > ($number+$start-1)) {
    if($start > 1){
	// back..
	echo '<img src="../gfx/arrow_orange_left.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(5).'">&nbsp;&nbsp;<a href="'.$myurl.'&start='.($start-$number).'" TARGET="framedata">'.trans_text(5).'</a>   |   ';
    }
    // next page  url+start=($number+$start)
    echo ' <a href="'.$myurl.'&start='.($number+$start).'" TARGET="framedata">'.trans_text(4).'</a>&nbsp;&nbsp;';
    echo '<img src="../gfx/arrow_orange_right.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(4).'">';
} else if ($start >= $number) {
    //back only..
    echo '<img src="../gfx/arrow_orange_left.gif" style="vertical-align: middle; border: 0px;" width="11" height="11" alt="'.trans_text(5).'">&nbsp;&nbsp;<a href="'.$myurl.'&start='.($start-$number).'" TARGET="framedata">'.trans_text(5).'</a>';
}


?>
</div>
    </body>
</html>
