<?php
/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: record.php,v 1.3 2003/09/09 14:31:34 adam Exp $
*/

// Primary method interface:
// elements($path);     - return list of elements (sub-records) matching path
// felements($path, $prefix='', $suffix='', $infix='', $none='');  - return formatted string from elements
//
// fields($name);        - return list of elements matching symbolic name (eg. 'title');
// ffields($path, $prefix='', $suffix='', $infix='', $none='');  - return formatted string from elements
//
// data();               - Return data content of element (subtree).


class Record {
    var $record;
    var $field_array;

    function Record($rec) {
	$this->record = $rec;
    }

    function felements($path, $prefix='', $suffix='', $infix='', $none='') {
	$res = '';
	if ($r = $this->elements($path)) {
	    $count = count($r);
	    for ($i = 0; $i < $count; ) {
		$res .= $r[$i]->data();
		$i++;
		if (!$infix)
		    break;
		if ($i < $count) { $res .= $infix; }
	    }
	    if (!$res)
		$res = $none;
	} else {
	    $res = $none;
	}
	if ($res) {
	    if ($prefix) $res = $prefix . $res;
	    if ($suffix) $res .= $suffix;
	}
	return utf8_encode($res);
    }


    function celements($path, $prefix='', $URLbegin='', $suffix='', $infix='', $none='') {
	$res = '';
	if ($r = $this->elements($path)) {
	    $count = count($r);
	    for ($i = 0; $i < $count; ) {
    		$res .= $URLbegin . urlencode($r[$i]->data()) . "\">" . $r[$i]->data() . "</a>";
    		$i++;
    		if (!$infix)
    		    break;
    		if ($i < $count) {
    		    $res .= $infix;
    		}
	    }
	    if (!$res)
		$res = $none;
	} else {
	    $res = $none;
	}
	if ($res) {
	    if ($prefix) $res = $prefix . $res;
	    if ($suffix) $res .= $suffix;
	}
	return $res;
    }

    function fields($name) {
	if ($this->field_array[$name]) {
	    return $this->elements($this->field_array[$name]);
	}
	return array();
    }

    function ffields($name, $prefix='', $suffix='', $infix='', $none='') {
    	if ($this->field_array[$name]) {
    	    return $this->felements($this->field_array[$name], $prefix, $suffix, $infix, $none);
    	}
    	return $none;
    }

    function ffields_complex($name, $prefix='', $URLbegin='', $suffix='', $infix='', $none='') {
    	if ($this->field_array[$name]) {
    	    return utf8_encode($this->celements($this->field_array[$name], $prefix, $URLbegin, $suffix, $infix, $none));
    	}
    	return $none;
    }
}

// Pattern syntax: /x/x/x ..
// x=string
// x=*
// $res should be initialised to empty array


function _xmlrecord_match_pat($pat, $rec, &$res) {
    preg_match('/\/(.*)(\/.*)?$/U', $pat, $match);
    $tag = $match[1]; $tail = $match[2];

    preg_match_all("/<$tag>.*<\/$tag>/s", $rec, $rlist);

    foreach ($rlist[0] as $r) {
	if ($tail) {
	    _xmlrecord_match_pat($tail, $r, $res);
	} else {
	    $res[] = $r;
	}
    }
}

function _xml_record_data($recs, &$res) {
    $res = join(' ', $recs);
    $res = preg_replace("/<.*>/U", "", $res);
}

class XML_record extends Record {
    function XML_record(&$rec) {
	$this->Record($rec);
	$this->field_array = array(
	    'title' => '/title',
	    'author' => '/author',
	    'subject' => '/subject',
	    'url' => '/url',
	    'id' => '/url',
	    'description' => '/description',
	);
    }

//    function data($element) {
//	$result = array();
//	_xmlrecord_match_pat($element, $this->record, $result);
//
//	_xmlrecord_data($result, $r);
//	return $r;
//    }

    function data() {
	_xml_record_data(array($this->record), $res);
	return $res;
    }

    function elements($element) {
	$result = array();
	_xmlrecord_match_pat($element, $this->record, $result);

	foreach ($result as $r) {
	    $rr[] = new XML_record($r);
	}

	return $rr;
    }
}

class XML_Google extends XML_record {
    function XML_Google(&$rec) {
	$this->XML_record($rec);
	$this->field_array = array(
	    'title' => '/title',
	    'url' => '/URL',
	    'id' => '/URL',
	    'description' => '/snippet',
	);
    }
}

class MARC_record extends GRS_record {
    function GRS_record(&$rec) {
	$this->Record($rec);
    }
}


// Pattern syntax: /x/x/x
// x=(tt,tv)
// x=string ==> (3,string)
// x=*
// $res should be initialised to empty array

function _record_match_pat($pat, $rec, &$res) {
    preg_match('/\/(.*)(\/.*)?$/U', $pat, $match);
    $tag = $match[1]; $tail = $match[2];
    if (!preg_match('/\(.*\)/', $tag) && $tag != '*') {
	$tag = "(3,$tag)";
    }

	if(is_array($rec)){
    foreach ($rec as $elem) {
	if ($elem[tag] == $tag || $tag == '*' || empty($tag)) {
	    if ($tail && is_array($elem[data])) {
		_record_match_pat($tail, $elem[data], $res);
	    } else {
		$res[] = $elem;
	    }
	}
    }
	}
}

// dump all data contents of a record tree
function _record_data($recs, &$res) {
    foreach ($recs as $rec) {
	if (is_array($rec[data])) {
	    _record_data($rec[data], $res);
	} else if (!empty($rec[data])) {
	    if ($res) {
		$res .= ' ';
	    }
	    $tmp = $rec[data];
	    $tmp = preg_replace("/^\s*/", "", $tmp);
	    $tmp = preg_replace("/\s*$/", "", $tmp);
	    $res .= $tmp;
	}
    }
}

class GRS_record extends record {
    function GRS_record(&$rec) {
	$this->Record($rec);

	$this->field_array = array(
	    'id'	=> '/(1,14)',
	    'title'	=> '/(2,1)',
	    'author'	=> '/(2,2)',
	    'abstract'	=> '/(2,6)',
	    'subject'	=> '/(2,21)',
	    'rights'	=> '/(2,29)',
	    'description' => '/(2,17)',
	    'url'	=>  '/(2,28)',
	);
    }

    function elements($element) {
	// print "elempath=$element, gpaths r=<pre>"; print_r($this->record);  print "</pre><hr>";
	$result = array();
	_record_match_pat($element, $this->record, $result);

	$rr = array();
	foreach ($result as $r) {
	    $ar = array($r);
	    $rr[] = new GRS_record($ar);
	}

	return $rr;
    }

    function data() {
	_record_data($this->record, $res);
	return $res;
    }

//    function data($element) {
//	$result = array();
//	_record_match_pat($element, $this->record, $result);
//
//	$res = '';
//	_record_data($result, $res);
//
//	return $res;
//    }

}

class GRS_Zthes extends GRS_record {
    function GRS_Zthes(&$rec) {
	$this->GRS_Record($rec);
	$this->field_array = array_merge($this->field_array, array(
	    'termid'	=> '/(1,14)'
	));
    }
}

class GRS_GILS extends GRS_record {
    function GRS_GILS(&$rec) {
	$this->GRS_Record($rec);
	$this->field_array = array_merge($this->field_array, array(
	    'url' => '/(4,70)/(4,99)/(4,17)',
	    'description' => '/(2,6)',
	));
    }

    // add tags for special GILS fields.
}

class MARC_DANMARC extends MARC_record {
    function MARC_DANMARC(&$rec) {
	$this->Record($rec);
	$this->field_array = array(
	    'title'	=> '/245/*/a',
	    'author'	=> '/100/*/a',
	    'type' => '/009/*/g',
	    'id' => '/001/*/a',
	);
    }

    // todo tags
}

class MARC_USMARC extends MARC_record {
    function MARC_USMARC(&$rec) {
    	$this->Record($rec);
    	$this->field_array = array(
    	    'id'	=> '/001',
    	    'isbn'	=> '/21/*/a',
    	    'author'	=> '/100/*/a',
    	    'author_b_d'	=> '/100/*/d',
    	    'corporate_name'	=> '/110/*/a',
    	    'meeting_name'	=> '/111/*/a',
    	    'date'	=> '/206/*/c',
    	    'title'	=> '/245/*/a',
    	    'medium'	=> '/245/*/h',
    	    'subtitle'	=> '/245/*/c',
    	    'edition'	=> '/250/*/a',
    	    'cartho_data'	=> '/255/*/a',
    	    'place_publication'	=> '/260/*/a',
    	    'name_publication'	=> '/260/*/b',
    	    'date_publication'	=> '/260/*/c',
    	    'extend'	=> '/300/*/a',
    	    'phys_format'	=> '/300/*/b',
    	    'phys_dim'	=> '/300/*/c',
    	    'gen_note'	=> '/500/*/a',
    	    'bib_note'	=> '/504/*/a',
    	    'formated_note'	=> '/505/*/a',
    	    'oth_phys_format'	=> '/530/*/a',
    	    'topical_name'	=> '/650/*/a',
    	    'online'	=> '/856/*/u',
    	    'online_text'	=> '/856/*/z',
    	);
    }

    // todo tags
}


class GRS_BibHit extends GRS_record {
	function GRS_BibHit(&$rec) {
		$this->GRS_Record($rec);
		$this->field_array = array_merge($this->field_array, array(
		'description' => '/(3,Beskrivelse)',
		'url'		=> '/(4,70)/(4,99)/(4,17)',
		'id'		=> '/(4,70)/(4,99)/(4,17)',
		));
	}
}

class XML_WAIS extends XML_record {
    function XML_WAIS(&$rec) {
	$this->Record($rec);
    }

    // this whole thing may be noop
}

//--------------------------------------!
// Here goes the customized filters	!
//--------------------------------------!

class GRS_FNG extends GRS_record {
	function GRS_FNG(&$rec) {
	    	$this->Record($rec);
		$this->field_array = array_merge($this->field_array, array(
			'subj_group'	=> '/(3,subj_group)',
			'url'		=> '/(3,url)',
			'id'		=> '/(3,url)',
			'checked'	=> '/(3,checked)',
			'created'	=> '/(3,created)',
			'modified'	=> '/(3,modified)',
			'title'		=> '/(2,1)',
			'description'	=> '/(2,17)/(1,19)',
			'keyword'	=> '/(3,keyword)',
			'filename'	=> '/(3,filename)',
			'status'	=> '/(3,status)',
			'place'		=> '/(3,place)',
			'link'		=> '/(3,link)',
			'biplace'	=> '/(3,biplace)',
			'sign'	    => '/(3,sign)'
		));
	}
}

?>
