<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: gui.xsl,v 1.3 2003/09/09 14:31:34 adam Exp $
-->
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:portcom="http://www.indexdata.dk/TKL"
  version="1.0">

  <xsl:import href="tkl-file://interface.xsl"/>
  <xsl:include href="tkl-file://news.xsl"/>

  <xsl:output method="html" encoding="UTF-8"/>

  <xsl:param name="query"/>
  <xsl:param name="root"/>

  <xsl:param name="tkl_authenticated"/>

  <xsl:variable name="targets_xml" select="document('tkl-targets://?type=selected')"/>

  <xsl:template match="gui">
    <xsl:call-template name="main-page"/>
  </xsl:template>

  <xsl:template name="main-body">
    <xsl:call-template name="insert-path"/>

    <div id="res" style="display:block;"><br/><br/>
      <xsl:choose>
        <xsl:when test="$query = false()">
          <b>
	    <span xml:lang="en">Remember to insert a search term.</span>
	    <span xml:lang="da">Husk at indsætte en søgeterm.</span>
	  </b>
        </xsl:when>
        <xsl:when test="$targets_xml/targets/@number = false()">
          <center><b>
	    <span xml:lang="en">Remember to selcet a target.</span>
	    <span xml:lang="da">Husk at vælge et target</span></b></center>
        </xsl:when>
        <xsl:otherwise>	
          <center><b><span xml:lang="da">Loader poster...</span><span xml:lang="en">Loading records...</span></b></center>
        </xsl:otherwise>
      </xsl:choose>
    </div>
    <xsl:call-template name="js-script"/>
    <xsl:call-template name="body-end"/>
  </xsl:template>

  <xsl:template name="js-script">
    <link href="{$root}/targets/css/record_handler.css" rel="stylesheet" type="text/css"></link>
    <script language="javascript" src="{$root}/targets/lang/lang.js"></script>
	 <script language="javascript" src="{$root}/targets/js/record_handler.js"></script>
    <script language="javascript" src="{$root}/targets/js/update.js"></script>
  </xsl:template>


  <xsl:template name="body-end">
    <div style="visibility:hidden; position:absolute; top:-1000px;left:-1000px">
      <iframe id="seacrhFrame" src="{$root}/targets/php/search.php"></iframe>
    </div>

    <script language="javascript">
      var seacrhFrame = document.getElementById("seacrhFrame");

      var query = (location.href.indexOf("?"));
      var search_page = '<xsl:value-of select="$root" />/targets/php/search.php'
      if (query)
      {
	 search_page += location.href.substring(query);
      }
      seacrhFrame.src = search_page;
      
      var default_number = 5; // the default number of hits to be show! 
      
    </script>

  </xsl:template>

  <xsl:template name="host-list">
    <xsl:for-each select="$targets_xml/*/target">
      <input type="hidden" name="host[]" value="{@id}"/>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="left-menu">
    <tr>
      <td colspan="2" style="line-height: 11px;" class="dotted">&#xa0;</td>
    </tr>
    <tr>
      <td>
        <br style="line-height: 10px;" />
	<div id="statusProcent">Searching <xsl:value-of select="$targets_xml/targets/@number"/> databases 0% finished</div><br />
	<script language="javascript">
	  var update_time=<xsl:value-of select="$targets_xml/targets/@number"/> ;  // Number of updates (total!)
	</script>
	<script language="javascript" src="{$root}/targets/js/progress_bar.js"></script>
	<br style="line-height: 10px;" />
      </td>
    </tr>
    <tr>
      <td style="vertical-align: top;">
        <table cellpadding="0" cellspacing="0" border="0">
	  <xsl:call-template name="host-menu"/>
	</table>
      </td>
    </tr>
    <tr>
      <td height="100"/>
    </tr>
  </xsl:template>


  <xsl:template name="host-menu">
    <xsl:variable name="myq" select="document('tkl-global://?type=GET&amp;name=query&amp;add_slashes=1')"/>

    <xsl:for-each select="$targets_xml/*/target">
      <tr>
        <td>&#xa0;</td>
	<td height="12" align="center" style="vertical-align: middle;">
	  <div id="HostStatus{@id}" style="vertical-align: middle;">
	    <img src="{$root}/targets/gfx/hourglass.gif" style="vertical-align: middle;" width="9" height="12" alt="Loading" /></div>
	</td>
	<td>&#xa0;</td>
	<td>
	  <img src="{$root}/targets/gfx/vertical_bar_blue.gif" width="1" height="13" alt=" " />
	</td>
	<td align="right" style="padding-right: 8px;">
	  <div id="RecordNum{@id}">&#xa0;</div>
	</td>
	<td>
	  <img src="{$root}/targets/gfx/vertical_bar_blue.gif" width="1" height="13" alt=" " />
	</td>
	<td align="left" style="padding-left: 8px;">
	  <a href="#" onclick="showRecord('{nick}','{title}','{$myq}');"><xsl:value-of select="title"/></a>
	</td>
      </tr>

    </xsl:for-each>

  </xsl:template>

<xsl:template name="body-holder">
  <td width="420" class="bodyarea" valign="top">
    <!-- BODY -->
    <xsl:call-template name="main-body"/>
  </td>
</xsl:template>


<xsl:template name="navigation-menu">
  <td class="navigation" width="152" height="344" valign="top">
    <xsl:call-template name="navigation-content"/>
  </td>
</xsl:template>


<xsl:template name="script">
  <!-- Override the frame-killer javascript from interface.xsl -->
</xsl:template>


<xsl:template name="main-news-content">
    <xsl:call-template name="read-news"/>
</xsl:template>


</xsl:stylesheet>
