/*
   Copyright (C) 2002-2003 Index Data Aps, www.indexdata.dk

   This file is part of TKL.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   A copy of the GNU General Public License is also available at
   <URL:http://www.gnu.org/copyleft/gpl.html>.  You may also obtain
   it by writing to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: update_spool.php,v 1.8 2003/09/10 13:59:04 marc Exp $
*/
// PHP handler associated with the task.xsd schema
// Updates the TKL spool directory when a new
// instance of the task document type is created
//
// By: Anders Snderberg Mortensen <sondberg@indexdata.dk>
//     Indexdata, Copenhagen, Denmark.
//
// $Id: update_spool.php,v 1.8 2003/09/10 13:59:04 marc Exp $

$portal_root = preg_replace("/\/+/", "/", $_SERVER['DOCUMENT_ROOT'] . "/" . $args['portal_root']);
$spool_dir = "/var/spool/tkl";	// This spool dir should *not* be hardcoded (fixme)
$collect_script = "/usr/bin/tkl-getharv";
$spool_file_suffix = ".spl";
//$task_file = $portal_root . "/" . $args[portal_abs_dir] . "/" . $args['tkl_doc'];
$task_file = $args[portal_abs_dir] . "/" . $args['tkl_doc'];
//print_r($task_file . "  " );

if ($args['action'] == 'commit') {	// If document is saved, we create a spool entry...
    $xml_data = $args['xml_data'];
    if (preg_match("/<status>(.*?)<\/status>/", $xml_data, $match)) {
	if ($match[1] == 'collect') {
	    if (is_executable($collect_script)) {
	      system($collect_script . " -r " . $portal_root . " -o " . $task_file . " -d link -v");
	      //system($collect_script . " -r " . $portal_root . " -d link -v");
	    } else {
		die("<b>Fatal:</b> Unable to extract URLs. Non-existent script '$collect_script'");
	    }
	} elseif ($match[1] == 'pending') {
	    if (!is_dir($spool_dir)) {
		die("<b>Fatal:</b> Non-existing TKL spool directory '$spool_dir'");
	    }
	    $tkl_doc = $args['tkl_doc'];
	    $spool_file = preg_replace("/\.tkl$/", "", $tkl_doc) . $spool_file_suffix;
	    $abs_spool_file = "$spool_dir/$spool_file";
	    //if (file_exists($abs_spool_file)) {
	    //	die("<b>Fatal:</b> Spool file '$abs_spool_file' already exists");
	    //}
	    if (!($fh = fopen($abs_spool_file, "w"))) {
		die("<b>Fatal:</b> Unable to open spool file '$abs_spool_file' for writing");
	    }
	    fputs($fh, "$portal_root\n");
	    fputs($fh, preg_replace("/\/+/", "/", $args['portal_abs_dir'] . "/$tkl_doc") . "\n");
	    fclose($fh);
	} elseif ($match[1] == 'running') {
	} elseif ($match[1] == 'finished') {
	}
    } else {
	die("<b>Fatal:</b> Unable to find status information in task file.");
    }
} elseif ($args['action'] == 'cleanup') {
} else {
    echo "<b>Fatal:</b> Unable to handle action type '", $args['action'] , "'";
    die();
}
