/* TRIE: size 547 */
#include <string.h>

        struct yaz_iconv_trie_flat {
            char *from;
            int to;
        };
        struct yaz_iconv_trie_dir {
            struct yaz_iconv_trie *ptr;
            int to;
        };
        
        struct yaz_iconv_trie {
            struct yaz_iconv_trie_flat *flat;
            struct yaz_iconv_trie_dir *dir;
        };
    
/* PAGE 31 */
struct yaz_iconv_trie_flat marc8page31_flat[] = {
  {"\0x4F", 0x1E4C},
  {"\0x6F", 0x1E4D},
  {"\0x55", 0x1E78},
  {"\0x75", 0x1E79},
  {0, 0}
};
struct yaz_iconv_trie marc8page31 = {
  marc8page31_flat, 0
};
/* PAGE 30 */
struct yaz_iconv_trie_flat marc8page30_flat[] = {
  {"\0x49", 0x1E2E},
  {"\0x69", 0x1E2F},
  {"\0x55", 0x01D7},
  {"\0x75", 0x01D8},
  {0, 0}
};
struct yaz_iconv_trie marc8page30 = {
  marc8page30_flat, 0
};
/* PAGE 29 */
struct yaz_iconv_trie_flat marc8page29_flat[] = {
  {"\0x45", 0x1E16},
  {"\0x65", 0x1E17},
  {"\0x4F", 0x1E52},
  {"\0x6F", 0x1E53},
  {0, 0}
};
struct yaz_iconv_trie marc8page29 = {
  marc8page29_flat, 0
};
/* PAGE 28 */
struct yaz_iconv_trie_flat marc8page28_flat[] = {
  {"\0x43", 0x1E08},
  {"\0x63", 0x1E09},
  {0, 0}
};
struct yaz_iconv_trie marc8page28 = {
  marc8page28_flat, 0
};
/* PAGE 27 */
struct yaz_iconv_trie_flat marc8page27_flat[] = {
  {"\0x41", 0x01FA},
  {"\0x41", 0x01FA},
  {"\0x61", 0x01FB},
  {0, 0}
};
struct yaz_iconv_trie marc8page27 = {
  marc8page27_flat, 0
};
/* PAGE 26 */
struct yaz_iconv_trie_flat marc8page26_flat[] = {
  {"\0x41", 0x1EAE},
  {"\0x61", 0x1EAF},
  {0, 0}
};
struct yaz_iconv_trie marc8page26 = {
  marc8page26_flat, 0
};
/* PAGE 25 */
struct yaz_iconv_trie_flat marc8page25_flat[] = {
  {"\0x75", 0x1E73},
  {"\0x55", 0x1E72},
  {0, 0}
};
struct yaz_iconv_trie marc8page25 = {
  marc8page25_flat, 0
};
/* PAGE 24 */
struct yaz_iconv_trie_flat marc8page24_flat[] = {
  {"\0x52", 0x0156},
  {0, 0}
};
struct yaz_iconv_trie marc8page24 = {
  marc8page24_flat, 0
};
/* PAGE 23 */
struct yaz_iconv_trie_flat marc8page23_flat[] = {
  {"\0x4F", 0x0150},
  {"\0x6F", 0x0151},
  {"\0x55", 0x0170},
  {"\0x75", 0x0171},
  {0, 0}
};
struct yaz_iconv_trie marc8page23 = {
  marc8page23_flat, 0
};
/* PAGE 22 */
struct yaz_iconv_trie_flat marc8page22_flat[] = {
  {"\0x6E", 0x0149},
  {0, 0}
};
struct yaz_iconv_trie marc8page22 = {
  marc8page22_flat, 0
};
/* PAGE 21 */
struct yaz_iconv_trie_flat marc8page21_flat[] = {
  {"\0xA8", 0x0140},
  {0, 0}
};
struct yaz_iconv_trie marc8page21 = {
  marc8page21_flat, 0
};
/* PAGE 20 */
struct yaz_iconv_trie_flat marc8page20_flat[] = {
  {"\0xA8", 0x013F},
  {0, 0}
};
struct yaz_iconv_trie marc8page20 = {
  marc8page20_flat, 0
};
/* PAGE 19 */
struct yaz_iconv_trie_flat marc8page19_flat[] = {
  {"\0x48", 0x1E2A},
  {"\0x68", 0x1E2B},
  {0, 0}
};
struct yaz_iconv_trie marc8page19 = {
  marc8page19_flat, 0
};
/* PAGE 18 */
struct yaz_iconv_trie_flat marc8page18_flat[] = {
  {"\0x47", 0x01E4},
  {"\0x67", 0x01E5},
  {"\0x48", 0x0126},
  {"\0x68", 0x0127},
  {0, 0}
};
struct yaz_iconv_trie marc8page18 = {
  marc8page18_flat, 0
};
/* PAGE 17 */
struct yaz_iconv_trie_flat marc8page17_flat[] = {
  {"\0x44", 0x1E10},
  {"\0x64", 0x1E11},
  {"\0x53", 0x0218},
  {"\0x73", 0x0219},
  {"\0x54", 0x021A},
  {"\0x74", 0x021B},
  {0, 0}
};
struct yaz_iconv_trie marc8page17 = {
  marc8page17_flat, 0
};
/* PAGE 16 */
struct yaz_iconv_trie_flat marc8page16_flat[] = {
  {"\0x43", 0x00C7},
  {"\0x63", 0x00E7},
  {"\0x45", 0x0228},
  {"\0x65", 0x0229},
  {"\0x47", 0x0122},
  {"\0x67", 0x0123},
  {"\0x48", 0x1E28},
  {"\0x68", 0x1E29},
  {"\0x4B", 0x0136},
  {"\0x6B", 0x0137},
  {"\0x4C", 0x013B},
  {"\0x6C", 0x013C},
  {"\0x4E", 0x0145},
  {"\0x6E", 0x0146},
  {"\0x72", 0x0157},
  {"\0x53", 0x015E},
  {"\0x73", 0x015F},
  {"\0x54", 0x0162},
  {"\0x74", 0x0163},
  {0, 0}
};
struct yaz_iconv_trie marc8page16 = {
  marc8page16_flat, 0
};
/* PAGE 15 */
struct yaz_iconv_trie_flat marc8page15_flat[] = {
  {"\0x42", 0x1E06},
  {"\0x62", 0x1E07},
  {"\0x44", 0x1E0E},
  {"\0x64", 0x1E0F},
  {"\0x68", 0x1E96},
  {"\0x4B", 0x1E34},
  {"\0x6B", 0x1E35},
  {"\0x4C", 0x1E3A},
  {"\0x6C", 0x1E3B},
  {"\0x4E", 0x1E48},
  {"\0x6E", 0x1E49},
  {"\0x52", 0x1E5E},
  {"\0x72", 0x1E5F},
  {"\0x54", 0x1E6E},
  {"\0x74", 0x1E6F},
  {"\0x5A", 0x1E94},
  {"\0x7A", 0x1E95},
  {0, 0}
};
struct yaz_iconv_trie marc8page15 = {
  marc8page15_flat, 0
};
/* PAGE 14 */
struct yaz_iconv_trie_flat marc8page14_flat[] = {
  {"\0x41", 0x00C4},
  {"\0x61", 0x00E4},
  {"\0x45", 0x00CB},
  {"\0x65", 0x00EB},
  {"\0x48", 0x1E26},
  {"\0x68", 0x1E27},
  {"\0x49", 0x00CF},
  {"\0x69", 0x00EF},
  {"\0xE4\0x4F", 0x1E4E},
  {"\0xE4\0x6F", 0x1E4F},
  {"\0x4F", 0x00D6},
  {"\0x6F", 0x00F6},
  {"\0x74", 0x1E97},
  {"\0xE5\0x55", 0x1E7A},
  {"\0xE5\0x75", 0x1E7B},
  {"\0x55", 0x00DC},
  {"\0x75", 0x00FC},
  {"\0x57", 0x1E84},
  {"\0x77", 0x1E85},
  {"\0x58", 0x1E8C},
  {"\0x78", 0x1E8D},
  {"\0x59", 0x0178},
  {"\0x79", 0x00FF},
  {0, 0}
};
struct yaz_iconv_trie marc8page14 = {
  marc8page14_flat, 0
};
/* PAGE 13 */
struct yaz_iconv_trie_flat marc8page13_flat[] = {
  {"\0x41", 0x00C5},
  {"\0x61", 0x00E5},
  {"\0x55", 0x016E},
  {"\0x75", 0x016F},
  {"\0x77", 0x1E98},
  {"\0x79", 0x1E99},
  {0, 0}
};
struct yaz_iconv_trie marc8page13 = {
  marc8page13_flat, 0
};
/* PAGE 12 */
struct yaz_iconv_trie_flat marc8page12_flat[] = {
  {"\0x41", 0x0104},
  {"\0x61", 0x0105},
  {"\0x45", 0x0118},
  {"\0x65", 0x0119},
  {"\0x49", 0x012E},
  {"\0x69", 0x012F},
  {"\0x4F", 0x01EA},
  {"\0x6F", 0x01EB},
  {"\0x55", 0x0172},
  {"\0x75", 0x0173},
  {0, 0}
};
struct yaz_iconv_trie marc8page12 = {
  marc8page12_flat, 0
};
/* PAGE 11 */
struct yaz_iconv_trie_flat marc8page11_flat[] = {
  {"\0x67\0x61\0x1B\0x73", 0x03B1},
  {"\0x67\0x62\0x1B\0x73", 0x03B2},
  {"\0x67\0x63\0x1B\0x73", 0x03B3},
  {"\0x62\0x30\0x1B\0x73", 0x2080},
  {"\0x62\0x31\0x1B\0x73", 0x2081},
  {"\0x62\0x32\0x1B\0x73", 0x2082},
  {"\0x62\0x33\0x1B\0x73", 0x2083},
  {"\0x62\0x34\0x1B\0x73", 0x2084},
  {"\0x62\0x35\0x1B\0x73", 0x2085},
  {"\0x62\0x36\0x1B\0x73", 0x2086},
  {"\0x62\0x37\0x1B\0x73", 0x2087},
  {"\0x62\0x38\0x1B\0x73", 0x2088},
  {"\0x62\0x39\0x1B\0x73", 0x2089},
  {"\0x62\0x28\0x1B\0x73", 0x208D},
  {"\0x62\0x2D\0x1B\0x73", 0x208B},
  {"\0x62\0x2B\0x1B\0x73", 0x208A},
  {"\0x62\0x29\0x1B\0x73", 0x208E},
  {"\0x70\0x30\0x1B\0x73", 0x2070},
  {"\0x70\0x31\0x1B\0x73", 0x00B9},
  {"\0x70\0x32\0x1B\0x73", 0x00B2},
  {"\0x70\0x33\0x1B\0x73", 0x00B3},
  {"\0x70\0x34\0x1B\0x73", 0x2074},
  {"\0x70\0x35\0x1B\0x73", 0x2075},
  {"\0x70\0x36\0x1B\0x73", 0x2076},
  {"\0x70\0x37\0x1B\0x73", 0x2077},
  {"\0x70\0x38\0x1B\0x73", 0x2078},
  {"\0x70\0x39\0x1B\0x73", 0x2079},
  {"\0x70\0x28\0x1B\0x73", 0x207D},
  {"\0x70\0x2D\0x1B\0x73", 0x207B},
  {"\0x70\0x2B\0x1B\0x73", 0x207A},
  {"\0x70\0x29\0x1B\0x73", 0x207E},
  {0, 0}
};
struct yaz_iconv_trie marc8page11 = {
  marc8page11_flat, 0
};
/* PAGE 10 */
struct yaz_iconv_trie_flat marc8page10_flat[] = {
  {"\0x41", 0x0226},
  {"\0x61", 0x0227},
  {"\0x42", 0x1E02},
  {"\0x62", 0x1E03},
  {"\0x43", 0x010A},
  {"\0x63", 0x010B},
  {"\0x44", 0x1E0A},
  {"\0x64", 0x1E0B},
  {"\0x45", 0x0116},
  {"\0x65", 0x0117},
  {"\0x46", 0x1E1E},
  {"\0x66", 0x1E1F},
  {"\0x47", 0x0120},
  {"\0x67", 0x0121},
  {"\0x48", 0x1E22},
  {"\0x68", 0x1E23},
  {"\0x49", 0x0130},
  {"\0x4D", 0x1E40},
  {"\0x6D", 0x1E41},
  {"\0x4E", 0x1E44},
  {"\0x6E", 0x1E45},
  {"\0x4F", 0x022E},
  {"\0x6F", 0x022F},
  {"\0x50", 0x1E56},
  {"\0x70", 0x1E57},
  {"\0x52", 0x1E58},
  {"\0x72", 0x1E59},
  {"\0xE2\0x53", 0x1E64},
  {"\0xE2\0x73", 0x1E65},
  {"\0xE9\0x53", 0x1E66},
  {"\0xE9\0x73", 0x1E67},
  {"\0x53", 0x1E60},
  {"\0x73", 0x1E61},
  {"\0xF2\0x53", 0x1E68},
  {"\0xF2\0x73", 0x1E69},
  {"\0x54", 0x1E6A},
  {"\0x74", 0x1E6B},
  {"\0x57", 0x1E86},
  {"\0x77", 0x1E87},
  {"\0x58", 0x1E8A},
  {"\0x78", 0x1E8B},
  {"\0x59", 0x1E8E},
  {"\0x79", 0x1E8F},
  {"\0x5A", 0x017B},
  {"\0x7A", 0x017C},
  {0, 0}
};
struct yaz_iconv_trie marc8page10 = {
  marc8page10_flat, 0
};
/* PAGE 9 */
struct yaz_iconv_trie_flat marc8page9_flat[] = {
  {"\0x41", 0x1EA0},
  {"\0x61", 0x1EA1},
  {"\0x42", 0x1E04},
  {"\0x62", 0x1E05},
  {"\0x44", 0x1E0C},
  {"\0x64", 0x1E0D},
  {"\0x45", 0x1EB8},
  {"\0x65", 0x1EB9},
  {"\0x48", 0x1E24},
  {"\0x68", 0x1E25},
  {"\0x49", 0x1ECA},
  {"\0x69", 0x1ECB},
  {"\0x4B", 0x1E32},
  {"\0x6B", 0x1E33},
  {"\0x4C", 0x1E36},
  {"\0x6C", 0x1E37},
  {"\0x4D", 0x1E42},
  {"\0x6D", 0x1E43},
  {"\0x4E", 0x1E46},
  {"\0x6E", 0x1E47},
  {"\0x4F", 0x1ECC},
  {"\0x6F", 0x1ECD},
  {"\0xAC", 0x1EE2},
  {"\0xBC", 0x1EE3},
  {"\0x52", 0x1E5A},
  {"\0x72", 0x1E5B},
  {"\0x53", 0x1E62},
  {"\0x73", 0x1E63},
  {"\0x54", 0x1E6C},
  {"\0x74", 0x1E6D},
  {"\0x55", 0x1EE4},
  {"\0x75", 0x1EE5},
  {"\0xAD", 0x1EF0},
  {"\0xBD", 0x1EF1},
  {"\0x56", 0x1E7E},
  {"\0x76", 0x1E7F},
  {"\0x57", 0x1E88},
  {"\0x77", 0x1E89},
  {"\0x59", 0x1EF4},
  {"\0x79", 0x1EF5},
  {"\0x5A", 0x1E92},
  {"\0x7A", 0x1E93},
  {0, 0}
};
struct yaz_iconv_trie marc8page9 = {
  marc8page9_flat, 0
};
/* PAGE 8 */
struct yaz_iconv_trie_flat marc8page8_flat[] = {
  {"\0xE7\0x41", 0x01E0},
  {"\0xE7\0x61", 0x01E1},
  {"\0xA5", 0x01E2},
  {"\0xB5", 0x01E3},
  {"\0x41", 0x0100},
  {"\0x61", 0x0101},
  {"\0xE8\0x41", 0x01DE},
  {"\0xE8\0x61", 0x01DF},
  {"\0x45", 0x0112},
  {"\0x65", 0x0113},
  {"\0x47", 0x1E20},
  {"\0x67", 0x1E21},
  {"\0x49", 0x012A},
  {"\0x69", 0x012B},
  {"\0xF2\0x4C", 0x1E38},
  {"\0xF2\0x6C", 0x1E39},
  {"\0xE7\0x4F", 0x0230},
  {"\0xE7\0x6F", 0x0231},
  {"\0x4F", 0x014C},
  {"\0x6F", 0x014D},
  {"\0xF1\0x4F", 0x01EC},
  {"\0xF1\0x6F", 0x01ED},
  {"\0xE4\0x4F", 0x022C},
  {"\0xE4\0x6F", 0x022D},
  {"\0xE8\0x4F", 0x022A},
  {"\0xE8\0x6F", 0x022B},
  {"\0x55", 0x016A},
  {"\0x75", 0x016B},
  {"\0xE8\0x55", 0x01D5},
  {"\0xE8\0x75", 0x01D6},
  {"\0x59", 0x0232},
  {"\0x79", 0x0233},
  {0, 0}
};
struct yaz_iconv_trie marc8page8 = {
  marc8page8_flat, 0
};
/* PAGE 7 */
struct yaz_iconv_trie_flat marc8page7_flat[] = {
  {"\0xE2\0x41", 0x1EA4},
  {"\0xE2\0x61", 0x1EA5},
  {"\0xF2\0x41", 0x1EAC},
  {"\0xF2\0x61", 0x1EAD},
  {"\0xE1\0x41", 0x1EA6},
  {"\0xE1\0x61", 0x1EA7},
  {"\0xE0\0x41", 0x1EA8},
  {"\0xE0\0x61", 0x1EA9},
  {"\0x41", 0x00C2},
  {"\0x61", 0x00E2},
  {"\0x43", 0x0108},
  {"\0x63", 0x0109},
  {"\0xE2\0x45", 0x1EBE},
  {"\0xE2\0x65", 0x1EBF},
  {"\0xF2\0x45", 0x1EC6},
  {"\0xF2\0x65", 0x1EC7},
  {"\0xE0\0x45", 0x1EC2},
  {"\0xE0\0x65", 0x1EC3},
  {"\0x45", 0x00CA},
  {"\0x65", 0x00EA},
  {"\0x47", 0x011C},
  {"\0x67", 0x011D},
  {"\0x48", 0x0124},
  {"\0x68", 0x0125},
  {"\0x49", 0x00CE},
  {"\0x69", 0x00EE},
  {"\0x4A", 0x0134},
  {"\0x6A", 0x0135},
  {"\0x4B", 0x01E8},
  {"\0x6B", 0x01E9},
  {"\0x4C", 0x1E3C},
  {"\0x6C", 0x1E3D},
  {"\0xE2\0x4F", 0x1ED0},
  {"\0xE2\0x6F", 0x1ED1},
  {"\0xF2\0x4F", 0x1ED8},
  {"\0xF2\0x6F", 0x1ED9},
  {"\0xE0\0x4F", 0x1ED4},
  {"\0xE0\0x6F", 0x1ED5},
  {"\0x4F", 0x00D4},
  {"\0x6F", 0x00F4},
  {"\0x53", 0x015C},
  {"\0x73", 0x015D},
  {"\0x55", 0x00DB},
  {"\0x75", 0x00FB},
  {"\0x57", 0x0174},
  {"\0x77", 0x0175},
  {"\0x59", 0x0176},
  {"\0x79", 0x0177},
  {"\0x5A", 0x1E90},
  {"\0x7A", 0x1E91},
  {0, 0}
};
struct yaz_iconv_trie marc8page7 = {
  marc8page7_flat, 0
};
/* PAGE 6 */
struct yaz_iconv_trie_flat marc8page6_flat[] = {
  {"\0x41", 0x01CD},
  {"\0x61", 0x01CE},
  {"\0x43", 0x010C},
  {"\0x63", 0x010D},
  {"\0x44", 0x010E},
  {"\0x64", 0x010F},
  {"\0x45", 0x011A},
  {"\0x65", 0x011B},
  {"\0x47", 0x01E6},
  {"\0x67", 0x01E7},
  {"\0x48", 0x021E},
  {"\0x68", 0x021F},
  {"\0x49", 0x01CF},
  {"\0x69", 0x01D0},
  {"\0x6A", 0x01F0},
  {"\0x4C", 0x013D},
  {"\0x6C", 0x013E},
  {"\0x4E", 0x0147},
  {"\0x6E", 0x0148},
  {"\0x4F", 0x01D1},
  {"\0x6F", 0x01D2},
  {"\0x52", 0x0158},
  {"\0x72", 0x0159},
  {"\0x53", 0x0160},
  {"\0x73", 0x0161},
  {"\0x54", 0x0164},
  {"\0x74", 0x0165},
  {"\0x55", 0x01D3},
  {"\0x75", 0x01D4},
  {"\0xE8\0x55", 0x01D9},
  {"\0xE8\0x75", 0x01DA},
  {"\0x5A", 0x017D},
  {"\0x7A", 0x017E},
  {0, 0}
};
struct yaz_iconv_trie marc8page6 = {
  marc8page6_flat, 0
};
/* PAGE 5 */
struct yaz_iconv_trie_flat marc8page5_flat[] = {
  {"\0xE6\0x41", 0x1EB4},
  {"\0xE6\0x61", 0x1EB5},
  {"\0xE3\0x41", 0x1EAA},
  {"\0xE3\0x61", 0x1EAB},
  {"\0x41", 0x00C3},
  {"\0x61", 0x00E3},
  {"\0xE3\0x45", 0x1EC4},
  {"\0x45", 0x1EBC},
  {"\0x65", 0x1EBD},
  {"\0x49", 0x0128},
  {"\0x69", 0x0129},
  {"\0x4E", 0x00D1},
  {"\0x6E", 0x00F1},
  {"\0xE3\0x4F", 0x1ED6},
  {"\0xE3\0x6F", 0x1ED7},
  {"\0xAC", 0x1EE0},
  {"\0xBC", 0x1EE1},
  {"\0x4F", 0x00D5},
  {"\0x6F", 0x00F5},
  {"\0xE3\0x65", 0x1EC5},
  {"\0xAD", 0x1EEE},
  {"\0xBD", 0x1EEF},
  {"\0x55", 0x0168},
  {"\0x75", 0x0169},
  {"\0x56", 0x1E7C},
  {"\0x76", 0x1E7D},
  {"\0x59", 0x1EF8},
  {"\0x79", 0x1EF9},
  {0, 0}
};
struct yaz_iconv_trie marc8page5 = {
  marc8page5_flat, 0
};
/* PAGE 4 */
struct yaz_iconv_trie_flat marc8page4_flat[] = {
  {"\0xE6\0x41", 0x1EB2},
  {"\0xE6\0x61", 0x1EB3},
  {"\0x41", 0x1EA2},
  {"\0x61", 0x1EA3},
  {"\0x45", 0x1EBA},
  {"\0x65", 0x1EBB},
  {"\0x49", 0x1EC8},
  {"\0x69", 0x1EC9},
  {"\0x4F", 0x1ECE},
  {"\0x6F", 0x1ECF},
  {"\0xAC", 0x1EDE},
  {"\0xBC", 0x1EDF},
  {"\0x55", 0x1EE6},
  {"\0x75", 0x1EE7},
  {"\0xAD", 0x1EEC},
  {"\0xBD", 0x1EED},
  {"\0x59", 0x1EF6},
  {"\0x79", 0x1EF7},
  {0, 0}
};
struct yaz_iconv_trie marc8page4 = {
  marc8page4_flat, 0
};
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8page3_flat[] = {
  {"\0xE6\0x41", 0x1EB0},
  {"\0xE6\0x61", 0x1EB1},
  {"\0x41", 0x00C0},
  {"\0x61", 0x00E0},
  {"\0xE3\0x45", 0x1EC0},
  {"\0xE3\0x65", 0x1EC1},
  {"\0x45", 0x00C8},
  {"\0x65", 0x00E8},
  {"\0xE5\0x45", 0x1E14},
  {"\0xE5\0x65", 0x1E15},
  {"\0x49", 0x00CC},
  {"\0x69", 0x00EC},
  {"\0x4E", 0x01F8},
  {"\0x6E", 0x01F9},
  {"\0xE3\0x4F", 0x1ED2},
  {"\0xE3\0x6F", 0x1ED3},
  {"\0x4F", 0x00D2},
  {"\0x6F", 0x00F2},
  {"\0xAC", 0x1EDC},
  {"\0xBC", 0x1EDD},
  {"\0xE5\0x4F", 0x1E50},
  {"\0xE5\0x6F", 0x1E51},
  {"\0x55", 0x00D9},
  {"\0x75", 0x00F9},
  {"\0xAD", 0x1EEA},
  {"\0xBD", 0x1EEB},
  {"\0xE8\0x55", 0x01DB},
  {"\0xE8\0x75", 0x01DC},
  {"\0x57", 0x1E80},
  {"\0x77", 0x1E81},
  {"\0x59", 0x1EF2},
  {"\0x79", 0x1EF3},
  {0, 0}
};
struct yaz_iconv_trie marc8page3 = {
  marc8page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8page2_flat[] = {
  {"\0xF2\0x41", 0x1EB6},
  {"\0xF2\0x61", 0x1EB7},
  {"\0x41", 0x0102},
  {"\0x61", 0x0103},
  {"\0x45", 0x0114},
  {"\0x65", 0x0115},
  {"\0xF0\0x45", 0x1E1C},
  {"\0xF0\0x65", 0x1E1D},
  {"\0x47", 0x011E},
  {"\0x67", 0x011F},
  {"\0x49", 0x012C},
  {"\0x69", 0x012D},
  {"\0x4F", 0x014E},
  {"\0x6F", 0x014F},
  {"\0x55", 0x016C},
  {"\0x75", 0x016D},
  {0, 0}
};
struct yaz_iconv_trie marc8page2 = {
  marc8page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_dir marc8page1_dir[256] = {
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x00C1} /* 41 */,
  {0, 0},
  {0, 0x0106} /* 43 */,
  {0, 0},
  {0, 0x00C9} /* 45 */,
  {0, 0},
  {0, 0x01F4} /* 47 */,
  {0, 0},
  {0, 0x00CD} /* 49 */,
  {0, 0},
  {0, 0x1E30} /* 4B */,
  {0, 0x0139} /* 4C */,
  {0, 0x1E3E} /* 4D */,
  {0, 0x0143} /* 4E */,
  {0, 0x00D3} /* 4F */,
  {0, 0x1E54} /* 50 */,
  {0, 0},
  {0, 0x0154} /* 52 */,
  {0, 0x015A} /* 53 */,
  {0, 0},
  {0, 0x00DA} /* 55 */,
  {0, 0},
  {0, 0x1E82} /* 57 */,
  {0, 0},
  {0, 0x00DD} /* 59 */,
  {0, 0x0179} /* 5A */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x00E1} /* 61 */,
  {0, 0},
  {0, 0x0107} /* 63 */,
  {0, 0},
  {0, 0x00E9} /* 65 */,
  {0, 0},
  {0, 0x01F5} /* 67 */,
  {0, 0},
  {0, 0x00ED} /* 69 */,
  {0, 0},
  {0, 0x1E31} /* 6B */,
  {0, 0x013A} /* 6C */,
  {0, 0x1E3F} /* 6D */,
  {0, 0x0144} /* 6E */,
  {0, 0x00F3} /* 6F */,
  {0, 0x1E55} /* 70 */,
  {0, 0},
  {0, 0x0155} /* 72 */,
  {0, 0x015B} /* 73 */,
  {0, 0},
  {0, 0x00FA} /* 75 */,
  {0, 0},
  {0, 0x1E83} /* 77 */,
  {0, 0},
  {0, 0x00FD} /* 79 */,
  {0, 0x017A} /* 7A */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x01FE} /* A2 */,
  {0, 0},
  {0, 0},
  {0, 0x01FC} /* A5 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x1EDA} /* AC */,
  {0, 0x1EE8} /* AD */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x01FF} /* B2 */,
  {0, 0},
  {0, 0},
  {0, 0x01FD} /* B5 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x1EDB} /* BC */,
  {0, 0x1EE9} /* BD */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page31, 0} /* E4 */,
  {&marc8page29, 0} /* E5 */,
  {&marc8page26, 0} /* E6 */,
  {0, 0},
  {&marc8page30, 0} /* E8 */,
  {0, 0},
  {&marc8page27, 0} /* EA */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page28, 0} /* F0 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0}
};
struct yaz_iconv_trie marc8page1 = {
  0, marc8page1_dir
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8page0_dir[256] = {
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page11, 0} /* 1B */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page20, 0} /* 4C */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page21, 0} /* 6C */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x0141} /* A1 */,
  {0, 0x00D8} /* A2 */,
  {0, 0x0110} /* A3 */,
  {0, 0x00DE} /* A4 */,
  {0, 0x00C6} /* A5 */,
  {0, 0x0152} /* A6 */,
  {0, 0x02B9} /* A7 */,
  {0, 0x00B7} /* A8 */,
  {0, 0x266D} /* A9 */,
  {0, 0x00AE} /* AA */,
  {0, 0x00B1} /* AB */,
  {0, 0x01A0} /* AC */,
  {0, 0x01AF} /* AD */,
  {0, 0x02BE} /* AE */,
  {0, 0},
  {0, 0x02BF} /* B0 */,
  {0, 0x0142} /* B1 */,
  {0, 0x00F8} /* B2 */,
  {0, 0x0111} /* B3 */,
  {0, 0x00FE} /* B4 */,
  {0, 0x00E6} /* B5 */,
  {0, 0x0153} /* B6 */,
  {0, 0x02BA} /* B7 */,
  {0, 0x0131} /* B8 */,
  {0, 0x00A3} /* B9 */,
  {0, 0x00F0} /* BA */,
  {0, 0},
  {0, 0x01A1} /* BC */,
  {0, 0x01B0} /* BD */,
  {0, 0},
  {0, 0},
  {0, 0x00B0} /* C0 */,
  {0, 0x2113} /* C1 */,
  {0, 0x2117} /* C2 */,
  {0, 0x00A9} /* C3 */,
  {0, 0x266F} /* C4 */,
  {0, 0x00BF} /* C5 */,
  {0, 0x00A1} /* C6 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page4, 0x0309} /* E0 */,
  {&marc8page3, 0x0300} /* E1 */,
  {&marc8page1, 0x0301} /* E2 */,
  {&marc8page7, 0x0302} /* E3 */,
  {&marc8page5, 0x0303} /* E4 */,
  {&marc8page8, 0x0304} /* E5 */,
  {&marc8page2, 0x0306} /* E6 */,
  {&marc8page10, 0x0307} /* E7 */,
  {&marc8page14, 0x0308} /* E8 */,
  {&marc8page6, 0x030C} /* E9 */,
  {&marc8page13, 0x030A} /* EA */,
  {0, 0xFE20} /* EB */,
  {0, 0xFE21} /* EC */,
  {&marc8page22, 0x0315} /* ED */,
  {&marc8page23, 0x030B} /* EE */,
  {0, 0x0310} /* EF */,
  {&marc8page16, 0x0327} /* F0 */,
  {&marc8page12, 0x0328} /* F1 */,
  {&marc8page9, 0x0323} /* F2 */,
  {&marc8page25, 0x0324} /* F3 */,
  {0, 0x0325} /* F4 */,
  {&marc8page18, 0x0333} /* F5 */,
  {&marc8page15, 0x0332} /* F6 */,
  {&marc8page17, 0x0326} /* F7 */,
  {&marc8page24, 0x031C} /* F8 */,
  {&marc8page19, 0x032E} /* F9 */,
  {0, 0xFE22} /* FA */,
  {0, 0xFE23} /* FB */,
  {0, 0},
  {0, 0},
  {0, 0x0313} /* FE */,
  {0, 0}
};
struct yaz_iconv_trie marc8page0 = {
  0, marc8page0_dir
};

        static unsigned long lookup(struct yaz_iconv_trie *t, unsigned char *inp,
                                    size_t inbytesleft, size_t *no_read)
        {
            if (!t || inbytesleft < 1)
            return 0;
            if (t->dir)
            {
                size_t ch = inp[0] & 0xff;
                unsigned long code =
                lookup(t->dir[ch].ptr, inp+1, inbytesleft-1, no_read);
                if (code)
                {
                    (*no_read)++;
                    return code;
                }
                if (t->dir[ch].to)
                {
                    code = t->dir[ch].to;
                    *no_read = 1;
                    return code;
                }
            }
            else
            {
                struct yaz_iconv_trie_flat *flat = t->flat;
                while (flat->from)
                {
                    size_t len = strlen(flat->from);
                    if (len >= inbytesleft)
                    {
                        if (memcmp(flat->from, inp, len) == 0)
                        {
                            *no_read = len;
                            return flat->to;
                        }
                    }
                    flat++;
                }
            }
            return 0;
        }
        
    
unsigned long yaz_marc8_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read)
        {
            unsigned long code;
            
            code = lookup(&marc8page0, inp, inbytesleft, no_read);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
