/* TRIE: size 547 */
#include <string.h>

        struct yaz_iconv_trie_flat {
            char *from;
            int to;
        };
        struct yaz_iconv_trie_dir {
            struct yaz_iconv_trie *ptr;
            int to;
        };
        
        struct yaz_iconv_trie {
            struct yaz_iconv_trie_flat *flat;
            struct yaz_iconv_trie_dir *dir;
        };
    
/* PAGE 31 */
struct yaz_iconv_trie_flat marc8page31_flat[] = {
  {"\x4F", 0x1E4C},
  {"\x6F", 0x1E4D},
  {"\x55", 0x1E78},
  {"\x75", 0x1E79},
  {0, 0}
};
struct yaz_iconv_trie marc8page31 = {
  marc8page31_flat, 0
};
/* PAGE 30 */
struct yaz_iconv_trie_flat marc8page30_flat[] = {
  {"\x49", 0x1E2E},
  {"\x69", 0x1E2F},
  {"\x55", 0x01D7},
  {"\x75", 0x01D8},
  {0, 0}
};
struct yaz_iconv_trie marc8page30 = {
  marc8page30_flat, 0
};
/* PAGE 29 */
struct yaz_iconv_trie_flat marc8page29_flat[] = {
  {"\x45", 0x1E16},
  {"\x65", 0x1E17},
  {"\x4F", 0x1E52},
  {"\x6F", 0x1E53},
  {0, 0}
};
struct yaz_iconv_trie marc8page29 = {
  marc8page29_flat, 0
};
/* PAGE 28 */
struct yaz_iconv_trie_flat marc8page28_flat[] = {
  {"\x43", 0x1E08},
  {"\x63", 0x1E09},
  {0, 0}
};
struct yaz_iconv_trie marc8page28 = {
  marc8page28_flat, 0
};
/* PAGE 27 */
struct yaz_iconv_trie_flat marc8page27_flat[] = {
  {"\x41", 0x01FA},
  {"\x41", 0x01FA},
  {"\x61", 0x01FB},
  {0, 0}
};
struct yaz_iconv_trie marc8page27 = {
  marc8page27_flat, 0
};
/* PAGE 26 */
struct yaz_iconv_trie_flat marc8page26_flat[] = {
  {"\x41", 0x1EAE},
  {"\x61", 0x1EAF},
  {0, 0}
};
struct yaz_iconv_trie marc8page26 = {
  marc8page26_flat, 0
};
/* PAGE 25 */
struct yaz_iconv_trie_flat marc8page25_flat[] = {
  {"\x75", 0x1E73},
  {"\x55", 0x1E72},
  {0, 0}
};
struct yaz_iconv_trie marc8page25 = {
  marc8page25_flat, 0
};
/* PAGE 24 */
struct yaz_iconv_trie_flat marc8page24_flat[] = {
  {"\x52", 0x0156},
  {0, 0}
};
struct yaz_iconv_trie marc8page24 = {
  marc8page24_flat, 0
};
/* PAGE 23 */
struct yaz_iconv_trie_flat marc8page23_flat[] = {
  {"\x4F", 0x0150},
  {"\x6F", 0x0151},
  {"\x55", 0x0170},
  {"\x75", 0x0171},
  {0, 0}
};
struct yaz_iconv_trie marc8page23 = {
  marc8page23_flat, 0
};
/* PAGE 22 */
struct yaz_iconv_trie_flat marc8page22_flat[] = {
  {"\x6E", 0x0149},
  {0, 0}
};
struct yaz_iconv_trie marc8page22 = {
  marc8page22_flat, 0
};
/* PAGE 21 */
struct yaz_iconv_trie_flat marc8page21_flat[] = {
  {"\xA8", 0x0140},
  {0, 0}
};
struct yaz_iconv_trie marc8page21 = {
  marc8page21_flat, 0
};
/* PAGE 20 */
struct yaz_iconv_trie_flat marc8page20_flat[] = {
  {"\xA8", 0x013F},
  {0, 0}
};
struct yaz_iconv_trie marc8page20 = {
  marc8page20_flat, 0
};
/* PAGE 19 */
struct yaz_iconv_trie_flat marc8page19_flat[] = {
  {"\x48", 0x1E2A},
  {"\x68", 0x1E2B},
  {0, 0}
};
struct yaz_iconv_trie marc8page19 = {
  marc8page19_flat, 0
};
/* PAGE 18 */
struct yaz_iconv_trie_flat marc8page18_flat[] = {
  {"\x47", 0x01E4},
  {"\x67", 0x01E5},
  {"\x48", 0x0126},
  {"\x68", 0x0127},
  {0, 0}
};
struct yaz_iconv_trie marc8page18 = {
  marc8page18_flat, 0
};
/* PAGE 17 */
struct yaz_iconv_trie_flat marc8page17_flat[] = {
  {"\x44", 0x1E10},
  {"\x64", 0x1E11},
  {"\x53", 0x0218},
  {"\x73", 0x0219},
  {"\x54", 0x021A},
  {"\x74", 0x021B},
  {0, 0}
};
struct yaz_iconv_trie marc8page17 = {
  marc8page17_flat, 0
};
/* PAGE 16 */
struct yaz_iconv_trie_flat marc8page16_flat[] = {
  {"\x43", 0x00C7},
  {"\x63", 0x00E7},
  {"\x45", 0x0228},
  {"\x65", 0x0229},
  {"\x47", 0x0122},
  {"\x67", 0x0123},
  {"\x48", 0x1E28},
  {"\x68", 0x1E29},
  {"\x4B", 0x0136},
  {"\x6B", 0x0137},
  {"\x4C", 0x013B},
  {"\x6C", 0x013C},
  {"\x4E", 0x0145},
  {"\x6E", 0x0146},
  {"\x72", 0x0157},
  {"\x53", 0x015E},
  {"\x73", 0x015F},
  {"\x54", 0x0162},
  {"\x74", 0x0163},
  {0, 0}
};
struct yaz_iconv_trie marc8page16 = {
  marc8page16_flat, 0
};
/* PAGE 15 */
struct yaz_iconv_trie_flat marc8page15_flat[] = {
  {"\x42", 0x1E06},
  {"\x62", 0x1E07},
  {"\x44", 0x1E0E},
  {"\x64", 0x1E0F},
  {"\x68", 0x1E96},
  {"\x4B", 0x1E34},
  {"\x6B", 0x1E35},
  {"\x4C", 0x1E3A},
  {"\x6C", 0x1E3B},
  {"\x4E", 0x1E48},
  {"\x6E", 0x1E49},
  {"\x52", 0x1E5E},
  {"\x72", 0x1E5F},
  {"\x54", 0x1E6E},
  {"\x74", 0x1E6F},
  {"\x5A", 0x1E94},
  {"\x7A", 0x1E95},
  {0, 0}
};
struct yaz_iconv_trie marc8page15 = {
  marc8page15_flat, 0
};
/* PAGE 14 */
struct yaz_iconv_trie_flat marc8page14_flat[] = {
  {"\x41", 0x00C4},
  {"\x61", 0x00E4},
  {"\x45", 0x00CB},
  {"\x65", 0x00EB},
  {"\x48", 0x1E26},
  {"\x68", 0x1E27},
  {"\x49", 0x00CF},
  {"\x69", 0x00EF},
  {"\xE4\x4F", 0x1E4E},
  {"\xE4\x6F", 0x1E4F},
  {"\x4F", 0x00D6},
  {"\x6F", 0x00F6},
  {"\x74", 0x1E97},
  {"\xE5\x55", 0x1E7A},
  {"\xE5\x75", 0x1E7B},
  {"\x55", 0x00DC},
  {"\x75", 0x00FC},
  {"\x57", 0x1E84},
  {"\x77", 0x1E85},
  {"\x58", 0x1E8C},
  {"\x78", 0x1E8D},
  {"\x59", 0x0178},
  {"\x79", 0x00FF},
  {0, 0}
};
struct yaz_iconv_trie marc8page14 = {
  marc8page14_flat, 0
};
/* PAGE 13 */
struct yaz_iconv_trie_flat marc8page13_flat[] = {
  {"\x41", 0x00C5},
  {"\x61", 0x00E5},
  {"\x55", 0x016E},
  {"\x75", 0x016F},
  {"\x77", 0x1E98},
  {"\x79", 0x1E99},
  {0, 0}
};
struct yaz_iconv_trie marc8page13 = {
  marc8page13_flat, 0
};
/* PAGE 12 */
struct yaz_iconv_trie_flat marc8page12_flat[] = {
  {"\x41", 0x0104},
  {"\x61", 0x0105},
  {"\x45", 0x0118},
  {"\x65", 0x0119},
  {"\x49", 0x012E},
  {"\x69", 0x012F},
  {"\x4F", 0x01EA},
  {"\x6F", 0x01EB},
  {"\x55", 0x0172},
  {"\x75", 0x0173},
  {0, 0}
};
struct yaz_iconv_trie marc8page12 = {
  marc8page12_flat, 0
};
/* PAGE 11 */
struct yaz_iconv_trie_flat marc8page11_flat[] = {
  {"\x67\x61\x1B\x73", 0x03B1},
  {"\x67\x62\x1B\x73", 0x03B2},
  {"\x67\x63\x1B\x73", 0x03B3},
  {"\x62\x30\x1B\x73", 0x2080},
  {"\x62\x31\x1B\x73", 0x2081},
  {"\x62\x32\x1B\x73", 0x2082},
  {"\x62\x33\x1B\x73", 0x2083},
  {"\x62\x34\x1B\x73", 0x2084},
  {"\x62\x35\x1B\x73", 0x2085},
  {"\x62\x36\x1B\x73", 0x2086},
  {"\x62\x37\x1B\x73", 0x2087},
  {"\x62\x38\x1B\x73", 0x2088},
  {"\x62\x39\x1B\x73", 0x2089},
  {"\x62\x28\x1B\x73", 0x208D},
  {"\x62\x2D\x1B\x73", 0x208B},
  {"\x62\x2B\x1B\x73", 0x208A},
  {"\x62\x29\x1B\x73", 0x208E},
  {"\x70\x30\x1B\x73", 0x2070},
  {"\x70\x31\x1B\x73", 0x00B9},
  {"\x70\x32\x1B\x73", 0x00B2},
  {"\x70\x33\x1B\x73", 0x00B3},
  {"\x70\x34\x1B\x73", 0x2074},
  {"\x70\x35\x1B\x73", 0x2075},
  {"\x70\x36\x1B\x73", 0x2076},
  {"\x70\x37\x1B\x73", 0x2077},
  {"\x70\x38\x1B\x73", 0x2078},
  {"\x70\x39\x1B\x73", 0x2079},
  {"\x70\x28\x1B\x73", 0x207D},
  {"\x70\x2D\x1B\x73", 0x207B},
  {"\x70\x2B\x1B\x73", 0x207A},
  {"\x70\x29\x1B\x73", 0x207E},
  {0, 0}
};
struct yaz_iconv_trie marc8page11 = {
  marc8page11_flat, 0
};
/* PAGE 10 */
struct yaz_iconv_trie_flat marc8page10_flat[] = {
  {"\x41", 0x0226},
  {"\x61", 0x0227},
  {"\x42", 0x1E02},
  {"\x62", 0x1E03},
  {"\x43", 0x010A},
  {"\x63", 0x010B},
  {"\x44", 0x1E0A},
  {"\x64", 0x1E0B},
  {"\x45", 0x0116},
  {"\x65", 0x0117},
  {"\x46", 0x1E1E},
  {"\x66", 0x1E1F},
  {"\x47", 0x0120},
  {"\x67", 0x0121},
  {"\x48", 0x1E22},
  {"\x68", 0x1E23},
  {"\x49", 0x0130},
  {"\x4D", 0x1E40},
  {"\x6D", 0x1E41},
  {"\x4E", 0x1E44},
  {"\x6E", 0x1E45},
  {"\x4F", 0x022E},
  {"\x6F", 0x022F},
  {"\x50", 0x1E56},
  {"\x70", 0x1E57},
  {"\x52", 0x1E58},
  {"\x72", 0x1E59},
  {"\xE2\x53", 0x1E64},
  {"\xE2\x73", 0x1E65},
  {"\xE9\x53", 0x1E66},
  {"\xE9\x73", 0x1E67},
  {"\x53", 0x1E60},
  {"\x73", 0x1E61},
  {"\xF2\x53", 0x1E68},
  {"\xF2\x73", 0x1E69},
  {"\x54", 0x1E6A},
  {"\x74", 0x1E6B},
  {"\x57", 0x1E86},
  {"\x77", 0x1E87},
  {"\x58", 0x1E8A},
  {"\x78", 0x1E8B},
  {"\x59", 0x1E8E},
  {"\x79", 0x1E8F},
  {"\x5A", 0x017B},
  {"\x7A", 0x017C},
  {0, 0}
};
struct yaz_iconv_trie marc8page10 = {
  marc8page10_flat, 0
};
/* PAGE 9 */
struct yaz_iconv_trie_flat marc8page9_flat[] = {
  {"\x41", 0x1EA0},
  {"\x61", 0x1EA1},
  {"\x42", 0x1E04},
  {"\x62", 0x1E05},
  {"\x44", 0x1E0C},
  {"\x64", 0x1E0D},
  {"\x45", 0x1EB8},
  {"\x65", 0x1EB9},
  {"\x48", 0x1E24},
  {"\x68", 0x1E25},
  {"\x49", 0x1ECA},
  {"\x69", 0x1ECB},
  {"\x4B", 0x1E32},
  {"\x6B", 0x1E33},
  {"\x4C", 0x1E36},
  {"\x6C", 0x1E37},
  {"\x4D", 0x1E42},
  {"\x6D", 0x1E43},
  {"\x4E", 0x1E46},
  {"\x6E", 0x1E47},
  {"\x4F", 0x1ECC},
  {"\x6F", 0x1ECD},
  {"\xAC", 0x1EE2},
  {"\xBC", 0x1EE3},
  {"\x52", 0x1E5A},
  {"\x72", 0x1E5B},
  {"\x53", 0x1E62},
  {"\x73", 0x1E63},
  {"\x54", 0x1E6C},
  {"\x74", 0x1E6D},
  {"\x55", 0x1EE4},
  {"\x75", 0x1EE5},
  {"\xAD", 0x1EF0},
  {"\xBD", 0x1EF1},
  {"\x56", 0x1E7E},
  {"\x76", 0x1E7F},
  {"\x57", 0x1E88},
  {"\x77", 0x1E89},
  {"\x59", 0x1EF4},
  {"\x79", 0x1EF5},
  {"\x5A", 0x1E92},
  {"\x7A", 0x1E93},
  {0, 0}
};
struct yaz_iconv_trie marc8page9 = {
  marc8page9_flat, 0
};
/* PAGE 8 */
struct yaz_iconv_trie_flat marc8page8_flat[] = {
  {"\xE7\x41", 0x01E0},
  {"\xE7\x61", 0x01E1},
  {"\xA5", 0x01E2},
  {"\xB5", 0x01E3},
  {"\x41", 0x0100},
  {"\x61", 0x0101},
  {"\xE8\x41", 0x01DE},
  {"\xE8\x61", 0x01DF},
  {"\x45", 0x0112},
  {"\x65", 0x0113},
  {"\x47", 0x1E20},
  {"\x67", 0x1E21},
  {"\x49", 0x012A},
  {"\x69", 0x012B},
  {"\xF2\x4C", 0x1E38},
  {"\xF2\x6C", 0x1E39},
  {"\xE7\x4F", 0x0230},
  {"\xE7\x6F", 0x0231},
  {"\x4F", 0x014C},
  {"\x6F", 0x014D},
  {"\xF1\x4F", 0x01EC},
  {"\xF1\x6F", 0x01ED},
  {"\xE4\x4F", 0x022C},
  {"\xE4\x6F", 0x022D},
  {"\xE8\x4F", 0x022A},
  {"\xE8\x6F", 0x022B},
  {"\x55", 0x016A},
  {"\x75", 0x016B},
  {"\xE8\x55", 0x01D5},
  {"\xE8\x75", 0x01D6},
  {"\x59", 0x0232},
  {"\x79", 0x0233},
  {0, 0}
};
struct yaz_iconv_trie marc8page8 = {
  marc8page8_flat, 0
};
/* PAGE 7 */
struct yaz_iconv_trie_flat marc8page7_flat[] = {
  {"\xE2\x41", 0x1EA4},
  {"\xE2\x61", 0x1EA5},
  {"\xF2\x41", 0x1EAC},
  {"\xF2\x61", 0x1EAD},
  {"\xE1\x41", 0x1EA6},
  {"\xE1\x61", 0x1EA7},
  {"\xE0\x41", 0x1EA8},
  {"\xE0\x61", 0x1EA9},
  {"\x41", 0x00C2},
  {"\x61", 0x00E2},
  {"\x43", 0x0108},
  {"\x63", 0x0109},
  {"\xE2\x45", 0x1EBE},
  {"\xE2\x65", 0x1EBF},
  {"\xF2\x45", 0x1EC6},
  {"\xF2\x65", 0x1EC7},
  {"\xE0\x45", 0x1EC2},
  {"\xE0\x65", 0x1EC3},
  {"\x45", 0x00CA},
  {"\x65", 0x00EA},
  {"\x47", 0x011C},
  {"\x67", 0x011D},
  {"\x48", 0x0124},
  {"\x68", 0x0125},
  {"\x49", 0x00CE},
  {"\x69", 0x00EE},
  {"\x4A", 0x0134},
  {"\x6A", 0x0135},
  {"\x4B", 0x01E8},
  {"\x6B", 0x01E9},
  {"\x4C", 0x1E3C},
  {"\x6C", 0x1E3D},
  {"\xE2\x4F", 0x1ED0},
  {"\xE2\x6F", 0x1ED1},
  {"\xF2\x4F", 0x1ED8},
  {"\xF2\x6F", 0x1ED9},
  {"\xE0\x4F", 0x1ED4},
  {"\xE0\x6F", 0x1ED5},
  {"\x4F", 0x00D4},
  {"\x6F", 0x00F4},
  {"\x53", 0x015C},
  {"\x73", 0x015D},
  {"\x55", 0x00DB},
  {"\x75", 0x00FB},
  {"\x57", 0x0174},
  {"\x77", 0x0175},
  {"\x59", 0x0176},
  {"\x79", 0x0177},
  {"\x5A", 0x1E90},
  {"\x7A", 0x1E91},
  {0, 0}
};
struct yaz_iconv_trie marc8page7 = {
  marc8page7_flat, 0
};
/* PAGE 6 */
struct yaz_iconv_trie_flat marc8page6_flat[] = {
  {"\x41", 0x01CD},
  {"\x61", 0x01CE},
  {"\x43", 0x010C},
  {"\x63", 0x010D},
  {"\x44", 0x010E},
  {"\x64", 0x010F},
  {"\x45", 0x011A},
  {"\x65", 0x011B},
  {"\x47", 0x01E6},
  {"\x67", 0x01E7},
  {"\x48", 0x021E},
  {"\x68", 0x021F},
  {"\x49", 0x01CF},
  {"\x69", 0x01D0},
  {"\x6A", 0x01F0},
  {"\x4C", 0x013D},
  {"\x6C", 0x013E},
  {"\x4E", 0x0147},
  {"\x6E", 0x0148},
  {"\x4F", 0x01D1},
  {"\x6F", 0x01D2},
  {"\x52", 0x0158},
  {"\x72", 0x0159},
  {"\x53", 0x0160},
  {"\x73", 0x0161},
  {"\x54", 0x0164},
  {"\x74", 0x0165},
  {"\x55", 0x01D3},
  {"\x75", 0x01D4},
  {"\xE8\x55", 0x01D9},
  {"\xE8\x75", 0x01DA},
  {"\x5A", 0x017D},
  {"\x7A", 0x017E},
  {0, 0}
};
struct yaz_iconv_trie marc8page6 = {
  marc8page6_flat, 0
};
/* PAGE 5 */
struct yaz_iconv_trie_flat marc8page5_flat[] = {
  {"\xE6\x41", 0x1EB4},
  {"\xE6\x61", 0x1EB5},
  {"\xE3\x41", 0x1EAA},
  {"\xE3\x61", 0x1EAB},
  {"\x41", 0x00C3},
  {"\x61", 0x00E3},
  {"\xE3\x45", 0x1EC4},
  {"\x45", 0x1EBC},
  {"\x65", 0x1EBD},
  {"\x49", 0x0128},
  {"\x69", 0x0129},
  {"\x4E", 0x00D1},
  {"\x6E", 0x00F1},
  {"\xE3\x4F", 0x1ED6},
  {"\xE3\x6F", 0x1ED7},
  {"\xAC", 0x1EE0},
  {"\xBC", 0x1EE1},
  {"\x4F", 0x00D5},
  {"\x6F", 0x00F5},
  {"\xE3\x65", 0x1EC5},
  {"\xAD", 0x1EEE},
  {"\xBD", 0x1EEF},
  {"\x55", 0x0168},
  {"\x75", 0x0169},
  {"\x56", 0x1E7C},
  {"\x76", 0x1E7D},
  {"\x59", 0x1EF8},
  {"\x79", 0x1EF9},
  {0, 0}
};
struct yaz_iconv_trie marc8page5 = {
  marc8page5_flat, 0
};
/* PAGE 4 */
struct yaz_iconv_trie_flat marc8page4_flat[] = {
  {"\xE6\x41", 0x1EB2},
  {"\xE6\x61", 0x1EB3},
  {"\x41", 0x1EA2},
  {"\x61", 0x1EA3},
  {"\x45", 0x1EBA},
  {"\x65", 0x1EBB},
  {"\x49", 0x1EC8},
  {"\x69", 0x1EC9},
  {"\x4F", 0x1ECE},
  {"\x6F", 0x1ECF},
  {"\xAC", 0x1EDE},
  {"\xBC", 0x1EDF},
  {"\x55", 0x1EE6},
  {"\x75", 0x1EE7},
  {"\xAD", 0x1EEC},
  {"\xBD", 0x1EED},
  {"\x59", 0x1EF6},
  {"\x79", 0x1EF7},
  {0, 0}
};
struct yaz_iconv_trie marc8page4 = {
  marc8page4_flat, 0
};
/* PAGE 3 */
struct yaz_iconv_trie_flat marc8page3_flat[] = {
  {"\xE6\x41", 0x1EB0},
  {"\xE6\x61", 0x1EB1},
  {"\x41", 0x00C0},
  {"\x61", 0x00E0},
  {"\xE3\x45", 0x1EC0},
  {"\xE3\x65", 0x1EC1},
  {"\x45", 0x00C8},
  {"\x65", 0x00E8},
  {"\xE5\x45", 0x1E14},
  {"\xE5\x65", 0x1E15},
  {"\x49", 0x00CC},
  {"\x69", 0x00EC},
  {"\x4E", 0x01F8},
  {"\x6E", 0x01F9},
  {"\xE3\x4F", 0x1ED2},
  {"\xE3\x6F", 0x1ED3},
  {"\x4F", 0x00D2},
  {"\x6F", 0x00F2},
  {"\xAC", 0x1EDC},
  {"\xBC", 0x1EDD},
  {"\xE5\x4F", 0x1E50},
  {"\xE5\x6F", 0x1E51},
  {"\x55", 0x00D9},
  {"\x75", 0x00F9},
  {"\xAD", 0x1EEA},
  {"\xBD", 0x1EEB},
  {"\xE8\x55", 0x01DB},
  {"\xE8\x75", 0x01DC},
  {"\x57", 0x1E80},
  {"\x77", 0x1E81},
  {"\x59", 0x1EF2},
  {"\x79", 0x1EF3},
  {0, 0}
};
struct yaz_iconv_trie marc8page3 = {
  marc8page3_flat, 0
};
/* PAGE 2 */
struct yaz_iconv_trie_flat marc8page2_flat[] = {
  {"\xF2\x41", 0x1EB6},
  {"\xF2\x61", 0x1EB7},
  {"\x41", 0x0102},
  {"\x61", 0x0103},
  {"\x45", 0x0114},
  {"\x65", 0x0115},
  {"\xF0\x45", 0x1E1C},
  {"\xF0\x65", 0x1E1D},
  {"\x47", 0x011E},
  {"\x67", 0x011F},
  {"\x49", 0x012C},
  {"\x69", 0x012D},
  {"\x4F", 0x014E},
  {"\x6F", 0x014F},
  {"\x55", 0x016C},
  {"\x75", 0x016D},
  {0, 0}
};
struct yaz_iconv_trie marc8page2 = {
  marc8page2_flat, 0
};
/* PAGE 1 */
struct yaz_iconv_trie_dir marc8page1_dir[256] = {
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x00C1} /* 41 */,
  {0, 0},
  {0, 0x0106} /* 43 */,
  {0, 0},
  {0, 0x00C9} /* 45 */,
  {0, 0},
  {0, 0x01F4} /* 47 */,
  {0, 0},
  {0, 0x00CD} /* 49 */,
  {0, 0},
  {0, 0x1E30} /* 4B */,
  {0, 0x0139} /* 4C */,
  {0, 0x1E3E} /* 4D */,
  {0, 0x0143} /* 4E */,
  {0, 0x00D3} /* 4F */,
  {0, 0x1E54} /* 50 */,
  {0, 0},
  {0, 0x0154} /* 52 */,
  {0, 0x015A} /* 53 */,
  {0, 0},
  {0, 0x00DA} /* 55 */,
  {0, 0},
  {0, 0x1E82} /* 57 */,
  {0, 0},
  {0, 0x00DD} /* 59 */,
  {0, 0x0179} /* 5A */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x00E1} /* 61 */,
  {0, 0},
  {0, 0x0107} /* 63 */,
  {0, 0},
  {0, 0x00E9} /* 65 */,
  {0, 0},
  {0, 0x01F5} /* 67 */,
  {0, 0},
  {0, 0x00ED} /* 69 */,
  {0, 0},
  {0, 0x1E31} /* 6B */,
  {0, 0x013A} /* 6C */,
  {0, 0x1E3F} /* 6D */,
  {0, 0x0144} /* 6E */,
  {0, 0x00F3} /* 6F */,
  {0, 0x1E55} /* 70 */,
  {0, 0},
  {0, 0x0155} /* 72 */,
  {0, 0x015B} /* 73 */,
  {0, 0},
  {0, 0x00FA} /* 75 */,
  {0, 0},
  {0, 0x1E83} /* 77 */,
  {0, 0},
  {0, 0x00FD} /* 79 */,
  {0, 0x017A} /* 7A */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x01FE} /* A2 */,
  {0, 0},
  {0, 0},
  {0, 0x01FC} /* A5 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x1EDA} /* AC */,
  {0, 0x1EE8} /* AD */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x01FF} /* B2 */,
  {0, 0},
  {0, 0},
  {0, 0x01FD} /* B5 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x1EDB} /* BC */,
  {0, 0x1EE9} /* BD */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page31, 0} /* E4 */,
  {&marc8page29, 0} /* E5 */,
  {&marc8page26, 0} /* E6 */,
  {0, 0},
  {&marc8page30, 0} /* E8 */,
  {0, 0},
  {&marc8page27, 0} /* EA */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page28, 0} /* F0 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0}
};
struct yaz_iconv_trie marc8page1 = {
  0, marc8page1_dir
};
/* PAGE 0 */
struct yaz_iconv_trie_dir marc8page0_dir[256] = {
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page11, 0} /* 1B */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page20, 0} /* 4C */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page21, 0} /* 6C */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0x0141} /* A1 */,
  {0, 0x00D8} /* A2 */,
  {0, 0x0110} /* A3 */,
  {0, 0x00DE} /* A4 */,
  {0, 0x00C6} /* A5 */,
  {0, 0x0152} /* A6 */,
  {0, 0x02B9} /* A7 */,
  {0, 0x00B7} /* A8 */,
  {0, 0x266D} /* A9 */,
  {0, 0x00AE} /* AA */,
  {0, 0x00B1} /* AB */,
  {0, 0x01A0} /* AC */,
  {0, 0x01AF} /* AD */,
  {0, 0x02BE} /* AE */,
  {0, 0},
  {0, 0x02BF} /* B0 */,
  {0, 0x0142} /* B1 */,
  {0, 0x00F8} /* B2 */,
  {0, 0x0111} /* B3 */,
  {0, 0x00FE} /* B4 */,
  {0, 0x00E6} /* B5 */,
  {0, 0x0153} /* B6 */,
  {0, 0x02BA} /* B7 */,
  {0, 0x0131} /* B8 */,
  {0, 0x00A3} /* B9 */,
  {0, 0x00F0} /* BA */,
  {0, 0},
  {0, 0x01A1} /* BC */,
  {0, 0x01B0} /* BD */,
  {0, 0},
  {0, 0},
  {0, 0x00B0} /* C0 */,
  {0, 0x2113} /* C1 */,
  {0, 0x2117} /* C2 */,
  {0, 0x00A9} /* C3 */,
  {0, 0x266F} /* C4 */,
  {0, 0x00BF} /* C5 */,
  {0, 0x00A1} /* C6 */,
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {0, 0},
  {&marc8page4, 0x0309} /* E0 */,
  {&marc8page3, 0x0300} /* E1 */,
  {&marc8page1, 0x0301} /* E2 */,
  {&marc8page7, 0x0302} /* E3 */,
  {&marc8page5, 0x0303} /* E4 */,
  {&marc8page8, 0x0304} /* E5 */,
  {&marc8page2, 0x0306} /* E6 */,
  {&marc8page10, 0x0307} /* E7 */,
  {&marc8page14, 0x0308} /* E8 */,
  {&marc8page6, 0x030C} /* E9 */,
  {&marc8page13, 0x030A} /* EA */,
  {0, 0xFE20} /* EB */,
  {0, 0xFE21} /* EC */,
  {&marc8page22, 0x0315} /* ED */,
  {&marc8page23, 0x030B} /* EE */,
  {0, 0x0310} /* EF */,
  {&marc8page16, 0x0327} /* F0 */,
  {&marc8page12, 0x0328} /* F1 */,
  {&marc8page9, 0x0323} /* F2 */,
  {&marc8page25, 0x0324} /* F3 */,
  {0, 0x0325} /* F4 */,
  {&marc8page18, 0x0333} /* F5 */,
  {&marc8page15, 0x0332} /* F6 */,
  {&marc8page17, 0x0326} /* F7 */,
  {&marc8page24, 0x031C} /* F8 */,
  {&marc8page19, 0x032E} /* F9 */,
  {0, 0xFE22} /* FA */,
  {0, 0xFE23} /* FB */,
  {0, 0},
  {0, 0},
  {0, 0x0313} /* FE */,
  {0, 0}
};
struct yaz_iconv_trie marc8page0 = {
  0, marc8page0_dir
};

        static unsigned long lookup(struct yaz_iconv_trie *t, unsigned char *inp,
                                    size_t inbytesleft, size_t *no_read)
        {
            if (!t || inbytesleft < 1)
            return 0;
            if (t->dir)
            {
                size_t ch = inp[0] & 0xff;
                unsigned long code =
                lookup(t->dir[ch].ptr, inp+1, inbytesleft-1, no_read);
                if (code)
                {
                    (*no_read)++;
                    return code;
                }
                if (t->dir[ch].to)
                {
                    code = t->dir[ch].to;
                    *no_read = 1;
                    return code;
                }
            }
            else
            {
                struct yaz_iconv_trie_flat *flat = t->flat;
                while (flat->from)
                {
                    size_t len = strlen(flat->from);
                    if (len <= inbytesleft)
                    {
                        if (memcmp(flat->from, inp, len) == 0)
                        {
                            *no_read = len;
                            return flat->to;
                        }
                    }
                    flat++;
                }
            }
            return 0;
        }
        
    
unsigned long yaz_marc8_conv
            (unsigned char *inp, size_t inbytesleft, size_t *no_read)
        {
            unsigned long code;
            
            code = lookup(&marc8page0, inp, inbytesleft, no_read);
            if (!code)
            {
                *no_read = 1;
                code = *inp;
            }
            return code;
        }
    
