/*
 * ZAP! Z39.50 Apache Module
 * 
 * Copyright (C) 1999-2001, Index Data ApS
 * See the file ZAP_LICENSE for details.
 *
 * $Id: zap.h,v 1.17 2001/07/10 13:20:00 adam Exp $
 */

#define ZAP_VERSION "1.1"
#define ZAP_DATE "$Date: 2001/07/10 13:20:00 $"

#ifndef USE_APACHE
# define USE_APACHE 1
#endif

#ifndef USE_TCL
# define USE_TCL 0
#endif

#ifndef USE_ES
# define USE_ES 0
#endif

#ifndef ZAP_CONF
# ifdef WIN32
#  define ZAP_CONF "/inetpub/wwwroot"
# else
#  define ZAP_CONF "/usr/local/apache/htdocs/zap"
# endif
#endif

#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <signal.h>
#include <errno.h>

#if USE_APACHE
# include "httpd.h"
# include "http_config.h"
# include "http_core.h"
# include "http_protocol.h"
# include "http_main.h"
# include "util_script.h"
# include "http_request.h"

# if APACHE_RELEASE >= 1030100

# endif
# ifndef ZAP_LOG
#  define ZAP_LOG  "logs/zap_log"
# endif
#else
# ifndef ZAP_LOG
#   define ZAP_LOG  "/tmp/zap_log"
# endif
# ifdef WIN32
#  include <time.h>
#  include <io.h>
# else
#  include <unistd.h>
# endif
#endif

#include <yaz/comstack.h>
#include <yaz/tcpip.h>
#include <yaz/odr.h>
#include <yaz/proto.h>
#include <yaz/pquery.h>
#include <yaz/diagbib1.h>
#include <yaz/otherinfo.h>
#include <yaz/wrbuf.h>
#include <yaz/marcdisp.h>
#include <yaz/yaz-version.h>
#include <yaz/yaz-ccl.h>

#if USE_TCL
# include <tcl.h>
#endif

#define ZAP_COOKIE "zap=\""

#if USE_APACHE
typedef struct {
    char *log_name;
    int log_file;

    char *apdu_name;
    FILE *apdu_file;
} zap_server_conf;

typedef struct {
    char *auth_type;
} zap_dir_conf;

extern module zap_module;
#endif

# define assert(expr)                                                         \
  ((void) ((expr) ? 0 :                                                       \
           (zap_assert_fail (req, __FILE__, __LINE__))))


typedef struct symbolEntry *Symbol;

struct symbolEntry {
    char *name;
    char *value;
    Symbol next;
};

typedef struct {
    Symbol list;
    Symbol *last;
} *Symtab;

typedef struct TemplateEntry *Template;

typedef struct {
    Symtab args;
    Symtab def;
    Symtab override;
} PA;

typedef struct {
#if USE_APACHE
    request_rec *request;
    zap_server_conf *conf;
#else
    char *script_name;
#endif
    Z_GenericRecord *grs1_vars_rec_rel;
    Z_GenericRecord *grs1_vars_rec_abs;
    const char *marc_vars_buf;
    int zap_debug;
    int zap_timeout;
#if USE_TCL
    Tcl_Interp *tcl_interp;
#endif
#ifndef WIN32
    struct timeval start_time;
#endif
    CCL_parser ccl_parser;
    PA *cur_pa;
    Template curTemplate;
    Symtab curVars;
    char *html_buffer;
    int html_len;
    int html_max;

    int pending_targets;
    char *output_buf;
    int output_len;
    int output_max;
    char *cookie_buf;
    char *cookie_zap;
    int cookies_sent;
    char *result;
} ZapRequest;

typedef struct TargetInfo *Target;

struct TargetInfo {
    char *name;
    char *rawName;
    char *fullName;
    char *proxy;
    COMSTACK cs;
    Target next;
    int state;
    int order;
    int parent_order;
    int reconnectFlag;
    int mask_select;
    int timeout;

    char *buf_out;
    int len_out;
    ODR odr_out;

    char *buf_in;
    int len_in;
    ODR odr_in;

    ODR odr_print;

    int queryType;
    char *queryString;

    char *cookie;
    
    NMEM search_nmem;
    Z_NamePlusRecordList *recordList;
    int resultCount;
    int presentStart;
    int presentNumber;
    char *elementSetNames;
    char *schema;
    char *preferredRecordSyntax;

    void (*connectResponse)(ZapRequest *req, Target t);
    void (*apduResponse)(ZapRequest *req, Target t, Z_APDU *apdu);
    int (*action)(ZapRequest *req, Target t);
};

int sendES (ZapRequest *req, Target t);
void esResponse (ZapRequest *req, Target t,
		 Z_ExtendedServicesResponse *res);

const char *symbolLookupFormStr (ZapRequest *req,
				 const char *name, const char *def);

void zlog (ZapRequest *req, const char *m1, const char *m2);

int targetSendAPDU (ZapRequest *req, Target t, Z_APDU *a);
void html_dump (ZapRequest *req, const char *head);
int responseDiag (ZapRequest *req, Target t, Z_DiagRec *p);

void html_var (ZapRequest *req, const char *name, const char *value);
void html_var_num (ZapRequest *req, const char *name, int val);
void html_var_n (ZapRequest *req, const char *name,
		 const char *buf, int n);

