/*
 * ZAP! Z39.50 Apache Module
 * 
 * Copyright (C) 1999-2006, Index Data ApS
 * See the file ZAP_LICENSE for details.
 *
 * $Id: zap.h,v 1.37 2008-10-06 18:51:08 adam Exp $
 */

#define ZAP_VERSION "1.4.10"
#define ZAP_DATE "$Date: 2008-10-06 18:51:08 $"

#ifndef USE_APACHE
# define USE_APACHE 1
#endif

#ifndef USE_TCL
# define USE_TCL 0
#endif

#ifndef USE_ES
# define USE_ES 0
#endif

#ifndef ZAP_CONF
# ifdef WIN32
#  define ZAP_CONF "/inetpub/wwwroot"
# else
#  define ZAP_CONF "/usr/local/apache/htdocs/zap"
# endif
#endif

#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <signal.h>
#include <errno.h>

#undef PACKAGE_NAME
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_STRING
#undef PACKAGE_BUGREPORT

#if USE_APACHE
# include "httpd.h"
# include "http_config.h"
# include "http_core.h"
# include "http_protocol.h"
# include "http_main.h"
# include "util_script.h"
# include "http_request.h"

# if APACHE_RELEASE >= 1030100

# endif
# ifndef ZAP_LOG
#  define ZAP_LOG  "logs/zap_log"
# endif
#else
# ifndef ZAP_LOG
#   define ZAP_LOG  "/tmp/zap_log"
# endif
# ifdef WIN32
#  include <time.h>
#  include <io.h>
# else
#  include <unistd.h>
# endif
#endif

#include <yaz/comstack.h>
#include <yaz/tcpip.h>
#include <yaz/odr.h>
#include <yaz/proto.h>
#include <yaz/pquery.h>
#include <yaz/diagbib1.h>
#include <yaz/otherinfo.h>
#include <yaz/wrbuf.h>
#include <yaz/marcdisp.h>
#include <yaz/yaz-version.h>
#include <yaz/yaz-ccl.h>

#if USE_TCL
# define USE_NON_CONST
# include <tcl.h>
#endif

#define APACHE2 0
#define ZAP_COOKIE "zap=\""


#if USE_APACHE

/* Check for Apache 2 */
#ifdef AP_SERVER_VERSION

#if AP_SERVER_MAJORVERSION_NUMBER == 2 && AP_SERVER_MINORVERSION_NUMBER == 0
/* Apache 2.0 .. */
#include "apr_compat.h"

#else

#define ap_copy_table apr_table_copy
#define ap_cpystrn apr_cpystrn
#define ap_destroy_pool apr_pool_destroy
#define ap_isspace apr_isspace
#define ap_make_array apr_array_make
#define ap_make_table apr_table_make
#define ap_null_cleanup apr_pool_cleanup_null
#define ap_palloc apr_palloc
#define ap_pcalloc apr_pcalloc
#define ap_psprintf apr_psprintf
#define ap_pstrcat apr_pstrcat
#define ap_pstrdup apr_pstrdup
#define ap_pstrndup apr_pstrndup
#define ap_push_array apr_array_push 
#define ap_register_cleanup apr_pool_cleanup_register 
#define ap_snprintf apr_snprintf
#define ap_table_add apr_table_add
#define ap_table_do apr_table_do
#define ap_table_get apr_table_get
#define ap_table_set apr_table_set
#define ap_table_setn apr_table_setn
#define ap_table_unset apr_table_unset



#include "ap_compat.h"
#endif

#undef APACHE2
#define APACHE2 1

#define ZAP_FILE_FD apr_file_t *
#define ZAP_FILE_OPEN_RD(fname, pool, fd) \
  apr_file_open(&fd, fname, APR_READ, 0, pool)
#define ZAP_FILE_OPEN_WD(fname, pool, fd) \
  apr_file_open(&fd, fname, APR_WRITE|APR_CREATE|APR_APPEND, APR_OS_DEFAULT, pool)

#define ZAP_FILE_GETS(str, len, fd) (apr_file_gets(str, len, fd) == APR_SUCCESS ? 1 : 0)
#define ZAP_FILE_WRITE(buf, len, fd) { \
   apr_size_t alen = len; \
   apr_file_write(fd, buf, &alen); }
#define ZAP_FILE_CLOSE(pool, fd) apr_file_close(fd);
#define ZAP_FILE_FLUSH(fd) apr_file_flush(fd)

#else
/* Apache 1 .. */
#define apr_pool_t pool

#define ZAP_FILE_FD FILE *
#define ZAP_FILE_OPEN_RD(fname, pool, fd) \
  fd = ap_pfopen(pool, fname, "r")
#define ZAP_FILE_OPEN_WD(fname, pool, fd) \
  fd = ap_pfopen(pool, fname, "a")
#define ZAP_FILE_GETS(str, len, fd)  fgets(str, len, fd)
#define ZAP_FILE_WRITE(buf, len, fd) fwrite(buf, 1, len, fd)
#define ZAP_FILE_CLOSE(pool, fd) ap_pfclose (pool, fd)
#define ZAP_FILE_FLUSH(fd) fflush(fd)

#endif
typedef struct {
    const char *log_name;
    ZAP_FILE_FD log_file;

    const char *apdu_name;
    FILE *apdu_file;
} zap_server_conf;

typedef struct {
    char *auth_type;
} zap_dir_conf;

extern module zap_module;
#else
#define ZAP_FILE_FD FILE *
#define ZAP_FILE_OPEN_RD(fname, pool, fd) \
  fd = fopen(fname, "r")
#define ZAP_FILE_OPEN_WD(fname, pool, fd) \
  fd = fopen(fname, "a")
#define ZAP_FILE_GETS(str, len, fd) fgets(str, len, fd)
#define ZAP_FILE_WRITE(buf, len, fd) fwrite(buf, 1, len, fd)
#define ZAP_FILE_CLOSE(pool, fd) fclose(fd)

/* CGI */
#endif

# define assert(expr)                                                         \
  ((void) ((expr) ? 0 :                                                       \
           (zap_assert_fail (req, __FILE__, __LINE__))))


typedef struct symbolEntry *Symbol;

struct symbolEntry {
    char *name;
    char *value;
    Symbol next;
};

typedef struct {
    Symbol list;
    Symbol *last;
} *Symtab;

typedef struct TemplateEntry *Template;

typedef struct {
    Symtab args;
    Symtab def;
    Symtab override;
} PA;

typedef struct {
#if USE_APACHE
    zap_server_conf *conf;



    request_rec *request;




#else
    char *script_name;
#endif
    Z_GenericRecord *grs1_vars_rec_rel;
    Z_GenericRecord *grs1_vars_rec_abs;
    const char *marc_vars_buf;
    int zap_debug;
    int zap_timeout;
#if USE_TCL
    Tcl_Interp *tcl_interp;
#endif
#ifndef WIN32
    struct timeval start_time;
#endif
    CCL_bibset ccl_bibset;
    PA *cur_pa;
    Template curTemplate;
    Symtab curVars;
    char *html_buffer;
    int html_len;
    int html_max;

    int pending_targets;
    char *output_buf;
    int output_len;
    int output_max;
    char *cookie_buf;
    char *cookie_zap;
    int cookies_sent;
    char *result;
} ZapRequest;

typedef struct TargetInfo *Target;

struct TargetInfo {
    char *name;
    char *rawName;
    char *fullName;
    char *proxy;
    COMSTACK cs;
    Target next;
    int state;
    int order;
    int parent_order;
    int reconnectFlag;
    int mask_select;
    int timeout;

    char *buf_out;
    int len_out;
    ODR odr_out;

    char *buf_in;
    int len_in;
    ODR odr_in;

    ODR odr_print;

    int queryType;
    char *queryString;

    char *cookie;
    
    NMEM search_nmem;
    Z_NamePlusRecordList *recordList;
    char **sortList;
    int resultCount;
    int presentStart;
    int presentNumber;
    int presentPos;
    char *elementSetNames;
    char *schema;
    char *preferredRecordSyntax;

    void (*connectResponse)(ZapRequest *req, Target t);
    void (*apduResponse)(ZapRequest *req, Target t, Z_APDU *apdu);
    int (*action)(ZapRequest *req, Target t);
};

int sendES (ZapRequest *req, Target t);
void esResponse (ZapRequest *req, Target t,
		 Z_ExtendedServicesResponse *res);

const char *symbolLookupFormStr (ZapRequest *req,
				 const char *name, const char *def);

void zlog (ZapRequest *req, const char *m1, const char *m2);

int targetSendAPDU (ZapRequest *req, Target t, Z_APDU *a);
void html_dump (ZapRequest *req, const char *head);
int responseDiag (ZapRequest *req, Target t, Z_DiagRec *p);

void html_var (ZapRequest *req, const char *name, const char *value);
void html_var_num (ZapRequest *req, const char *name, int val);
void html_var_n (ZapRequest *req, const char *name,
		 const char *buf, int n);

