#!/bin/bash

# test for cproxy-mp


# Choose the system-installed MP, or one installed parallel to this project
MP="../../../metaproxy/src/metaproxy"
if [ ! -x $MP ]
then
  MP="metaproxy"
fi
echo "Using metaproxy at `which $MP`"

rm -f debug*.log

LOGFILE="debug-yaz.log"
touch $LOGFILE

LOG="-l $LOGFILE"  

#.../cproxydebug-7/...
# 1 debug trace
# 2 verbose (implies 1)
# 4 stop after preprocessing, only debug output
# 7 all of above

PIDFILE="./mp.pid"

rm -f debug*.log

if ! $MP -c ./flurryconfig.xml  -p $PIDFILE $LOG -D >debug-stdout.log 2>&1
then
  echo "Failed to start MP"
  cat $LOGFILE
  exit 1
fi

PID=`cat $PIDFILE`
echo "MP started. PID=$PID"
sleep 0.1 # let it start up properly

rm -rf /tmp/cf.17 /tmp/cf.17.dump
cat > /tmp/cf.17 <<END
CfSession 17
#Referer http://www.indexdata.com/software/
#Username someuser
#Password secretpassword
#Proxyip 1.2.3.4
Cookie www.indexdata.com; one=ONE
END
echo "Created a simple dummy session 17"


