%define idmetaversion %(. ./IDMETA; echo $VERSION|tr -d '\n')
%define is_centos5 %(grep 'release 5' /etc/redhat-release >/dev/null && echo 1 || echo 0)
%define xulrunnerver 10.0.2
%define xulrunnertar xulrunner-%{xulrunnerver}.source.tar.bz2
Summary: Xulrunner for CF
Name: cf-xulrunner
Version: %{idmetaversion}
Release: 3indexdata
BuildRequires: gcc gcc-c++ pkgconfig
# BuildRequires: xorg-x11-devel 
BuildRequires: zip unzip
%if %is_centos5
BuildRequires: python26
%endif
BuildRequires: mesa-libGL-devel
BuildRequires: wget
BuildRequires: gtk2-devel
BuildRequires: libXt-devel
License: BSD
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.dk>
Source: cf-xulrunner-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Adam Dickmeiss <adam@indexdata.dk>
URL: http://www.indexdata.com/connector-framework

%description
Xulrunner tailored for the Connector Framework.

%package -n cf-xulrunner10
Summary: Xulrunner libraries
Group: Applications/Internet

%description -n cf-xulrunner10
This is Xulrunner libraries tailored for the Connector Framework.

%package -n cf-xulrunner10-devel
Summary: Development package for cf-xulrunner10
Group: Applications/Internet
Requires: cf-xulrunner10 = %{version}
%description -n cf-xulrunner10-devel
Xulrunner development libraries.

%prep
%setup

%build
if ! bunzip2 -t %{xulrunnertar}; then
	wget -q http://ftp.indexdata.dk/pub/support/%{xulrunnertar}
fi
rm -fr mozilla-release
tar jxf %{xulrunnertar}
cat mozconfig.rpm mozconfig >mozilla-release/.mozconfig
cd mozilla-release; for p in ../*.patch; do patch -p1 < $p; done
make -f client.mk build
cd ..

# ------ INSTALL --------
%install
rm -fr ${RPM_BUILD_ROOT}
cd mozilla-release
make -f client.mk install DESTDIR=${RPM_BUILD_ROOT}
rm -fr ${RPM_BUILD_ROOT}/usr/cf-xulrunner/bin

%clean
rm -fr ${RPM_BUILD_ROOT}

%files -n cf-xulrunner10
%defattr(-,root,root)
/usr/cf-xulrunner/lib64/xulrunner-10.0.2
%files -n cf-xulrunner10-devel
%defattr(-,root,root)
/usr/cf-xulrunner/include
/usr/cf-xulrunner/lib64/pkgconfig
/usr/cf-xulrunner/lib64/xulrunner-devel-10.0.2
/usr/cf-xulrunner/share
