%define idmetaversion %(. ./IDMETA; printf $VERSION )
Summary: CF Content Proxy
Name: cf-proxy
Version: %{idmetaversion}
Release: 1indexdata
BuildRequires: gcc gcc-c++ pkgconfig 
BuildRequires: libmetaproxy4-devel >= 1.3.62
Requires: metaproxy >= 1.3.62
License: proprietary
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.dk>
Source: cf-proxy-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Heikki Levanto <heikki@indexdata.dk>
URL: http://www.indexdata.com/connector-framework

%description
Connector Framework Content Proxy 

%prep
%setup

%pre
# Check that apache is not listening on port 80!!!
if [ -x /usr/bin/curl ] && /usr/bin/curl -s localhost >/dev/null
then
    echo
    echo "Something (Apache?) is listening on port 80. Can not install cproxy"
    echo
    exit 1
fi

%post
if [ -d /usr/lib64/metaproxy4/modules ]; then
       	if [ ! -e /usr/lib64/metaproxy4/modules/metaproxy_filter_cproxy.so ]; then
		ln -s /usr/lib64/cf-proxy/metaproxy_filter_cproxy.so /usr/lib64/metaproxy4/modules
	fi
fi
if [ -d /etc/metaproxy/ports.d -a -d  /etc/metaproxy/routes.d ]; then
    if [ ! -e /etc/metaproxy/ports.d/cf-proxy.port.xml ]; then
        ln -s /etc/cf-proxy/cf-proxy.port.xml /etc/metaproxy/ports.d
    fi
    if [ ! -e /etc/metaproxy/routes.d/cf-proxy.route.xml ]; then
        ln -s /etc/cf-proxy/cf-proxy.route.xml /etc/metaproxy/routes.d
    fi
    if [ -f /var/run/metaproxy.pid ]; then
        /sbin/service metaproxy restart
    fi
fi

%preun
if [ $1 = 0 ]; then
    rm -f /etc/metaproxy/ports.d/cf-proxy.port.xml
    rm -f /etc/metaproxy/routes.d/cf-proxy.route.xml
    if [ -f /var/run/metaproxy.pid ]; then
        /sbin/service metaproxy restart
    fi
fi


# ------ BUILD --------
%build
cd src
make clean
make \
	OPT_FLAGS="-g -O" \
	MP_CONFIG=/usr/bin/metaproxy-config

# Docs need no making

# ------ INSTALL --------
%install
rm -fr ${RPM_BUILD_ROOT}

# install
mkdir -p ${RPM_BUILD_ROOT}/usr/share/cf-proxy
cp README ${RPM_BUILD_ROOT}/usr/share/cf-proxy
cd src
make DESTDIR=${RPM_BUILD_ROOT} libdir=%{_libdir} install

%clean
rm -fr ${RPM_BUILD_ROOT}


%files
%defattr(-,root,root)
%{_libdir}/cf-proxy/*.so
/usr/share/cf-proxy/README
%config(noreplace) /etc/cf-proxy/cproxy.cfg
%config(noreplace) /etc/cf-proxy/cproxyrewrite.xml
%config(noreplace) /etc/cf-proxy/cf-proxy.route.xml
%config(noreplace) /etc/cf-proxy/cf-proxy.port.xml
