#!/bin/bash
# Fetch or update all git projects needed to compile
#
# Assumes they all live under the same directory as cproxy-mp itself, as in
#   .../proj/cproxy-mp
#   .../proj/yaz
#   .../proj/metaproxy
#
# Script to be started in .../cproxy-mp/src
#

DIRS="yaz yazpp metaproxy"

DIR=`pwd`
cd ../.. # now in .../proj
BUILDIT="no"

for D in $DIRS
do
    echo "========= $D"
    if [ -d $D ]
    then
        echo "Updating $D"
        cd $D
        GITOUTPUT=`git pull`
        if [ "$GITOUTPUT" != "Already up-to-date." ]
        then
            BUILDIT="yes"
            # forces building this, and all that follows!
        fi
        echo $GITOUTPUT
        cd ..
    else
        echo "Fetching $D"
        git clone ssh://git.indexdata.com:222/home/git/pub/$D
        BUILDIT="yes"
    fi

    cd $D
    if [ $BUILDIT == "yes" ]
    then
        ./buildconf.sh -d && make && make check && echo "$D checks ok"
        RC=$?
        if [ $RC != 0 ]
        then
            echo "Something failed in $D (rc=$RC)"
            exit $RC
        fi
    fi
    make && echo "$D OK"
    RC=$?
    if [ $RC != 0 ]
    then
        echo "make failed in $D (rc=$RC)"
        exit $RC
    fi
    cd ..
    echo
done

cd $DIR
echo "======== `pwd`"
make clean
git pull
make && make check && echo "Everything looks fine"
# need to make clean, to be sure to link with the latest libraries