#!/bin/bash

# test for cproxy-mp

echo "Running tests in `pwd`"

# Choose the system-installed MP, or one installed parallel to this project
MP="../../../metaproxy/src/metaproxy"
if [ ! -x $MP ]
then
  MP="metaproxy"
fi
echo "Using metaproxy at `which $MP`"

LOGFILE="debug-yaz.log"
touch $LOGFILE

LOG="-l $LOGFILE"  

#.../cproxydebug-7/...
# 1 debug trace
# 2 verbose (implies 1)
# 4 stop after preprocessing, only debug output
# 7 all of above

PIDFILE="./mp.pid"

rm -f debug*.log

if ! $MP -c ./intconfig.xml  -p $PIDFILE $LOG -D >debug-stdout.log 2>&1
then
  echo "Failed to start MP"
  cat $LOGFILE
  exit 1
fi

PID=`cat $PIDFILE`
echo "MP started. PID=$PID"
sleep 0.1 # let it start up properly

# Create a cf session, always number 17
# Make a fake session
rm -rf /tmp/cf.17*

cat > /tmp/cf.17 <<END
CfSession 17
Referer http://www.indexdata.com/software/
Username someuser
Password secretpassword
Proxyip 1.2.3.4
Cookie .abc-clio.com; s_vi=[CS]v1|27607D7C051D3307-6000013580121069[CE]
Cookie .lsd.dk; foo=bar
Cookie www.lsd.dk; bar=www
Cookie other.lsd.dk; other=other
END

# Make a dump directory for it too
mkdir /tmp/cf.17.dump
chmod 777 /tmp/cf.17.dump
   # so apache can write there too, in other tests


# helper to grep a given filefor a given string. If not found, outputs
# a message, stops MP
#  $1 file to grep in
#  $2 string to grep for
#  $3 lineno (use $LINENO when calling)
#  $4 message (optional)
check_file() {
    if [ ! "$3" ]   # sanity check, verify we have remembered the $LINENO
    then
      echo Missing lineno in test
      echo $2
      kill $PID || echo "Failed to kill MP (pid $PID) "
      echo "(stopped MP $PID)"
      exit 1
    fi
    if ! grep  -q "$2" $1
    then
      echo " $3 FAIL!"
      echo $1
      cat $1
      echo
      echo TEST on line $3 FAILED: $4
      echo "Failed to grep $1 for"
      echo "  $2"
      kill $PID || echo "Failed to kill MP (pid $PID) "
      echo "(stopped MP $PID)"
      exit 1
    fi
    echo -n "$3 "
}

# Check yaz log for a string. Note that the yaz log contains all requests,
# not only the current test. use check_output when ever possible
check_yaz_log() {
    check_file "debug-yaz.log" "$1" "$2" "$3"
}

# Check the output of a test. This is overwritten every time we invoke
# curl, so it only has stuff from the latest request.
check_output() {
    check_file "debug-output.log" "$1" "$2" "$3"
}

######################
echo
echo "Test 1: Trivial checks"
URL="http://localhost:9036/XXX/node102/cproxydebug-2/17/flurry.indexdata.dk/heikki2/foo.html"

echo curl -s -S -D - $URL 
curl -s -S -D - $URL > debug-output.log
# -s for silent mode, -S for showing errors anyway -D - for dumpinge headers
head -1  debug-output.log
echo -n "Tests: "
check_yaz_log "config tag 'proxyhostname' value 'localhost:9036/XXX/node102'" $LINENO
check_yaz_log "Using debug level" $LINENO
check_output  "200 OK" $LINENO
check_output  "Using debug level" $LINENO
check_output  "session '17'" $LINENO
echo " OK"


############### OK, stop 
echo
echo "Stopping MP  $PID"
kill $PID || ( echo "Failed to kill MP (pid $PID). Aborting"; exit 1 )
rm $PIDFILE

echo All tests OK
exit 0
