var EXPORTED_SYMBOLS = ["Comment"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');

var Comment = function (body) {
  this.body = body || "";
};

Comment.prototype.draw = function (surface) {
  context = this;
  let attributes = {
    "multiline": true, "rows": 30,
    "flex": 1,
    "align":"stretch",
    "value":this.body
  };
  let input = xmlHelper.appendNode(surface, "textbox", null, attributes, null);
  input.addEventListener("input", function(e) {
    context.body = input.value;
  }, false);
};

Comment.prototype.loadConf = function (node) {
  this.body = node.nodeValue;
};

Comment.prototype.clone = function () {
  let clone = new this.constructor();
  clone.body = this.body;
  clone.date = this.date;
  return clone;
};

Comment.prototype.getClassName = function () {
  return "Comment";
};
