var EXPORTED_SYMBOLS = ["Tester"];

Components.utils.import('resource://indexdata/runtime/TaskUnitTest.js');

var Tester = function () {
  this.tests = [];
};
Tester.prototype = {
  addTest: function (test) {
    this.tests.push(test);
  },
  prependTest: function (test) {
    this.tests.unshift(test);
  },
  run: function (successMsg, failMsg) {
    var tester = this;
    var nextToRun = 0;
    for (var i=0; i<this.tests.length; i++) {
      // chain success
      this.tests[i].onTestSuccess = function () {
        nextToRun += 1;
        if (nextToRun >= tester.tests.length) {
          if (successMsg) dump(successMsg + "\n");
          if (tester.onTestSuccess) tester.onTestSuccess();
        } else {
          tester.tests[nextToRun].run();
        }
      };
      //failure
      this.tests[i].onTestFailure = function () {
        if (failMsg) dump(failMsg +"\n");
        if (tester.onTestFailure) tester.onTestFailure();
      };
    }
    tester.tests[nextToRun].run();
  },

  // returns true if a test case based on the specified order
  // can be created, otherwise returns false
  runInOrder: function (connector, taskOrderString) {
    var taskOrder = taskOrderString.split(",");
    if (taskOrder.length === 0) return false;
    
    var followOrder = function (prevTest, taskOrder, pos) {
      //return nop tester on leafs
      if (pos >= taskOrder.length) return null;
      var nextInOrder = taskOrder[pos];
      //optional item?
      var opt = false;
      if (nextInOrder.charAt(nextInOrder.length-1) == "?") {
        nextInOrder = nextInOrder.slice(0,-1);
        opt = true;
      }
      var tasks = connector.findTasks(nextInOrder);
      //skip missing optional tasks
      if (tasks === null && opt) {
        dump("skipping missing, optional test "+nextInOrder+"\n");
        return followOrder(prevTest, taskOrder, pos+1);
      }
      //prepare test bag
      var tester = null;
      if (tasks !== null) { //fill test bag with children
        for (var i=0; i<tasks.length; i++) {
          var tests = tasks[i].getTests();
          if (tests === null || tests.length === 0) {
            //in case no tests are defined, but we are following a 'Default' path
            //create a dummy test
            if (prevTest.getName() === "Default") {
              dump("generating dummy 'Default' test for "+tasks[i].name
                  +", since no tests exist\n");
              tests = [new TaskUnitTest(tasks[i],'Default')];
            } else {
              continue;
            }
          }
          for (var j=0; j<tests.length; j++) {
            if (prevTest === null || 
                tests[j].getName() === prevTest.getName()) {
              dump("include test for "+tasks[i].name+"/"+tests[j]._name+"\n");
              //lazy init
              if (tester === null) tester = new Tester();
              tester.addTest(tests[j]);
              var t = followOrder(tests[j], taskOrder, pos+1);
              if (t !== null) tester.addTest(t);
            }
          } 
        }
      }
      return tester;
    };

    var tester = followOrder(null, taskOrder, 0);
    if (tester === null) {
      dump("Given test string results in an empty test suite, " +
          "check if all tasks contain corresponding tests.");
      return false;
    }
    this.addTest(tester);
    dump("Test suite started." + "\n");
    this.run("Test suite finished OK.", "Test suite failed.");
    return true;
  }
};
