var EXPORTED_SYMBOLS = ["Assert"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Assert = function () {
  this.conf = {};
  this.conf['target'] = '';
  //this.conf['operator'] = 'regex';  // not used
  this.conf['constantoperand'] = '';
  this.conf['error'] = '';
  this.conf['mode'] = "miss";
  this.conf.succeed = false;
};
Assert.prototype = new Step();
Assert.prototype.constructor = Assert;

Assert.prototype.init = function() {};

Assert.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context = this;
  var captionWidth = 140;

  var hbox = xmlHelper.appendNode(surface, "hbox", null, {align:"center"});
  xulHelper.captionField(hbox, "Container", { width: captionWidth });
  xulHelper.jsonPathField(hbox, this, this.conf, "target");

  xulHelper.inputField(surface, this, "constantoperand", "Regular expression",
                       captionWidth, { flex:1 });

  var mbox = xmlHelper.appendNode(surface, "hbox");
  var modes = { "always": "always",
                "match": "if pattern matches",
                "miss": "if pattern does NOT match",
                "empty": "if there is no value",
                "value": "if there is a (non-empty) value",
  };
  xulHelper.selectField(mbox, this, 'mode', "Fail task", modes);
  xulHelper.checkbox(mbox, this, 'succeed', 'end task with success');
  
  var hbox2 = xmlHelper.appendNode(surface, "hbox", null, {align:"center"});
  xulHelper.captionField(hbox2, "Error", { width: captionWidth });
  var hboxCode = xmlHelper.appendNode(hbox2, "hbox", null, {align:"center"});
  xulHelper.captionField(hboxCode, "Code:", {width: 50});
  xulHelper.arraySelectField(hbox2, this, 'errorCode',
      this.task.connector.template.errorCodes,
      {});
  xulHelper.inputField(hbox2, this, "error", "Message:",
      80, { flex:1 });
};

Assert.prototype.run = function (task) {
  var target = this.conf['target'];
  var assertionMsg = target.path+"."+target.key
    +" ~ " + this.conf['constantoperand'];
  var value =  jsonPathHelper.getFirst(target, task.data);
  if (typeof(value) != "string" ) {
      value = ""; // protect against undef values, see bug 4172
  }
  var trigger = false;
  
  if (this.conf.mode == "miss" ) {
    trigger = ! value.match(new RegExp(this.conf['constantoperand']));
  } else if (this.conf.mode == "match" ) {
    trigger = value.match(new RegExp(this.conf['constantoperand']));
  } else if (this.conf.mode == "always" ) {
    trigger = true;
  } else if (this.conf.mode == "empty" ) {
    trigger = ( value == "" );
  } else if (this.conf.mode == "value" ) {
    trigger = ( value != "" );
  }
  //if (value.match(new RegExp(this.conf['constantoperand']))) {
  if (! trigger) {
    task.info("Assertion ("+assertionMsg+") passed", this);
    return;
  } else {
    var msg = jsonPathHelper.inlineReplace(this.conf['error'], task.data);
    if (this.conf.succeed) {
      task.info("Assertion (" + assertionMsg +") failed, task complete; exiting.", this);
      task.info(msg);
      this.task.complete();
      return;
    } else {
      if (this.conf['errorCode']) msg = this.conf['errorCode'] + ":" + msg;
      //only warn since error might be handled with an ALT step
      task.warn("Assertion ("+assertionMsg
          +") failed, specified error will be thrown..", this);
      throw new StepError(msg);
    }
  }
  return;
};

Assert.prototype.getClassName = function () {
  return "Assert";
};

Assert.prototype.getDisplayName = function () {
  return "Assert";
};

Assert.prototype.getDescription = function () {
  return "Asserts a condition against a stored value.";
};

Assert.prototype.getVersion = function () {
  // return "1.1";  added the mode setting
  return "2.0";  // error optional (successful exit), error text optional
};

Assert.prototype.renderArgs = function () {
  return this.conf['error'];
};

Assert.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    let spec = {key: conf.target};
    let container = conf.container;
    if (container === "INPUT") {
      spec.path = "$.input";
    } else if (container !== undefined) {
      spec.path = "$.output";
      if (container !== "NONE") {
        if (container === "item") {
          spec.path += ".results[*].item[*]";
        } else {
          spec.path += "." + container + '[*]';
        }
      }
    }
    delete conf.container;
    conf.target = spec;
  }
  if (confVer < 1.1) {
    if ( typeof(conf.mode) == "undefined" )
      conf.mode = "miss";
  }
  return true;
};
