var EXPORTED_SYMBOLS = ["Copy"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Copy = function () {
  this.conf = {};
};

Copy.prototype = new Step();
Copy.prototype.constructor = Copy;

Copy.prototype.init = function() {};

Copy.prototype.draw = function(surface) {
  xulHelper.jsonPathMapField(surface, this, "in", "out");
};

Copy.prototype.run = function (task) {
  jsonPathHelper.map(this.conf.in, this.conf.out, function (value) {
    return value;
  }, task.data);
};

Copy.prototype.getClassName = function () {
  return "Copy";
};

Copy.prototype.getDisplayName = function () {
  return "Copy";
};

Copy.prototype.getDescription = function () {
  return "";
};

Copy.prototype.getVersion = function () {
  return "1.0";
};

Copy.prototype.getUsedArgs = function () {
  if (this.conf.in.path === "$.input") return [this.conf.in.key];
};

Copy.prototype.renderArgs = function () {
  return this.conf.in ? this.conf.in.key + " -> " + this.conf.out.key : "";
};

Copy.prototype.upgrade = function (confVer, curVer, conf) {
  if (confVer > curVer) return false;
  return true;
};
