var EXPORTED_SYMBOLS = ["NavTo"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/htmlHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var NavTo = function () {
  this.conf = {};
  this.conf['wait'] = {};
  this.conf['wait']['active'] = true;
  this.conf['rawxml'] = false;
  this.conf['hashonly'] = false;
  this.conf['usejp'] = false;
  // 'url' - constant url to go to
  // 'jp'  - JSONpath to the variable that has the URL
  // Only one should exist at any one time!
  // There is 'inline' as well... Not quite sure why.
  this.hl = null;
};

NavTo.prototype = new Step();
NavTo.prototype.constructor = NavTo;

NavTo.prototype.init = function(task) { };

NavTo.prototype.draw = function(surface) {
  // delete processed inline jps
  delete this.conf.inline;

  var context = this;
  var radiogroup = xmlHelper.appendNode(surface, "radiogroup");

  var hbox = xmlHelper.appendNode(radiogroup, "hbox");
  var constRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"constRadio", "label":"Constant URL:"});
  var constInput = xmlHelper.appendNode(hbox, "textbox", null, {"value":this.conf["url"]||"", "flex":"1"});
  var button = xmlHelper.appendNode(hbox, "button", null, { label: "Use current page" });

  hbox = xmlHelper.appendNode(radiogroup, "hbox");
  var pathRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"pathRadio", "label":"URL from stored data:"});

  var jpField = xulHelper.jsonPathField(hbox, this, this.conf, "jp");

  var wait = waitForLoad.stepXul(surface, this.conf['wait']);

  // reflect saved values
  if (context.conf.usejp) {
    radiogroup.selectedItem = pathRadio;
  } else {
    radiogroup.selectedItem = constRadio;
  }

  radiogroup.addEventListener("select", function(e) {
    if (radiogroup.selectedItem == pathRadio) {
      context.conf.usejp = true;
    }
    if (radiogroup.selectedItem == constRadio) {
      context.conf.usejp = false;
      context.conf["url"] = constInput.value;
    }
  }, false);

  jpField.addEventListener("command", function(e) {
    context.conf.usejp = true;
    radiogroup.selectedItem = pathRadio;
  }, false);

  constInput.addEventListener("input", function(e) {
    context.conf.usejp = false;
    radiogroup.selectedItem = constRadio;
    context.conf["url"] = constInput.value;
  }, false);

  button.addEventListener("command", function(e) {
          // This code previously used context.getPageDoc().location
          // which went wrong in an interesting way: the value of this
          // is not a string, but a reference to the Location object
          // that _contains_ the URL.  This _appears_ to work: it
          // coerces to a string when assigned to ip.value, and so
          // displays as expected.  But the actual object is assigned
          // into the conf[] array, which means that when you navigate
          // away its apparent value (the next time it's coerced to a
          // string) changes!
          var url = context.getPageDoc().URL;
          context.conf['url'] = constInput.value = url;
          delete context.conf["jp"];
          radiogroup.selectedItem = constRadio;
  }, false);

  if (this.rawxml === true) {
    xulHelper.checkbox(surface, this, "rawxml",
      "Load raw XML  (Deprecated - use Httpclient instead!)", null);
  }

  xulHelper.checkbox(surface, this, "hashonly", "Only set the hash component, not the whole URL");
};

NavTo.prototype.processConf = function () {
  let usedArgs = [];
  let url = this.conf.url;
  if (url) {
    // gather used arguments from inline JSONpaths
    let usedArgRegex = /\{\$\.input\.(.+?)\}/g;
    while ((match = usedArgRegex.exec(url)) !== null) {
      usedArgs.push(match[1]);
    }
    // process inline JSONpaths
    this.conf.inline = jsonPathHelper.processInline(url);
  } else {
    // reading from a path instead
    if (this.conf.jp.path === "$.input") {
      usedArgs.push(this.conf.jp.key);
    }
  }
  this.conf.usedArgs = usedArgs;
}

NavTo.prototype.getUrl = function (task) {
    var url;
    if (this.conf.usejp) {
      url = jsonPathHelper.getFirst(this.conf.jp, task.data);
      if (!url) throw new StepError("URL not found in: " + this.conf.jp.path
                                     + "." + this.conf.jp.key);
    } else {
      url = jsonPathHelper.applyInline(this.conf.inline, this.task.data);
      if (!url) throw new StepError("URL not specified.");
    }
    return url;
};

NavTo.prototype.getRawXml = function(task) {
    var url=this.getUrl(task);
    task.debug("Getting rawurl from " + url );
    if ( this.task.connector.insideEngine() ) {
        var dom = xmlHelper.fetchDoc( url, false, false );
        this.task.connector.setPageOverride(dom,url);
        task.debug("Got it");
        return;
    }
    // Inside the builder, we need to do a lot more to get a
    // a decent page to display. Just getting it to blank is a mess,
    // as pageload is supposed to be asynchronous.
    var context = this;
    var event = "DOMContentLoaded";
    var status = 0; // 0=not started, 1=loading, 2=done

    var eventhandler = function () { // This gets called once we have a blank page
        task.debug("event: " + event );
        try {
            task.connector.getPageWindow().
                removeEventListener(event, eventhandler, false);
            var doc = task.connector.getRealPageDoc();
            doc.body.innerHTML = "Loading raw XML from " +
            "<a href=\"" + url +"\" >" + url + "</a> <p/>\n";
            status = 1;
            //task.debug("Url: " + typeof(url) + " = " + url );
            //doc.body.innerHTML += "<p/><b>A1</b> "+ typeof(url) + "<br/>\n";
            //doc.body.innerHTML += "<p/><b>A</b>"
            //   + url.replace(/:/,":::") +"<br/>\n";
            var dom = xmlHelper.fetchDoc( url, false, false );
            //doc.body.innerHTML += "<p/><b>B</b><br/>\n";
            task.connector.setPageOverride(dom,url);
            task.debug("Loaded " + url);
            doc.body.innerHTML += "<p/><b>OK</b>\n";
            status = 2;
            task.debug("Looking at display doc\n");
            task.debug("" + doc.body );
            htmlHelper.renderXml( dom, doc, doc.body)
        } catch(e) {
            task.debug("GetRawXml caught an exception: " + e );
            doc.body.innerHTML += "<p/><b>FAIL</b><br/>" + e + "\n";
            if ( e.fileName && e.lineNumber )
              doc.body.innerHTML += e.fileName + ":" + e.lineNumber + "<br/>\n";
        }
        task.debug("Resuming task");
        task.resume();
    }; // onshow;

    // If we time out, the loading of about:blank failed,
    // or (much more likely), fetching the raw XML took
    // too long.
    var interruptcallback = function() {
        task.debug("in task interrupt function. st=" + status);
        if ( status == 2)
            return true;
        task.warn("Timed out waiting for raw XML from " + url);
        return false;
    }
    task.debug("About to blank the page");
    task.connector.getPageWindow().
        addEventListener(event, eventhandler, false);
    task.interrupt(30000,interruptcallback);  // 30 secs
    this.getPageDoc().location = "about:blank";
};

NavTo.prototype.run = function (task) {
  this.task.connector.clearPageOverride();
  if ( this.conf.rawxml ) {
      this.getRawXml(task);
      return;
  }
  waitForLoad.wait(task, this.conf.wait, this);
  let doc = this.getPageDoc();
  let url = this.getUrl(task);
  if (this.conf.hashonly === true) {
    task.info("Changing hash to " + url, this);
    doc.location.hash = url;
  } else {
    task.info("Changing location to " + url, this);
    doc.location = url;
  }
};

NavTo.prototype.getUsedArgs = function () {
  return this.conf.usedArgs;
};

NavTo.prototype.getClassName = function () {
  return "NavTo";
};

NavTo.prototype.getDisplayName = function () {
  return "Go to URL";
};

NavTo.prototype.getDescription = function () {
  return "Navigates to a specified web-site address.";
};

NavTo.prototype.getVersion = function () {
  return "4.0";
};

NavTo.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.5) {
    conf['wait'] = {};
    conf['wait']['active'] = true;
  }
  if (confVer < 0.7) {
    // param can be an empty string, maybe other falsy values
    if (this.conf['param']) {
      if (this.conf['param'] !== "Constant address") {
        this.conf['jp'] = {path: "$.input", key: conf['param']};
        if (this.conf.url) delete this.conf.url;
      }
      delete this.conf['param'];
    }
  }
  if (confVer < 2.0) {
    this.processConf();
  }
  if (confVer < 3.0) {
    if (!this.conf.url) this.conf.usejp = true;
    else this.conf.usejp = false;
  }
  return true;
};


NavTo.prototype.renderArgs = function () {
  if (this.conf.usejp) return this.conf.jp.path + "." + this.conf.jp.key;
  else return this.conf.url;
};

