var EXPORTED_SYMBOLS = ["ProxyUrl"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/configfile.js');
Components.utils.import('resource://indexdata/util/io.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var ProxyUrl = function () {
  this.conf = {
    in: {path:"$.output.results[*]", key:"url"},
    out: {path:"$.output.results[*]", key:"url"},
    do_url: true,
    do_thumburl: true,
    do_fulltexturl: true,
    do_custom: false,
    // no permalink, it should never be proxified
  };
};
ProxyUrl.prototype = new Step();
ProxyUrl.prototype.constructor = ProxyUrl;

ProxyUrl.prototype.init = function() {};

ProxyUrl.prototype.draw = function(surface) {
  var context = this;

  var vbox1 = xmlHelper.appendNode(surface, "vbox", null,
                { flex: 1, pack: "top", align: "left" });

  var cbox = xmlHelper.appendNode(vbox1, "hbox", null,
                { flex: 1, pack: "baseline", align: "left" });
  xulHelper.captionField(cbox, "Normalize these", null );
  xulHelper.labelField(cbox, "in $.output.results[*]: ", null );
  xulHelper.checkbox(cbox, context, "do_url", "url" );
  xulHelper.checkbox(cbox, context, "do_thumburl", "thumburl" );
  xulHelper.checkbox(cbox, context, "do_fulltexturl", "fulltexturl" );

  xulHelper.checkbox(vbox1, context, "do_custom", "Normalize custom field" );

  xulHelper.jsonPathMapField(vbox1, this, "in", "out",
    {path:"$.output.results[*]", key:"url"},
    {path:"$.output.results[*]", key:"url"});
};


function dumpcookies(){
    //dump("About to get the cookiemanager\n");
    var cookieMgr = Components.classes["@mozilla.org/cookiemanager;1"]
             .getService(Components.interfaces.nsICookieManager);
    var c="";
    //dump("About to look through cookies\n");
    for (var e = cookieMgr.enumerator; e.hasMoreElements();) {
        var cookie = e.getNext().QueryInterface(Components.interfaces.nsICookie);
        //dump("Cookie: "  + cookie.host + "; " +
        //    cookie.name + "=" + cookie.value + "\n");
        c += "Cookie " +  cookie.host + "; " +
            cookie.name + "=" + cookie.value + "\n"
    // see http://developer.mozilla.org/en/docs/nsICookie for a list of attributes on |cookie|
    }
    //dump("Cookie jar loop done\n");
    return c;
}

ProxyUrl.prototype.run = function (task) {
    var context = this;
    var doc = this.getPageDoc();
    var pagecookies = doc.cookie;
    //for (var i in doc )
    //    dump("doc has a '"+i+"' = '" + doc[i] + "'\n");
    var session = "";
    var init = task.connector.findTask("init");
    // TODO - Ought to pass the arguments we want
    // but in real life, we have at most one init task...
    if ( init ) {
        session = init.getArgValue("cproxysession");
        task.debug("got session '" + session + "'");
        var nocproxy =  init.getArgValue("nocproxy");
        task.debug("got nocproxy='" + nocproxy + "' t=" + typeof(nocproxy) );
        if ( nocproxy ) {
          task.info("noxproxy specified, skipping proxying" );
          return;
        }
    }
    if ( !session ) {
        session = Math.floor(Math.random()*1000000);
    }
    var sesdir = ConfigFile.getconfigvalue(task, "sessiondir");
    var c = "";
    c += "CfSession " + session + "\n";
    c += "Referer " + doc.location + "\n";
    if ( init ) {
        c += "Username " + init.getArgValue("username") + "\n";
        c += "Password " + init.getArgValue("password") + "\n";
        c += "Proxyip " + init.getArgValue("proxyip") + "\n";
    }
    c += dumpcookies();

    if ( sesdir ) {
        var sesfilename = sesdir + "/cf." + session ;
        var sesfile = Components.classes["@mozilla.org/file/local;1"].
            createInstance(Components.interfaces.nsILocalFile);
            sesfile.initWithPath(sesfilename);
        var fos = io.fos(sesfile, "" );  // file output stream
        io.write(fos,c);  // writes the string and closes fos!
        task.info("ProxyURL session file stored at "+sesfile.path);
    } else {
        // Do not throw an error, breaks the builder if no access to /etc
        task.warn("Can not store session file " + session + ". " +
            "No 'sessiondir' found in config file");
    }

    var proxyhost = ConfigFile.getconfigvalue(task, "proxyhostname");
    if (!proxyhost) {
        /* Can not throw an error - breaks builders */
        //throw new StepError("Config file contains "+
        //    "no value for 'proxyhostname'");
        proxyhost="SOME.UNKNOWN.PROXY.HOST";
    }

  // Rewrite the url(s) to point to our proxy
  // and create a session file
  var makeproxyurl = function (val) {
    // Skip records with no source
    if (val === undefined) return undefined;
    if ( val.indexOf(proxyhost) ==-1) { // avoid duplicate proxying
        // duplicates may happen in the builder, if rerunning the step
        //var prefix =  "http://" + session + "." + proxyhost + "/" ;  // OLD
        var prefix =  "http://" + proxyhost + "/" + session + "/";  // NEW
        //var pat = "/^http:\\/\\/([0-9]+\\."+proxyhost+"\\/)?/";
        val = val.replace( /^http:\/\//, prefix );
    }
    return val;
  }

  //jsonPathHelper.mapElements(context.conf['in'] || {path:"$.output.results[*]", key:"url"},
  //               context.conf['out'], makeproxyurl, task.data);
  if (context.conf.do_url)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"url"},
      {path:"$.output.results[*]", key:"url"},
      makeproxyurl, task.data);
  if (context.conf.do_thumburl)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"thumburl"},
      {path:"$.output.results[*]", key:"thumburl"},
      makeproxyurl, task.data);
  if (context.conf.do_fulltexturl)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"fulltexturl"},
      {path:"$.output.results[*]", key:"fulltexturl"},
      makeproxyurl, task.data);
  if (context.conf.do_custom)
    jsonPathHelper.mapElements(
      context.conf.in, context.conf.out,
      makeproxyurl, task.data);

};

// This is a bit dirty - it lists the arguments it takes from an init task.
// If there is a proxyUrl step in the init task, the init task will match when
// invoked with the usual arguments. But if there is no proxyUrl step in the
// init task, and there is a init task, things may be a bit strange. Still,
// this should only increase the chances that a task matches, freeing us of
// the need of (at least some of the) null transform steps...
ProxyUrl.prototype.getUsedArgs = function () {
  return [ "cproxysession", "username", "password", "proxyip", "nocproxy" ];
};

ProxyUrl.prototype.getClassName = function () {
  return "ProxyUrl";
};

ProxyUrl.prototype.getDisplayName = function () {
  return "Proxy URL";
};

ProxyUrl.prototype.getDescription = function () {
  return "Changes the URL into one that will be proxied by the CfProxy";
};

ProxyUrl.prototype.getVersion = function () {
  return "1.1";  // 1.1 adds multiple URL-like fields
};

ProxyUrl.prototype.renderArgs = function () {
  var s="";
  if (this.conf.do_url)
    s += "url, ";
  if (this.conf.do_thumburl)
    s += "thumburl, ";
  if (this.conf.do_fulltexturl)
    s += "fulltexturl, ";
  if ( this.conf.do_custom &&
       this.conf.in && this.conf.in.key &&
       this.conf.out && this.conf.out.key ) {
    s += this.conf.in.key
    if ( this.conf.in.key != this.conf.out.key )
      s += "->" + this.conf.out.key
  }
  s = s.replace( /,\s*$/, ""); // remove last comma
  return s;
};

ProxyUrl.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    jsonPathHelper.upgradePostProc(this.conf);
  }
  if (confVer < 1.1 ) {
    if ( typeof(conf.in) == "undefined" ||
         typeof(conf.in.path) == "undefined" ||
         ( conf.in.path == "$.output.results[*]" &&
           conf.in.key == "url" ) ) {  // the usual case
      conf.do_url = true;
      conf.do_thumburl = false;
      conf.do_fulltexturl = false;
      conf.do_custom = false;
      logger.debug("Upgraded proxy_url from " + confVer + ", the usual case");
    } else { // custom field configured
      conf.do_url = false;
      conf.do_thumburl = false;
      conf.do_fulltexturl = false;
      conf.do_custom = true;
      logger.debug("Upgraded proxy_url from " + confVer + ", special conf");
    }
  }

  return true;
};
