var EXPORTED_SYMBOLS = ["RegexExtract"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');

if (typeof DEBUG == "undefined") const DEBUG = true;

var RegexExtract = function () {
  this.className = "RegexExtract";
  this.truncate = 80;
  this.conf = {};
  this.conf["regex"] = "";
  this.conf["matchNum"] = 0;
  this.conf["node"] = "";
  this.conf["sourceAttribute"] = "";
  this.conf["attributes"] = [];
  this.conf["result"] = "";
};
RegexExtract.prototype = new Step();
RegexExtract.prototype.constructor = RegexExtract;

RegexExtract.prototype.init = function() {
};

RegexExtract.prototype.draw = function(surface) {
  var context = this;
  var surfaceHbox = xmlHelper.appendNode(surface, "hbox", null, {"flex":"1"}, null);
  var vbox1 = xmlHelper.appendNode(surfaceHbox, "vbox", null, {"flex":"1"}, null);
  var vbox2 = xmlHelper.appendNode(surfaceHbox, "vbox", null, {"flex":"1"}, null);

  var attrGroup = xmlHelper.appendNode(vbox2, "groupbox", null, {"flex":"1"}, null);
  xmlHelper.appendNode(attrGroup, "caption", null, {"label":"Attributes"}, null);
  var attrRadioGroup = xmlHelper.appendNode(attrGroup, "radiogroup", null, null, null);

  // New node, we can populate attrRadioGroup with attributes and values
  var onNodeSelect = function(node) {
    xmlHelper.emptyChildren(attrRadioGroup, "radio");
    if (!node) return; // This can happen if the user edits the XPath by hand
    xmlHelper.appendNode(attrRadioGroup, "radio", null, {"label":"text = " + node.textContent.substring(0, context.truncate), "value":"textContent"});
    context.conf["attributes"] = [];
    for (i = 0; i < node.attributes.length; i++) {
      context.conf["attributes"].push(node.attributes.item(i).name);
      xmlHelper.appendNode(attrRadioGroup, "radio", null, {"label":node.attributes.item(i).name + " = " + node.attributes.item(i).value.substring(0, context.truncate), "value":node.attributes.item(i).name});
    }
    attrRadioGroup.selectedIndex = 0;
    context.conf["sourceAttribute"] = "textContent";
  };

  // Stored node, values are likely different now and who knows what
  // page it came from, but attribute names were saved for posterity.
  if (this.conf["node"]) {
    xmlHelper.emptyChildren(attrRadioGroup, "radio");
    textRadio = xmlHelper.appendNode(attrRadioGroup, "radio", null, {"label":"text", "value":"textContent"});
    var selectedRadio = null;
    if (context.conf["sourceAttribute"] == "textContent")
      selectedRadio = textRadio;
    for (i = 0; i < this.conf["attributes"].length; i++) {
      var attr = this.conf["attributes"][i];
      var attrRadio = xmlHelper.appendNode(attrRadioGroup, "radio", null, {"label":attr, "value":attr});
      if (attr==context.conf["sourceAttribute"])
        selectedRadio = attrRadio;
    }
    attrRadioGroup.selectedItem = selectedRadio;
  }

  attrRadioGroup.addEventListener("command", function(e) {
    context.conf["sourceAttribute"] = attrRadioGroup.selectedItem.value;
  }, false);

  var hbox = xmlHelper.appendNode(vbox1, "hbox", null, null, null);
  xmlHelper.appendNode(hbox, "label", "Source element: ", null, null);
  var input = xulHelper.singleNodeField(hbox, this, "node", onNodeSelect);
  input.addEventListener("change", function(e) {
    // Refresh display of attributes when the XPath is edited by hand
    onNodeSelect(xmlHelper.getElementByXpath(context.getPageDoc(), input.value));
  }, false);

  hbox = xmlHelper.appendNode(vbox1, "hbox", null, null, null);
  xmlHelper.appendNode(hbox, "label", "Regular expression: ", null, null);
  var regexInput = xmlHelper.appendNode(hbox, "textbox", null, {"value":this.conf["regex"], "flex":"1"}, null);

  hbox = xmlHelper.appendNode(vbox1, "hbox", null, null, null);
  xmlHelper.appendNode(hbox, "label", "Match number: ", null, null);
  var matchInput = xmlHelper.appendNode(hbox, "textbox", null, {"value":this.conf["matchNum"], "flex":"1"}, null);

  hbox = xmlHelper.appendNode(vbox1, "hbox", null, null, null);
  xmlHelper.appendNode(hbox, "label", "Result name: ", null, null);
  //*dump("RegexExtract.draw() before resultSelectField()\n");
  var select = xulHelper.resultSelectField(hbox, this, "result", null, [ this.conf.result ]);
  //*dump("RegexExtract.draw() after resultSelectField()\n");
  select.setAttribute("editable", true);
  select.addEventListener("keyup", function (e) {
      context.conf["result"] = this.value
    }, false);

  // if anything changes, save values
  surfaceHbox.addEventListener("change", function(e) {
    context.conf["regex"] = regexInput.value;
    context.conf["matchNum"] = matchInput.value;
  }, false);
};

RegexExtract.prototype.run = function (task) {
  if (!this.conf["sourceAttribute"])
    throw new StepError("No attribute defined");
  var node = xmlHelper.getElementByNodeSpec(this.getPageDoc(), this.conf['node']);
  if (!node) {
    throw new StepError("cannot retrieve node from xpath " + this.conf['node']);
  }

  var text = (this.conf["sourceAttribute"]=="textContent" ?
              node.textContent :
              node.getAttribute(this.conf["sourceAttribute"]));

  if (!this.conf["regex"]) {
    task.output[this.conf["result"]] = [ text ];
  } else {
    var re = new RegExp(this.conf["regex"]);
    var match = re.exec(text);
    if (match) {
      var matchNum = this.conf['matchNum'];
      task.output[this.conf["result"]] = [ match[matchNum] ];
    } else {
      throw new StepError("No match for regexp " + this.conf["regex"]);
    }
  }
};

RegexExtract.prototype.getClassName = function () {
  return "RegexExtract";
};

RegexExtract.prototype.getDisplayName = function () {
  return "Extract regex";
};

RegexExtract.prototype.getDescription = function () {
  return "Populates a result with text from an element text or attribute, optionally using only text that matches a regular expression.";
};

RegexExtract.prototype.getVersion = function () {
  return "0.1";
};

RegexExtract.prototype.renderArgs = function () {
  if (!this.conf.result) return "";
  return this.conf.result + "=/" + this.conf.regex + "/";
}

RegexExtract.prototype.isDeprecated = function () {
  return true;
};

RegexExtract.prototype.getDeprecationInfo = function () {
  return "Use 'Extract Value' and 'Transform' combo instead";
};


