var EXPORTED_SYMBOLS = ["Retry"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');

var Retry = function () {
  this.conf = {};
  //defaults
  this.conf['delay'] = 20;
  this.conf['maxCount'] = 3;
  this.conf['stepsBack'] = 1;
};
Retry.prototype = new Step();
Retry.prototype.constructor = Retry;

Retry.prototype.init = function(task) {
  var context = this;
  task.addHandler("onTaskFinish", function () {
      context.currentCount = undefined;
  });
};
Retry.prototype.draw = function(surface) {
  var ph = surface;
  var ns = "http://www.w3.org/1999/xhtml";
  var context = this;
 
  xmlHelper.appendNode(ph, "span", "Delay: ", null, ns);
  var delayInput = xmlHelper.appendNode(ph, "input", null,
      {"type": "text", "value": this.conf['delay']}, ns);
  
  xmlHelper.appendNode(ph, "span", "Max Count: ", null, ns);
  var mcInput = xmlHelper.appendNode(ph, "input", null,
      {"type": "text", "value": this.conf['maxCount']}, ns);

  xmlHelper.appendNode(ph, "span", "Steps back to retry from: ", null, ns);
  var sbInput = xmlHelper.appendNode(ph, "input", null,
      {"type": "text", "value": this.conf['stepsBack']}, ns);      
      
  // track user inputs
  delayInput.addEventListener("input", function (e) {
      context.conf['delay'] = parseInt(delayInput.value);
  }, false);
  
  mcInput.addEventListener("input", function (e) {
      context.conf['maxCount'] = parseInt(mcInput.value);
      context.currentCount = undefined;
  }, false);
  
  sbInput.addEventListener("input", function (e) {
      context.conf['stepsBack'] = parseInt(sbInput.value);
      context.currentCount = undefined;
  }, false);  

};
Retry.prototype.run = function (task) {
  if (typeof this.conf['delay'] != "number") {
    throw new StepError("delay not specified in the configuration");
  }
  if (typeof this.conf['maxCount'] != "number") {
    throw new StepError("max count not specified in the configuration");
  }
  if (typeof this.conf['stepsBack'] != "number") {
    throw new StepError("steps back not specified in the configuration");
  }  
  if (this.currentCount === undefined) {
    this.currentCount = this.conf['maxCount'];
    task.info("Retrying for the first time...", this);
  }
  if (this.currentCount <= 0) {
    this.currentCount = undefined;
    throw new StepError("too many retries");
  }
  this.currentCount-=1;
  task.info("Interrupting and retrying previous step... (c=" 
      + this.currentCount + ")",
      this);
  var context = this;
  task.interrupt(this.conf['delay'], function () {
    task.info("Retrying from " + context.conf['stepsBack'] + " step(s) back...", context);
    task.seekRelative(0 - context.conf['stepsBack'] - 1);
  });
};

Retry.prototype.getClassName = function () {
  return "Retry";
};

Retry.prototype.getDisplayName = function () {
  return "Retry";
};

Retry.prototype.getDescription = function () {
  return "Retries the previous step if it has failed.";
};

Retry.prototype.getVersion = function () {
  return "0.2";
};

Retry.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    conf['stepsBack'] = 1;
    return true;
  }
  return false;
};

Retry.prototype.renderArgs = function () {
  return this.conf.maxCount + " times";
};
