var EXPORTED_SYMBOLS = ["Skip"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Skip = function () {
  this.conf = {};
  //defaults
  this.conf['compareTo'] = '';
  this.conf['rel'] = 'eq';
  this.conf['expArgVal'] = '';
  this.conf['useRegex'] = false;
  this.conf['stepsToSkip'] = 1;
  this.conf['skipAll'] = false;
  //poss rel
  this.poss = {"eq": "matches", "neq": "does not match"};
};
Skip.prototype = new Step();
Skip.prototype.constructor = Skip;

Skip.prototype.init = function(task) {
};

var commonTests = [
 {label: "always true",   value: ".?", isRegex: true},
 {label: "is empty",      value: "^\\s*$", isRegex: true},
 {label: "is not empty",  value: "\\S+", isRegex: true},
 {label: "is numerical",  value: "^[0-9]+$", isRegex: true},
 {label: "is non-zero",   value: "^[1-9]+[0-9]*$", isRegex: true},
];

function getToSkipType(me, stepsToSkip) {
  let i = me.task.findStepIndex(me);
  dump('-----------i '+i+"toSKip:"+stepsToSkip+"\n");
  let type = '';
  if ((i+stepsToSkip) < me.task.steps.length) {
    type = me.task.steps[i+stepsToSkip].getClassName();
  } else {
    type = "out-of-range";
  }
  return type;
}

Skip.prototype.draw = function(surface) {
  xulHelper.jsonPathField(surface, this, this.conf, "compareTo");
  var hbox = xmlHelper.appendNode(surface, "hbox", null, { align: "center" });
  xmlHelper.appendNode(hbox, "caption", "Only run next step(s) if above value ");
  let selectf = xulHelper.selectField(hbox, this, "rel", null, this.poss);
  let inputf = xulHelper.inputFieldOnly(hbox, this, "expArgVal");
  let cb = xulHelper.checkbox(hbox, this, "useRegex",
      " Use regular expressions");

  let hbox = xmlHelper.appendNode(surface, "hbox", null, { align: "center" });
  xmlHelper.appendNode(hbox, "caption", "# of steps to skip ");
  let stsInput = xmlHelper.appendNode(hbox, "textbox", null,
    this.conf.stepsToSkip ? {"value": this.conf.stepsToSkip} : {});
  if (this.conf.skipAll) stsInput.disabled = true;

  xmlHelper.appendNode(surface, "spacer", null, { flex: 1 });
  var toSkipLbl = xmlHelper.appendNode(surface, "label");
  var toSkipLblPrefix = "Target step type: ";
  let toSkip = this.conf.stepsToSkip ? this.conf.stepsToSkip : 0;
  let realType = getToSkipType(this, toSkip);
  if (!this.conf.skipAll) {
    if (this.conf['destType']) {
      toSkipLbl.value = toSkipLblPrefix+this.conf['destType'];
      if (realType != this.conf['destType']) {
        toSkipLbl.value += " (actual destination class '"+realType+"' differs!)";
      }
    } else {
      this.conf['destType'] = realType;
      toSkipLbl.value = toSkipLblPrefix+this.conf['destType']
        +" (validated now)";
      //should we send save notification?
    }
  } else {
      toSkipLbl.value = "Skipping all steps";
  }
  var context = this;
  stsInput.addEventListener("input", function (e) {
    let toSkip = parseInt(stsInput.value);
    context.conf['stepsToSkip'] = toSkip;
    if (!context.conf.skipAll) {
      let type = getToSkipType(context, toSkip);
      toSkipLbl.value = toSkipLblPrefix+type;
      context.conf['destType'] = type;
    } else {
      toSkipLbl.value = "Skipping all steps";
    }
  }, false);
  let scb = xulHelper.checkbox(hbox, this, "skipAll",
      " Skip till end?");
  scb.addEventListener("click", function (e) {
    //context.conf points to previous value here
    if (!context.conf.skipAll) {
      stsInput.disabled = true;
      toSkipLbl.value = "Skipping all steps";
    } else {
      stsInput.disabled = false;
      let type = getToSkipType(context, toSkip);
      toSkipLbl.value = toSkipLblPrefix+type;
    }
  }, false);
  xmlHelper.appendNode(surface, "spacer", null, { flex: 1 });
  // Recipes
  xmlHelper.appendNode(surface, "separator", null, { class: "groove" } );
  xmlHelper.appendNode(surface, "caption", "Common tests");
  var hbox = xmlHelper.appendNode(surface, "hbox");
  for (var i=0; i<commonTests.length; i++) {
    let test = commonTests[i];
    let label = commonTests[i].label;
    let button = xmlHelper.appendNode(hbox, "button", null, { label: label });
    button.addEventListener("command",
      function (e) {
        cb.checked = test.isRegex;
        context.conf['useRegex'] = test.isRegex;
        inputf.value = test.value;
        context.conf['expArgVal'] = test.value;
        selectf.value = 'eq';
        context.conf['rel'] = 'eq';
      }
    );
  }
};

Skip.prototype.run = function (task) {
  if (typeof this.conf['compareTo'] !== "object" || this.conf['compareTo'] === "") {
    throw new StepError("what to compare to isn't specified in the configuration");
  }
  if (typeof this.conf['expArgVal'] !== "string" ||
      this.conf['expArgVal'] === "") {
    throw new StepError("expected value not specified in the configuration");
  }
  if (this.conf['rel'] !== "eq" && this.conf['rel'] !== "neq") {
    throw new StepError("proper relation not specified in the configuration");
  }
  //be bacwards compat: undefined == false
  if (this.conf['skipAll']) {
    var skipAll = true;
  } else if (typeof this.conf.stepsToSkip != "number") {
    throw new StepError("steps-to-skip not specified as a number in "
        + "the configuration ("+this.conf.stepsToSkip+")");
  }
  var useRegex = typeof this.conf['useRegex'] === "boolean"
    ? this.conf['useRegex'] : false;
  var test = function (rel, str, regex) {
    if (useRegex) {
      regex = new RegExp(regex);
      if (rel === "eq") return regex.test(str);
      if (rel === "neq") return !regex.test(str);
    } else {
      if (rel === "eq") return regex === str;
      if (rel === "neq") return regex !== str;
    }
    return false;
  };

  var relName = '';
  for (var i=0; i<this.poss.length; i++) {
    if (this.poss[i].value === this.conf['rel']) {
      relName = this.poss[i].name;
    }
  }

  var stringtomatch = jsonPathHelper.getFirst(this.conf.compareTo, task.data) || "";
  // warn if dest step type differs
  var type = getToSkipType(this,this.conf.stepsToSkip);
  if (!skipAll && this.conf.destType && this.conf.destType != type)
    task.warn("Target step class is "+type+" while configuration value is "
        + this.conf.destType+", please review the step config!", this);
  if (test(this.conf['rel'], stringtomatch, this.conf['expArgVal'])) {
    task.info("Predicate {key '" + this.conf.compareTo.key + "' = '" +
        stringtomatch + "' " + relName + " '"
        + this.conf['expArgVal'] + "'} true, running next step...", this);
  } else {
    let msg = skipAll ? "to end" : this.conf.stepsToSkip + " step(s)";
    task.info("Predicate {key '" + this.conf.compareTo.key + "' = '" +
        stringtomatch + "' " +relName + " '"
        + this.conf['expArgVal'] + "'} false, skipping "+msg+"...", this);
    if (skipAll)
      task.seekEnd();
    else
      task.seekRelative(this.conf['stepsToSkip']);
  }
};

Skip.prototype.getClassName = function () {
  return "Skip";
};

Skip.prototype.getDisplayName = function () {
  return "Next if";
};

Skip.prototype.getDescription = function () {
  return "Controls execution of a consecutive step by checking a predicate";
};

Skip.prototype.getVersion = function () {
  return "1.1";
};

Skip.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    conf['stepsToSkip'] = 1;
  }
  if (confVer < 0.3) {
    conf.compareTo = {path: "$.input", key: conf.argName};
    delete conf.argName;
  }
  return true;
};

Skip.prototype.getUsedArgs = function () {
   if (this.conf.compareTo.path === "$.input")
        return [this.conf.compareTo.key];
    else
         return [];
}

Skip.prototype.renderArgs = function () {
  if (!this.conf.compareTo) return "";
  var op = this.conf.useRegex ? "~" : "=";
  if (this.conf.rel == "neq") op = "!" + op;
  var val = this.conf.expArgVal;
  if (this.conf.useRegex) val = "/" + val + "/";
  return this.conf.compareTo.key + " " + op + " " + val;
};


Skip.prototype.getIndentRange = function () {
  let indentTo = this.conf.skipAll ? -1 : this.conf.stepsToSkip+1;
  return [1, indentTo];
};
