var EXPORTED_SYMBOLS = ["Submit"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/stepHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Submit = function () {
  this.conf = {};
  this.conf['target'] = ""; // { xpath: "" };
  this.conf['wait'] = {};
  this.conf['wait']['active'] = true;
};

Submit.prototype = new Step();
Submit.prototype.constructor = Submit;

Submit.prototype.init = function() {};

Submit.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var vbox = xmlHelper.appendNode(surface, "vbox", null, null, null);

  var hbox1 = xmlHelper.appendNode(vbox, "hbox", null, null, null);
  xmlHelper.appendNode(hbox1, "caption", "Contained element xpath: ", null, null);
  xulHelper.singleNodeField(hbox1, this, 'target');

  waitForLoad.stepXul(surface, this.conf['wait']);
};

Submit.prototype.run = function (task) {
  this.task.connector.clearPageOverride();
  waitForLoad.wait(task, this.conf.wait, this);  
  var pageDoc = this.getPageDoc();
  var pageWin = this.getPageWindow();
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.target, task.data);
  let target = xmlHelper.getElementByNodeSpec(pageDoc, nodeSpec);
  if (target == null) {
    throw new StepError("Target element not found.");
  }

  target.form.submit();
};

Submit.prototype.getClassName = function () {
  return "Submit";
};

Submit.prototype.getDisplayName = function () {
  return "Submit Form";
};
Submit.prototype.getDescription = function () {
  return "Submits the form containing a selected element.";
};
Submit.prototype.getVersion = function () {
  return "1.0";
};

Submit.prototype.upgrade = function (confVer, curVer, conf) { 
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    var oldwait = conf['wait'];
    conf['wait'] = {};
    conf['wait']['active'] = oldwait;
  }
  return true;
};

Submit.prototype.renderArgs = function () {
  var target = this.conf.target;
  if (typeof target == "string") return target;
  return target.xpath;
}
