var EXPORTED_SYMBOLS = ["progressListen"];
const STATE_START = Components.interfaces.nsIWebProgressListener.STATE_START;
const STATE_TRANSFERRING = Components.interfaces.nsIWebProgressListener.STATE_TRANSFERRING;
const STATE_STOP = Components.interfaces.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING = Components.interfaces.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_IS_DOCUMENT = Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT;
const NOTIFY_ALL = Components.interfaces.nsIWebProgress.NOTIFY_ALL;

const OBSRV = Components.classes["@mozilla.org/observer-service;1"]
  .getService(Components.interfaces.nsIObserverService);

var progressListen = {
  started: [],
  progress: null,
  task: null,
  isEngine: false,
  redirectedFrom: null,
  waitXHR: true,
  quietTime: 20,
  quietTimer: Components.classes["@mozilla.org/timer;1"]
    .createInstance(Components.interfaces.nsITimer),
  defaultConf: {
    quietTime: 20,
    waitXHR: true,
  },

  getDisplayName: function() {
    return "nsIWebProgressListener and nsIObserverService";
  },

  draw : function(surface, conf) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');

    xmlHelper.appendNode(surface, "label", null,
      { control: "quietTime", value:"New load threshold (ms):" });
    var quietTime = xmlHelper.appendNode(surface, "textbox", null,
      { id:"quietTime", value:conf.quietTime||this.defaultConf.quietTime});
    quietTime.addEventListener("input", function(e) {
      conf.quietTime = parseInt(quietTime.value);
    }, false);

    var attributes = { label: "Wait for XMLHttpRequests?" };
    if (conf.waitXHR || (conf.waitXHR === undefined && this.defaultConf.waitXHR))
      attributes.checked = true;
    var check = xmlHelper.appendNode(surface, "checkbox", null, attributes);
    check.addEventListener("command", function(e) {
      conf.waitXHR = this.checked;
    }, false);
  },

  wait: function(task, conf, step) {
    this.progress = task.connector.getPageWindow();
    if (!this.progress.addProgressListener)  {
      this.progress = Components.classes["@mozilla.org/docloaderservice;1"].getService(Components.interfaces.nsIWebProgress);
      this.isEngine = true;
    }
    this.task = task;
    this.step = step;

    // conf checking and defaults
    if (conf.waitXHR===undefined)
      this.waitXHR = this.defaultConf.waitXHR;
    else
      this.waitXHR = conf.waitXHR;
    if (conf.quietTime)
      this.quietTime = conf.quietTime;
    else
      this.quietTime = this.defaultConf.quietTime;

    this.started = [];

    if (this.waitXHR) {
      OBSRV.addObserver(this, "http-on-modify-request", false);
      OBSRV.addObserver(this, "http-on-examine-response", false);
      OBSRV.addObserver(this, "http-on-examine-cached-response", false);
    }
    this.progress.addProgressListener(progressListen, NOTIFY_ALL);
  },

  detatch: function () {
      if (this.progress)
        this.progress.removeProgressListener(this);
      this.progress = null;
      if (this.waitXHR) {
        OBSRV.removeObserver(this, "http-on-modify-request");
        OBSRV.removeObserver(this, "http-on-examine-response");
        OBSRV.removeObserver(this, "http-on-examine-cached-response");
      }
  },

  onTimeout: function () {
    this.task.warn("Following pages taking too long to finish:", this.step);
    for (var i=0; i<this.started.length; i++) {
      this.task.warn("*" + this.started[i].name, this.step);
    }
  },

  // This is implementing nsISupports and lets things know what interfaces
  // this object handles.  Naturally we're a progress listener but we also
  // can provide weak references to ourself thanks to XPConnect.
  QueryInterface: function(aIID) {
    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
        aIID.equals(Components.interfaces.nsIObserver) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
        aIID.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  removeRequest: function (aRequest) {
    for (var i=0; i<this.started.length; i++) {
      if (this.started[i] == aRequest) {
        this.started.splice(i, 1);
        this.task.debug("  REMOVED request: " + aRequest.name, this.step);
        break;
      }
    }
  },

  requestStart: function (aRequest) {
    // Guarantee unique requests
    this.removeRequest(aRequest);
    this.task.info("  started: " + aRequest.name, this.step);
    this.task.addRunDatumUrlEvent(aRequest.name, "start", this.step);
    this.started.push(aRequest);
  },

  requestStop: function (aRequest) {
    let httpChannel;
    let statusText = "";
    // Not all requests are HTTP channels
    try {
      //TODO: This works but why slow it down more, commenting just in case
      //httpChannel = aRequest.QueryInterface(Components.interfaces.nsIHttpChannel);
    } catch (e) {
    }
    // TODO: This slows it down too much or something and responses get missed
    if (false && typeof(httpChannel) === 'object') {
      statusText += " ("+ httpChannel.responseStatus + " " + httpChannel.responseStatusText + ") ";
      if (httpChannel.responseStatus < 400) {
        this.task.info("  completed" + statusText + aRequest.name, this.step);
      } else {
        this.task.warn("  failed" + statusText + aRequest.name, this.step);
      }
      var headerText = "  REQUEST: \n";
      let visitor = {
        "channel": httpChannel,
        "host":httpChannel.URI.host,
        "visitHeader": function (header, value) {
          headerText += "  " + header + ": " + value + "\n"
        }
      }
      httpChannel.visitRequestHeaders(visitor);
      this.task.debug(headerText, this.step);
      headerText = "  RESPONSE: \n";
      httpChannel.visitResponseHeaders(visitor);
      this.task.debug(headerText, this.step);
    } else {
      //this.task.info("  completed (no HTTP status) " + aRequest.name, this.step);
      this.task.info("  completed " + aRequest.name, this.step);
    }

    this.task.addRunDatumUrlEvent(aRequest.name, "stop", this.step);
    // Remove it from the array of pages we're waiting for
    this.removeRequest(aRequest);
    if (this.started.length == 0) {
      var context = this;
      this.task.info("  All pages loaded, waiting.", this.step);
      // The array of pending pages is empty, wait to allow new requests to start.
      this.quietTimer.initWithCallback(function () {
        if (context.started.length == 0) {
          context.task.info("No new requests, load complete.", context.step);
          Components.utils.import('resource://indexdata/util/waitForLoad.js');
          waitForLoad.detatch();
        }
      }, this.quietTime, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
    }
  },

  observe: function(subject, topic, data) {
    subject.QueryInterface(Components.interfaces.nsIRequest);
    subject.QueryInterface(Components.interfaces.nsIHttpChannel);
    if ((subject.notificationCallbacks)) {

      try
      {
          var xhrRequest = subject.notificationCallbacks.getInterface(Components.interfaces.nsIXMLHttpRequest);
          if (xhrRequest) {
            if (topic=="http-on-modify-request")
              this.requestStart(subject);
            if (topic=="http-on-examine-response" || topic=="http-on-examine-cached-response")
              this.requestStop(subject);
          }
      }
      catch (e) {}
    }
  },

  onStateChange: function(aWebProgress, aRequest, aFlag, aStatus) {
    var context = this;
    // This fires when the load event is initiated

    // Old dump code to get hex output
    // dump("STATE FLAG: 0x" + parseInt(aFlag.toString(2).substr(-8),2).toString(16) + " " + aRequest.name + "\n");

    // Function to dump a list of associated flags.
    var wplFlagDump = function(flags, req) {
      var output;
      var flagStrings = "STATE_START STATE_REDIRECTING STATE_TRANSFERRING STATE_NEGOTIATING STATE_STOP STATE_IS_REQUEST STATE_IS_DOCUMENT STATE_IS_NETWORK STATE_IS_WINDOW STATE_RESTORING STATE_IS_INSECURE STATE_IS_BROKEN STATE_IS_SECURE STATE_SECURE_HIGH STATE_SECURE_MED STATE_SECURE_LOW".split(" ");
      output = ("onStateChange FLAGS! " + req.name + " ::: ");
      for (var i=0; i<flagStrings.length; i++) {
        if (eval("Components.interfaces.nsIWebProgressListener." + flagStrings[i] + " & flags"))
          output += (flagStrings[i] + " ");
      }
      return output;
    };

    this.task.debug (wplFlagDump(aFlag, aRequest), this.step);
    this.task.debug (this.started.length + " requests BEFORE:", this.step);
    for (var i=0; i<this.started.length; i++, this.step) {
      this.task.debug(i + ". " + this.started[i].name, this.step);
    }
    if ((aFlag & STATE_IS_DOCUMENT) || !this.isEngine) {
      this.redirectedFrom = null
      if(aFlag & STATE_START && (aRequest.name.slice(0, 4) == "http")) {
        this.requestStart(aRequest);
      }
      if(aFlag & STATE_TRANSFERRING && (aRequest.name.slice(0, 4) == "http")) {
        this.requestStart(aRequest);
      }
      if(aFlag & STATE_STOP && (aRequest.name.slice(0, 4) == "http")) {
        this.requestStop(aRequest);
      }
    } else if (!(aFlag & STATE_IS_DOCUMENT) &&
        (aFlag & STATE_START) &&
        (aRequest.name.slice(0, 4) == "http") &&
        this.redirectedFrom &&
        this.isEngine) {
      this.task.info("  Location changed to: " + aRequest.name + " (heuristic)", this.step);
      // Update array
      this.requestStart(aRequest);
    }

    if((aFlag & STATE_REDIRECTING) && this.isEngine) {
      this.task.info("  Location changed from: " + aRequest.name + " (via STATE_REDIRECTING)", this.step);
      this.redirectedFrom = aRequest;
      this.requestStop(aRequest);
    }

    this.task.debug (this.started.length + " requests AFTER:");
    for (var i=0; i<this.started.length; i++) {
      this.task.debug(i + ". " + this.started[i].name, this.step);
    }
    return 0;
  },

  onLocationChange: function(aProgress, aRequest, aURI) {
    // Location: header is sent before any page content that could trigger
    // a new request and .equals doesn't find it ie. it's not giving a
    // reference to the same request object so the best we can do is assume
    // that whatever started most recently is what caused the redirect.
    // Bah.  This only happens in the builder.
    if ((aRequest.name.slice(0, 4) == "http")) {
      this.task.info("  Location changed to: " + aRequest.name + "(via onLocationChange)", this.step);
      this.task.info("  Assuming we've redirected from: " + this.started.pop().name, this.step);
      this.requestStart(aRequest);
//       this.started[this.started.length-1] = aRequest;
    }
    return 0;
  },

  onProgressChange: function(aProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) {
      var dumpRequest = aRequest
      if ( dumpRequest == null ) // defensive coding
          dumpRequest = { name: "NULL" };
    this.task.debug("  Progress: " + dumpRequest.name + " cur=" + aCurSelfProgress + " max=" + aMaxSelfProgress + " curTotal=" + aCurTotalProgress + " maxTotal=" + aMaxTotalProgress, this.step);
    return 0;
  },
  onStatusChange: function() {return 0;},
  onSecurityChange: function() {return 0;},
  onLinkIconAvailable: function() {return 0;}
};
