var EXPORTED_SYMBOLS = ["windowEvent"];
Components.utils.import('resource://indexdata/util/logging.js');

const STATE_START = Components.interfaces.nsIWebProgressListener.STATE_START;
const STATE_STOP = Components.interfaces.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING = Components.interfaces.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_IS_DOCUMENT = Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT;
const NOTIFY_ALL = Components.interfaces.nsIWebProgress.NOTIFY_ALL;

var logger = logging.getLogger("waitForLoad");

var windowEvent = {
  task: null,
  onEvent: null,
  event: "pageshow",
  eventList: ["DOMContentLoaded", "load", "pageshow"],
  window: null,
  defaultConf: {
    event: "pageshow",
  },

  getDisplayName: function() {
    return "Window event";
  },

  draw : function(surface, conf) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');
    xmlHelper.appendNode(surface, "label", null,
      { control: "eventMenu", value:"Event to wait for:" });
    var evMenu = xmlHelper.appendNode(surface, "menulist", null, {id:"eventMenu"});
    var evPopup = xmlHelper.appendNode(evMenu, "menupopup");
    for (var i=0; i < this.eventList.length; i++) {
      var e = this.eventList[i];
      var selected = false;
      if (conf.event) {
        if (conf.event==e)
          selected = true;
      }
      else if (this.defaultConf.event==e)
        selected = true;
      var item = xmlHelper.appendNode(evPopup, "menuitem", null, {label:e,value:e});
      if (selected)
        evMenu.selectedIndex = evMenu.getIndexOfItem(item);
    }

    evMenu.addEventListener("select", function(e) {
      conf.event = evMenu.selectedItem.value;
    }, false);
  },

  wait: function(task, conf) {
    this.task = task;
    this.event = conf.event || this.defaultConf.event;
    var context = this;
    // defined inline for closures,
    // stored with object for later removal
    this.onEvent =  function() {
      logger.info(context.event + " dispatched to main window, page is ready");
      Components.utils.import('resource://indexdata/util/waitForLoad.js');
      waitForLoad.detatch();
    }
    task.connector.getPageWindow().addEventListener(this.event, this.onEvent, false);
  },

  detatch: function () {
    this.task.connector.getPageWindow().removeEventListener(this.event, this.onEvent, false);
  },
};
