var EXPORTED_SYMBOLS = ["textHelper"];

// Small helper functions for text processing

var textHelper = {
  // camelCaseTo_under_score
  ccToUS: function (ccString) {
    var usString = ccString.replace(/[A-Z]/g, '_$&');
    if (usString.charAt(0) == '_') usString = usString.slice(1);
    return usString.toLowerCase();
  },
  // under_score_toCamelCase
  usToCC: function (usString, capFirst) {
    var ccString = usString.replace(/_./g, function(match) {
          return match.slice(1).toUpperCase();
        });
    if (capFirst != undefined && capFirst == false)
      return ccString;
    else
      return ccString.charAt(0).toUpperCase() + ccString.slice(1);
  },
  
  randString: function (length) {
    var chars = "abcdefghijklmnopqrstuvwxyz";
    chars += chars.toUpperCase();
    chars += "0123456789";
    var str = '';
    for(var i=0; i<length; i++){
      str += chars.charAt(Math.round(Math.random()*(chars.length-1)));
    }
    return str;
  },
  
  // Trim whitespce
  // Remove leading and trailing whitespace
  // collapse repeated whitespace into one space
  // Emulates the way html source gets displayed, and
  // users expect results to be
  removeWhiteSpace: function (str) {
      if (!str)
          return str;
      str = str.replace(/^\s+/,"");  
      str = str.replace(/\s+$/,"");
      str = str.replace(/\s+/," ");
      return str;
  },
  
  // Encodes all the xml entities 
  // so that we can display a xml/html string on the page
  // (used in the http client, mostly)
  encodeEntities: function(str) {
    str = str.replace( /&/g, "&amp;" );
    str = str.replace( /</g, "&lt;" );
    str = str.replace( /$/gm, "<br/>\n" );
    str = str.replace( / /g, "&nbsp;\n" );
    return str;
  },
  
}
