/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Pioneer Research Center USA, Inc.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    Tristan Van Berkom <tristan.van.berkom@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "cf_config.h"
#include "xpcom-config.h"
#include "mozilla-config.h"

#include "nsXULAppAPI.h"
#include "nsXPCOMGlue.h"

#include "nsCOMPtr.h"
#include "nsStringAPI.h"
#include "nsILocalFile.h"
#include "nsIURI.h"
#include "nsIWebNavigationInfo.h"
#include "nsServiceManagerUtils.h"
#include "nsDocShellCID.h"

#include "embed.h"
#include "ConsoleListener.h"

ConsoleListener::ConsoleListener(MozView *aOwner) : mOwner(aOwner)
{
}

ConsoleListener::~ConsoleListener()
{
}

NS_IMPL_ISUPPORTS2(ConsoleListener,
                   nsIConsoleListener,
                   nsISupportsWeakReference)

NS_IMETHODIMP
ConsoleListener::Observe(nsIConsoleMessage *aMessage)
{
    nsString msg;
    aMessage->GetMessageMoz(getter_Copies(msg));

    NS_ConvertUTF16toUTF8 retvalUtf8(msg);

    MozViewListener* pListener = mOwner->GetListener();
    if(pListener) {
	char* temp = new char[retvalUtf8.Length() + 1];
	strncpy(temp, retvalUtf8.get(), retvalUtf8.Length());
	temp[retvalUtf8.Length()] = 0;

	pListener->ConsoleMessage(temp);
	delete [] temp;
    }
    return NS_OK;
}


/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */
