#!/bin/sh
PROG=$0

dmin=20
dmax=80

xvfb_start() {
    d=$dmin
    i=0
    while test $d -lt $dmax; do
	Xvfb :$d -ac -screen 0 800x600x24 >Xvfb.$i.log 2>&1 &

	SUBPID=$!
	sleep 0.2
	if ps -p $SUBPID|grep "$SUBPID" >/dev/null; then
            :
	else
            echo "Xvfb :$d could not be started (already running?)"
            exit 1
	fi

	echo $SUBPID >Xvfb.$i.pid
	echo ":${d}.0" >Xvfb.$i.LCK
	i=`expr $i + 1`
	d=`expr $d + 1`
    done
    rm -fr tmp; mkdir tmp
}

xvfb_stop() {
    i=0
    while test -f Xvfb.$i.pid; do
	kill `cat Xvfb.$i.pid`
	rm Xvfb.$i.pid
	i=`expr $i + 1`
    done
    rm -f Xvfb.*.LCK
    rm -fr tmp; mkdir tmp
}

case "$1" in
    start)
	if test ! -f ../../connectors/cftest-04-openlibrary.cf; then
	    echo "Warning: cftest-04-openlibrary.cf unavailable"
	fi
	xvfb_start
	rm -fr tmp; mkdir tmp
	rm -f cf-zserver.log
        CF_LOG=1 \
            DISPLAY=:20.0 \
	    CF_BASE_PATH=`cd ../..; pwd` \
	    CF_TMP_DIR=`pwd`/tmp \
	    CF_APP_PATH=`pwd` \
	    ./cf-zserver -D -l cf-zserver.log -p mp.pid @:9010
	;;
    strace)
	xvfb_start
	rm -fr tmp; mkdir tmp
	rm -f cf-zserver.log
	strace -tt -f -o strace.log \
	    -E DISPLAY=:$dmin.0 \
	    -E CF_LOG=1 \
	    -E GRE_HOMEx=/usr/local/lib/xulrunner-1.9.2.12 \
	    -E CF_BASE_PATH=`cd ../..; pwd` \
	    -E CF_TMP_DIR=`pwd`/tmp \
	    -E CF_APP_PATH=`pwd` \
	    ./cf-zserver -l cf-zserver.log -p mp.pid @:9010
	;;
    ltrace)
	xvfb_start
	rm -fr tmp; mkdir tmp
	rm -f cf-zserver.log
	DISPLAY=:$dmin.0 \
            CF_LOG=1 \
	    GRE_HOMEx=/usr/local/lib/xulrunner-1.9.2.12 \
	    CF_BASE_PATH=`cd ../..; pwd` \
	    CF_TMP_DIR=`pwd`/tmp \
	    CF_APP_PATH=`pwd` \
	ltrace -S -tt -o ltrace.log \
	    ./cf-zserver -l cf-zserver.log -p mp.pid @:9010
	;;
    jinx)
	xvfb_start
	rm -fr tmp; mkdir tmp
	rm -f cf-zserver.log
	DISPLAY=:$dmin.0 \
            CF_LOG=1 \
	    GRE_HOMEx=/usr/local/lib/xulrunner-1.9.2.12 \
	    CF_BASE_PATH=`cd ../..; pwd` \
	    CF_TMP_DIR=`pwd`/tmp \
	    CF_APP_PATH=`pwd` \
	jinx run --output-file=jinx.log \
	    ./cf-zserver -l cf-zserver.log -p mp.pid @:9010
	;;
    jinx-all)
	jinx run --output-file=jinx.log --all & 
	;;
    jinx-stop)
	pkill jinx
	;;
    xvfb-start)
	xvfb_start
	;;
    xvfb-stop)
	xvfb_stop
	;;
    stop)
	if test -f mp.pid; then
	    if kill `cat mp.pid`; then
		rm mp.pid
	    fi
	fi
	xvfb_stop
	;;
    restart)
        echo stopping $0
        $0 stop
        echo starting $0
        $0 start
        echo started. xvfb=`cat Xvfb.pid` mp=`cat mp.pid`
        ;;
    *)
	echo "Usage: $PROG { start | stop | restart | strace | ltrace | help }"
	exit 1

esac

