/* This file is part of the Connector Framework
 * Copyright (C) 2008-2012 Index Data
 * See the file LICENSE for details.
 */

/** \file
 * \brief Mapping CF assertions to diagnostics
 */

#include <string.h>
#include <stdlib.h>
#include <yaz/diagbib1.h>
#include "cf_assert.h"

static const char *strrstr(const char *haystack, const char *needle)
{
    const char *cp, *cp1 = 0;

    while ((cp = strstr(haystack, needle)))
    {
        cp1 = cp;
        haystack = cp + strlen(needle);
    }
    return cp1;
}

void cf_interpret_assertions(int *errcode, const char *what,
                             const char **addinfo)
{
    if (what)
    {
        const char *cp = 0;

        if (!cp && (cp = strrstr(what, "ERROR_AUTHENTICATION")))
            *errcode = YAZ_BIB1_INIT_AC_AUTHENTICATION_SYSTEM_ERROR;
        if (!cp && (cp = strrstr(what, "ERROR_VERBATIM")))
            *errcode = YAZ_BIB1_UNSPECIFIED_ERROR;
        if (!cp && (cp = strrstr(what, "ERROR_BIB1")))
        {
            cp = strchr(cp, ':');
            if (cp)
            {
                cp++;
                *errcode = atoi(cp);
            }
        }
        if (!cp && (cp = strrstr(what, "ERROR_ACCESS")))
            *errcode = YAZ_BIB1_ACCESS_TO_SPECIFIED_DATABASE_DENIED;
        if (!cp && (cp = strrstr(what, "ERROR_TOOMANYUSERS")))
            *errcode =
                YAZ_BIB1_INIT_AC_MAXIMUM_NUMBER_OF_SIMULTANEOUS_SESSIONS_FOR_;
        if (cp)
        {
            if ((cp = strchr(cp, ':')))
                *addinfo = cp+1;
            else
                *addinfo = 0;
        }
        else
            *addinfo = what;
    }
}


/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

