/* This file is part of the Connector Framework
 * Copyright (C) 2008-2012 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_display.h
 * \brief CF_Display
 */

#ifndef CF_DISPLAY_H_INCLUDED
#define CF_DISPLAY_H_INCLUDED

#include <yaz/wrbuf.h>
#include "cf_logger.h"

class CF_Display {
public:
    CF_Display(CF_Logger *logger);

    ~CF_Display();

    bool lock(int fd);
    const char *get_error();

    const char *set_display();
    const char *get_display();

private:
    bool lock_via_xvfb_cmd(const char *lockdir, const char *xvfb_cmd,
                           int display_offset, int fd);
    void close();
    bool unlink_fname;
    int cf_lck_fd;
    int dno;
    WRBUF m_display;
    pid_t xvfb_pid;
    WRBUF fname_lck_file;
    WRBUF fname_log_file;
    WRBUF wrbuf_error;
    CF_Logger *m_logger;
};


#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

