/* This file is part of the Connector Framework
 * Copyright (C) 2008-2012 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_metadata.cpp
 * \brief Deal with Connector metadata
 */

#include <string.h>
#include <yaz/wrbuf.h>

#include "cf_metadata.h"

CF_Metadata::CF_Metadata()
{
    m_flags = wrbuf_alloc();
}

bool CF_Metadata::parse_doc(xmlDoc *doc)
{
    xmlNode *n = xmlDocGetRootElement(doc); // <connector> presumably
    if (!n)
        return false;
    for (n = n->children; n; n = n->next)   // stop at metaData (only one)
        if (n->type == XML_ELEMENT_NODE &&
            !strcmp((const char *) n->name, "metaData"))
            break;
    if (!n)
        return false;
    for (n = n->children; n; n = n->next)   // inspect each meta
        if (n->type == XML_ELEMENT_NODE &&
            !strcmp((const char *) n->name, "meta"))
        {
            const char *name = 0;
            const char *content = 0;
            struct _xmlAttr *attr;
            for (attr = n->properties; attr; attr = attr->next)
            {
                if (!strcmp((const char *) attr->name, "name"))
                    name = (const char *) attr->children->content;
                if (!strcmp((const char *) attr->name, "content"))
                    content = (const char *) attr->children->content;
            }
            if (name && content && !strcmp(name, "flags"))
            {
                wrbuf_puts(m_flags, content);
            }
        }
    return true;
}

bool CF_Metadata::parse_cf(const char *fname)
{
    wrbuf_rewind(m_flags);
    xmlDoc *doc = xmlParseFile(fname);
    if (!doc)
        return false;
    bool r = parse_doc(doc);
    xmlFreeDoc(doc);
    return r;
}

const char *CF_Metadata::get(const char *type)
{
    if (!strcmp(type, "flags"))
        return wrbuf_cstr(m_flags);
    return 0;
}

CF_Metadata::~CF_Metadata()
{
    wrbuf_destroy(m_flags);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

