/* This file is part of the Connector Framework
 * Copyright (C) 2008-2012 Index Data
 * See the file LICENSE for details.
 */

/** \file
 * \brief RPN to CF queries (JSON based)
 */

#include <yaz/wrbuf.h>
#include <yaz/z-core.h>

struct queryvalues;

class CF_RPN_to_JSON {
public:
    CF_RPN_to_JSON();
    ~CF_RPN_to_JSON();
    bool parse(Z_RPNQuery *q,
               const char *sub_database,
               struct sort_elem *sort_list);
    bool parse_full(Z_RPNQuery *q,
                    const char *sub_database,
                    struct sort_elem *sort_list);
    const char *get_result(int no);
    const char *get_full();
    int get_diagnostic(const char **addinfo);
    void set_capability_flags(const char *s);
private:
    WRBUF *json_results;
    WRBUF diag_w;
    WRBUF full_w;
    WRBUF capability_flags;
    int diag;
    char *stringterm(const Z_AttributesPlusTerm *zapt);
    bool apt(const Z_AttributesPlusTerm *zapt, struct queryvalues *qv);
    bool rpnstructure(const Z_RPNStructure *zs, struct queryvalues *qv);
    void build_query(struct queryvalues *qv, const char *sub_database,
        WRBUF w);
    int getindex(const Z_AttributesPlusTerm *zapt, struct queryvalues *qv);
    int findstringattridx(const char *strattr, struct queryvalues *qv );
    int getattrvalue(const Z_AttributesPlusTerm *zapt, int attrtype);
    char *getstringattr(const Z_AttributesPlusTerm *zapt, int attrtype);
    bool date_trickery(const Z_AttributesPlusTerm *zapt,
                       struct queryvalues *qv,
                       const char *term);
    bool set_date(struct queryvalues *qv, int idx, int year);
    void database( const char *sub_database, WRBUF w);
    bool full_proximity(const Z_ProximityOperator *zp);
    bool full_rpnstructure(const Z_RPNStructure *zs);
    bool full_apt(const Z_AttributesPlusTerm *zapt);
};

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */
