#!/bin/sh
# Simplified test script for one connector
# Outputs to stdout and stderr
# To be called from the test-connector web service
# Arguments: full path to the connector

dirname=`dirname $0`
basename=`basename $0 "-xvfb.sh"`

cd $dirname || exit 2

# Set up some environment
export CF_BASE_PATH=`cd ../..; pwd`
# Looks like it needs a $HOME, creates some files there
# Faking it under /tmp makes sure we always have a clean one
export FAKEHOME=/tmp/test-one-connector-$$
# The $$ is the PID of the current process, guaranteed unique
mkdir -p $FAKEHOME
export HOME=$FAKEHOME
FILES="$@"

# CF test commands
: ${CF_COMMANDS="test init?,search,parse,next,parse,next"}
: ${CF_RUN="./cfrun"}
: ${DEBUG=0}

if [ prefs.js -nt defaults/preferences/prefs.js ]; then
  echo ""
  echo "!!!WARNING: ./prefs.js is newer... don't forget to run make!!!"
  echo ""
  exit 9
fi
	

# apt-get install xvfb
if ! which Xvfb >/dev/null; then
  echo "WARNING: Xvfb (Virtual Framebuffer fake X server) not found!"
  exit 9
fi

# On Ubuntu 8.10, Xvfb has a nasty habit of dying after
# serving a small number of clients, if the screen size is not
# explicitly set.

: ${XVFB_SCREEN="-screen 0 800x600x24"}
echo Starting Xvfb >&2
AUTHFILE=/tmp/Xvfb.auth-$$
echo localhost > $AUTHFILE
Xvfb :1 $XVFB_SCREEN -auth $AUTHFILE >&2 & 
XPID=$!
echo Started Xfvb: pid=$XPID  >&2

export DISPLAY=:1.0


if test -z "$CF_RUN" -o ! -x $CF_RUN; then
  echo "WARNING: cfrun program does not exists. Don't forget to run make!"
  exit 9 
fi

counter=0
for c in $FILES; do
	if [ ! -f $c ]; then
		echo "Connector $c does not exist!"
		exit 2
	fi

	bc=`basename $c .cf`
	echo "$bc: Testing"$msg
        export CF_MODULE_PATH=$CF_BASE_PATH/builder/modules
	(
		echo "cf $c"
		echo "$CF_COMMANDS"
		echo "quit"
	) |
        ${CF_RUN}
done

# clean up
rm -f $AUTHFILE
#rm -rf -- $FAKEHOME

echo "Killing Xfvb $XPID" >&2
kill $XPID
echo "killed" >&2
