var EXPORTED_SYMBOLS = ["repoClient","uriListener"];
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import("resource://indexdata/util/io.js");

const NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

var logger = logging.getLogger();

//builder pref, id branch
var prefs = Components.classes["@mozilla.org/preferences-service;1"]
  .getService(Components.interfaces.nsIPrefService)
  .getBranch("indexdata.cf.");

/*
 * Provides entry point for handling files with application/cf+xml type
 * http://www.mozilla.org/projects/embedding/embedapiref/embedapi67.html
 */
var uriListener = {
  QueryInterface: function (iid) {
    if (iid.equals(Components.interfaces.nsIURIContentListener) ||
        iid.equals(Components.interfaces.nsISupportsWeakReference) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  isPreferred: function (contentType, desiredContentType) {
    return contentType == "application/cf+xml";
  },
  onStartURIOpen: function (uri) {
    //never gets called unless the listener is registered differently (how?)
    logger.debug("onStartURIOpen called, uri="+uri);
    return true;
  },
  canHandleContent: function (contentType, isContentPreferred,
    desiredContentType) {
    if (contentType == "application/cf+xml") {
      logger.debug("URI request for 'application/cf+xml', hijacking..");
      return true;
    } else return false;

  },
  doContent: function (contentType, isContentPreferred,
    request, contentHandler) {
    logger.debug("Assigning content handler for cT="+contentType
        +", pref="+isContentPreferred);
    var url = request.name;
    contentHandler.value = new cfContentHandler(url);
    return false;
  }
  /* some example include that, seems to work without
  GetWeakReference: function() {
    logger.debug("GetWeakReference");
    return this;
  }
  */
}

/*
 * Provides processing handler for application/cf+xml files
 * http://www.mozilla.org/projects/embedding/embedapiref/embedapi60.html
 */
function cfContentHandler (originUrl) {
  this.origin = originUrl;
  this.buffer = "";
};
cfContentHandler.prototype = {
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsISupports) ||
        iid.equals(Components.interfaces.nsIRequestObserver) ||
        iid.equals(Components.interfaces.nsIStreamListener)) {
      return this;
    } else {
      throw Components.results.NS_ERROR_NO_INTERFACE;
    }
  },
  onStartRequest: function (channel, context) {
    logger.debug("CF file request started..");
  },
  onStopRequest: function (channel, context, status) {
    if (status) {
      logger.warn("Bad connector download status ("
          +status+"). Ignoring request.");
      return;
    }
    logger.debug("CF file request finished. Parsing...");
    var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
      .createInstance(Components.interfaces.nsIDOMParser);
    var doc = parser.parseFromString(this.buffer, "text/xml");
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
          .getService(Components.interfaces.nsIWindowMediator);
    var win = wm.getMostRecentWindow("navigator:browser");
    win.toggleSidebar('viewCfBuilderSidebar', true);
    try {
      app.connector.loadConf(doc);
      try {
        app.connector.metaData.origin = baseName(this.origin);
        logger.debug("Origin overridden to '"
            +app.connector.metaData.origin+"'");
      } catch (e) {
        logger.debug(e.message);
        app.connector.metaData.origin = "";
      }
      app.notify("connector");
      app.set("lastOpened", null);
    } catch (e) {
      logger.debug(e);
      app.popupError("Cannot load file: " + e.message);
    }
  },
  onDataAvailable: function (request, context, inputStream, offset, count) {
    logger.debug("Reading connector file, offset=" +offset+", count="+count);
    // to actually read the contents, input stream must be wrapped
    // into something like Java's BufferedIS, it may be possible to avoid
    // this step by passing the string directly to DOMParser
    var charset = "UTF-8";
    const replacementChar =
      Components.interfaces.nsIConverterInputStream
        .DEFAULT_REPLACEMENT_CHARACTER;
    var cis = Components.classes["@mozilla.org/intl/converter-input-stream;1"]
              .createInstance(Components.interfaces.nsIConverterInputStream);
    cis.init(inputStream, charset, 1024, replacementChar);
    var strHolder = {};
    //the whole thing
    cis.readString(-1, strHolder);
    this.buffer += strHolder.value;
  }
}

/*
 * Content listener registration, registration performed this way means
 * that the handler will be called ONLY if no other appropriate/preffered
 * handler was found. This is the most unobtrusive method possible.
 */
var uriLoader = Components.classes["@mozilla.org/uriloader;1"]
  .getService(Components.interfaces.nsIURILoader);
uriLoader.registerContentListener(uriListener);


var repoClient = {
  doc: null,
  win: null,

  setXul: function (win) {
    this.win = win;
    this.doc = win.document;
  },

  openDefaultRepoInTab: function () {
    app.openOrReuseTab(this.getRepoUrl());
  },

  openDefaultRepo: function () {
     var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                        .getService(Components.interfaces.nsIWindowMediator);
    var mainWindow = wm.getMostRecentWindow("navigator:browser");
    mainWindow.content.document.location = this.getRepoUrl();
  },

  homerepo_url: function () {
    var url = prefs.getCharPref("homerepo");
    url = url.replace(/\/+$/, ""); // trim trailing slashes
    logger.debug("homerepo url: " + url);
    return url;
  },  

  // link to connector detailed page or the repo
  getRepoUrl: function () {
    var url = this.homerepo_url();
    var origin = "";

    try {
      origin = baseName(app.connector.metaData.origin);
    } catch (e) {
      origin = "";
    }

    // if there is an origin, link to the connector directly instead the home repo
    if (origin && origin != "") {
      url += "/" + origin + "?action=details";
    }

    logger.debug("open default repo: " + url);
    return url;
  },

  /* may not be used */
  openConnectorFromUrl: function (connectorUrl) {
  },

  ninjaOpenConnector: function () {
    var prompts=Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
        .getService(Components.interfaces.nsIPromptService);
    var database = null, username = null, password = null, proxy = null;
    //try from first init test
    var inits = app.connector.findTasks("init");
    if (inits && inits.length) {
      var init = inits[0];
      var initTest = init.tests.length ? init.tests[0] : null;
      if (initTest) {
        database = initTest.getArg('database');
        username = initTest.getArg('username');
        password = initTest.getArg('password');
        proxy = initTest.getArg('proxyip');
      }
    }
    if (!database) {
      //try to get from search
      var searchs = app.connector.findTasks("search");
      if (searchs.length) {
        var search = searchs[0];
        var searchTest = search.tests.length ? search.tests[0] : null;
        if (searchTest) {
          database = searchTest.getArg('database');
        }
      }
    }
    if (!database) {
      //try to get it from md
      logger.debug('Trying to get the database from metadata');
      var dbcsv = app.connector.metaData.subdb;
      if (dbcsv) {
        var dbs = dbcsv.split(',');
        database = dbs.length ? dbs[0] : null;
      }
    }
    //ask repo for current creds
    var repoURL = this.homerepo_url() + "?action=AUTH";
    var req = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Components.interfaces.nsIXMLHttpRequest);
    logger.debug("Request repo auth data from " + repoURL);
    req.open('GET', repoURL, false); /* synchronous! */
    req.send("");
    var repoDir = null, repoUser = null, repoPass = null;
    if (req.status == 200 && req.responseXML) {
      var doc = req.responseXML;
      repoDir = doc.getElementsByTagName('directory')[0].textContent;
      repoUser = doc.getElementsByTagName('loginuser')[0].textContent;
      repoPass = doc.getElementsByTagName('password')[0].textContent;
    } else {
      prompts.alert(null, "Repository failure",
          "Connector repository seems to be inaccessible at this time.");
      return;
    }
    //built ninja request url
    var ninjaURL = null;
    try {
      ninjaURL = prefs.getCharPref("ninjaurl");
    } catch (e) {
      logger.debug(e);
    }
    if (!ninjaURL) {
      prompts.alert(null, "Search test failed",
          "Search test report URL not specified in the Preferences");
      return;
    }
    var ninjaSearch = null;
    try {
      ninjaSearch = prefs.getCharPref("ninja.searchengine");
    } catch (e) {
      logger.debug(e);
    }
    if (!ninjaSearch) {
      prompts.alert(null, "Search test failed",
          "Search execution engine URL not specified in the Preferences ");
      return;
    }
    //upload to temp repo
    var tempUrl = this.homerepo_url() + "/temp";
    var req = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Components.interfaces.nsIXMLHttpRequest);
    logger.debug("Uploading temp connector (POST "+tempUrl+")...");
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
      .getService(Components.interfaces.nsIWindowMediator);
    var mainWindow = wm.getMostRecentWindow("navigator:browser");
    mainWindow.setCursor("wait");
    req.open('POST', tempUrl, false); /* synchronous! */
    req.setRequestHeader('Content-Type', "application/xml");
    //no need to serialize, but the content-type will be overriden
    req.send(app.connector.saveConf().ownerDocument);
    mainWindow.setCursor('auto');
    logger.debug("Got response - " + req.status);
    var loc = null;
    if (req.status == 201)  {
      loc = baseName(req.getResponseHeader("Location"));
      if (loc) {
        logger.debug("Got Location: " + loc);
      } else {
        logger.debug("Failed, no Location");
        prompts.alert(null, "Uploading temporary connector failed",
        "Response from the server doesn't contain the 'Location' header.");
      }
    } else {
      logger.debug("Failed, response follows:");
      logger.debug(req.responseText);
      prompts.alert(null, "Uploading temporary connector failed",
          "Invalid response from the server ("
          +req.status+"), see log for details.");
    }
    //open ninja test result page
    var repoBaseParts = this.homerepo_url().match(/(https?:\/\/)(.+?)\/.*/);
    var repoBase = repoBaseParts[1] + repoUser + ":" + repoPass + "@"
      + repoBaseParts[2];
    var targetURL = repoBase + "/toroid.pl/temp/"  + loc
      + (!database ? "" : ":" + encodeURIComponent(
            database.replace(/\s+\([^(]+\)$/,"")));
    var auth = (!username ? null
        : (!password ? username : username + "/" + password));
    ninjaURL = ninjaURL + "?t=" +
      encodeURIComponent(targetURL)
      + ("&b=" + encodeURIComponent(ninjaSearch))
      + (!auth ? "" : "&a=" + encodeURIComponent(auth))
      + (!proxy ? "" : "&px=" + encodeURIComponent(proxy));
    app.openOrReuseTab(ninjaURL);
  },

  testOpenConnector: function () {
    // enable js
    Components.classes["@mozilla.org/preferences-service;1"]
      .getService(Components.interfaces.nsIPrefService)
      .getBranch("javascript.enabled")
      .setBoolPref("", true);
    var testURL = this.homerepo_url();
    var req = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Components.interfaces.nsIXMLHttpRequest);
    logger.debug("Sending test request (POST "+testURL+")...");
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
      .getService(Components.interfaces.nsIWindowMediator);
    var mainWindow = wm.getMostRecentWindow("navigator:browser");
    mainWindow.setCursor("wait");
    req.open('POST', testURL, false); /* synchronous! */
    req.setRequestHeader('Content-Type', "application/xml");
    //no need to serialize, but the content-type will be overriden
    req.send(app.connector.saveConf().ownerDocument);
    mainWindow.setCursor('auto');
    logger.debug("Got response - " + req.status);
    var prompts=Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
      .getService(Components.interfaces.nsIPromptService);
    if (req.status == 201)  {
      var loc = req.getResponseHeader("Location");
      if (loc) {
        logger.debug("Got Location: " + loc);
        loc = loc.match(/^https?:\/\//gi) ? loc : hostName(testURL) + loc;
        logger.debug("Use Location: " + loc);
        app.openOrReuseTab(loc);
      } else {
        logger.debug("Failed, no Location");
        prompts.alert(null, "Testing failed",
        "Response from the testing server doesn't contain 'Location' header.");
      }
    } else {
      logger.debug("Failed, response follows:");
      logger.debug(req.responseText);
      prompts.alert(null, "Testing failed", "Invalid response from the testing"
          + " server ("+req.status+"), see log for details.");
    }
  },

  pushOpenConnector: function () {
    //validate meta-data
    var prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
      .getService(Components.interfaces.nsIPromptService);
    var metaDefs = app.template.getMetaData();
    for (var i=0; i<metaDefs.length; i++) {
      var validate = metaDefs[i].validate;
      if (validate && validate === "non-empty") {
        var mkey = metaDefs[i].name;
        var mval = app.connector.metaData[mkey];
        if (!mval) {
          prompts.alert(null, "Missing meta-data",
              "The connector is missing a '"+mkey+"', "
              + "please fill it out and try again.");
          var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
            .getService(Components.interfaces.nsIWindowMediator);
          var mainWindow = wm.getMostRecentWindow("navigator:browser");
          mainWindow.open('chrome://cfbuilder/content/meta_editor.xul',
              'metaEditor', 'chrome,resizable=yes').focus();
          return;
        }
      }
    }
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                          .getService(Components.interfaces.nsIWindowMediator);
    var win = wm.getMostRecentWindow("navigator:browser");
    //we will try to push the connector to 'origin' defined in the meta-data
    //if it's not there we go for the file name and push to home-repo
    try {
      app.connector.metaData.origin = baseName(app.connector.metaData.origin);
      logger.debug("Basenamed origin to '"+app.connector.metaData.origin+"'");
    } catch (e) {
      logger.debug(e.message);
      app.connector.metaData.orgin = "";
    }
    var origin = app.connector.metaData.origin;
    if (!origin) {
      var input = {value: ""};
      //try filename then be creative
      if (app.lastOpened)
        input.value = app.lastOpened.path.replace(/.*[\/\\]/, "");
      else
        input.value = app.connector.metaData['title'].toLowerCase()
          .replace(/\s+/g, '_') + '.cf';
      var check = {value: false}; // default the checkbox to false
      var result = prompts.prompt(null, "Push connector to the repository",
        "Connector has no origin and will be pushed to the home repository. " +
        "Provide a name (it's recomended to use the proposed name):",
        input, null, check);
      if (!result) return;
      origin =  input.value;
      var creq = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Components.interfaces.nsIXMLHttpRequest);
      creq.open('GET', this.homerepo_url() + "/" + origin,
          false); /* synchronous! */
      creq.send("");
      logger.debug("Checking if the file exists on the server..");
      if (creq.status == 200) {
        logger.debug("It does.");
        var ret = prompts.confirm(null, "File already exists",
            "A file with a given name already exists in the repository. " +
            "Would you like to overwrite it?");
        if (!ret) return;
      }
      app.connector.metaData.origin = origin;
    }
    //ask for commit message
    var user = null;
    try {
      user = prefs.getCharPref("username");
    } catch (e) {
      logger.debug("Pref 'username' not found, will try current user");
    }
    if (!user) {
      var env = Components.classes["@mozilla.org/process/environment;1"]
      .getService(Components.interfaces.nsIEnvironment);
      user = env.get('USER') || env.get('USERNAME');
    }
    var input = {value: ""};
    var check = {value: true};
    var cMsg = user
      ? "sign as '"+user+"' (change signature in Preferences)"
      : null;
    var result = prompts.prompt(null, "Provide a version (upload) message",
        "Please briefly describe the changes made to the connector:",
        input, cMsg, check);
    if (!result) {
      win.alert("Upload canceled.");
      return;
    }
    if (!input.value) {
      win.alert("Upload canceled due to an empty message");
      return;
    }
    var comMsg = check.value ? user +": "+ input.value : input.value;
    app.connector.metaData.lastCommit = comMsg;
    if (app.version) app.connector.metaData.cfbuilder_version = app.addon.version;

    var originURL = this.homerepo_url() + "/" + origin;
    logger.debug("Pushing to " + originURL);
    var req = Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
      .createInstance(Components.interfaces.nsIXMLHttpRequest);
    req.open('PUT', originURL, false); /* synchronous! */
    req.setRequestHeader('Content-Type', "application/xml");
    //no need to serialize, but the content-type will be overriden
    req.send(app.connector.saveConf().ownerDocument);
    if (req.status == 201)  {
      var loc = req.getResponseHeader("Location");
      if (loc) {
        logger.debug("Location: "+loc+" -- basename will serve as origin..");
        try {
          app.connector.metaData.origin = baseName(loc);
          app.notify("lastOpened");
        } catch (e) {
         logger.warn("Unexpected Location, extracting basename failed");
         win.alert("Malformed 'Location' ("+loc+") returned from the Repo - "
         +"version shown in the builder may not correspond "
         +"to the version on the server.");
       }
      }
      app.notify("canSave");
      app.reloadTabIfOpen(this.homerepo_url(), false);
      win.alert("File created on the server.");
    //200 is for backwards-compatibility with old repo API
    } else if (req.status == 200 || req.status == 204) {
      if (req.status == 200)
        logger.warn("Response code 200 -- this indicates deprecated repo WS.");
      var loc = req.getResponseHeader("Location");
      if (loc) {
        logger.debug("Location: "+loc+" -- basename will server as origin...");
        try {
          app.connector.metaData.origin = baseName(loc);
          app.notify("lastOpened");
        } catch (e) {
          logger.warn("Unexpected Location, extracting basename failed");
          win.alert("Malformed 'Location' ("+loc+") returned from the Repo - "
           +"version shown in the builder may not correspond "
           +"to the version on the server.");
        }
      }
      app.notify("canSave");
      app.reloadTabIfOpen(this.homerepo_url(), false);
      win.alert("File updated on the server.");
    } else win.alert("ERROR: file not saved on the server '" + originURL
	+ "', HTTP status: " +req.status
        + ", Please check your homerepo setting! Web server error message: '"
	+ req.responseText + "'");
  }
};

function baseName (urlOrPath) {
  var base = urlOrPath.replace(/.*[\/\\]/, "");
  if (!base) throw new Error("Cannot extract base name -- empty");
  return base;
}

function hostName (url) {
  return url.match(/^(https?:\/\/[^\/]+)/i)[1];
}
