/*
 * A collection of JS functions that fix some language inconsistencies.
 * Based on ideas by Douglas Crockford.
 */

// instance method to declare a method on an object
Function.prototype.method = function (name, func) {
    this.prototype[name] = func;
    return this;
};

// class method to declare create new object from parent
if (typeof Object.beget !== 'function') {
    Object.beget = function (o) {
        var F = function () {};
        F.prototype = o;
        return new F();
    }
}

// this is for the classical inheritance
Function.method('inherits', function (Parent) {
    this.prototype = new Parent();
    return this;
});
