var EXPORTED_SYMBOLS = ["xulHelper"];
var xulHelper = null;

// Only initialise the xulHelper object in the builder TODO: proper separation of app
let xulAppInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
if (xulAppInfo.name !=="ConnectorFramework") { /* BEGIN BUILDER ONLY WRAPPER */

var EXPORTED_SYMBOLS = ["xulHelper"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import('resource://indexdata/util/inspector.js');
Components.utils.import('resource://indexdata/ui/XpathRefine.js');
Components.utils.import('resource://indexdata/ui/app.js');

xulHelper = {

  // since we want to leave listhead and listcols and such
  clearList: function(list) {
    var items = list.getElementsByTagName('listitem');
    while(items.length > 0) {
      list.removeChild(items[items.length - 1]);
    }
  },

  // we often only want to add flex if horizontal
  onlyFlexSideways: function(element, box, flex) {
    if (typeof(flex) !== 'number') flex = 1;
    if (app.mainWindow.getComputedStyle(box)
        .getPropertyValue('-moz-box-orient') === 'horizontal') {
      element.setAttribute('flex', flex);
    }
  },

  // Simple helpers to produce input elements for the step-editing screens
  captionField: function(parentnode, caption, attributes) {
    //var capt = xmlHelper.appendNode(parentnode, "caption", caption, attributes);
    // TODO - This ought to avoid some warnings about XUL elements...
    if ( ! attributes )
      attributes = {};
    attributes["label"] = caption;
    var capt = xmlHelper.appendNode(parentnode, "caption", null, attributes);
    // */
    return capt;
  },

  labelField: function(parentnode, caption, attributes) {
    if ( ! attributes )
      attributes = {};
    attributes["value"] = caption;
    var lbl = xmlHelper.appendNode(parentnode, "label", null, attributes);
    return lbl;
  },

  inputField: function(parentnode, step, confindex, caption, captionWidth, attributes) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null,
        { align: "center" }, null);
    // Callers passing flex through to the field will also need the hbox to flex.
    // But only horizontally.
    if ( attributes && attributes["flex"] ) {
      xulHelper.onlyFlexSideways(hbox, parentnode, attributes["flex"]);
    }
    if (captionWidth === undefined) captionWidth = 220;
    xmlHelper.appendNode(hbox, "caption", caption,
        { width: captionWidth }, null);
    return xulHelper.inputFieldOnly(hbox, step, confindex, attributes);
  },

  inputFieldOnly: function(parentnode, step, confindex, attributes) {
        if (attributes == null) attributes = {};
        if (confindex != "") {
            var v = step.conf[confindex];
            attributes.value = (v == undefined) ? "" : v;
        }
        var input = xmlHelper.appendNode(parentnode, "textbox", null, attributes, null);

        input.addEventListener("input", function(e) {
            if (confindex != "") {
                step.conf[confindex] = input.value;
                //dump("Change event on input [" + confindex  + "] " +
                //  "'" + input.value + "'\n");
            }
        }, false);

    input.cf_setValue = function(v) {
      if ( confindex != "" )
        step.conf[confindex] = v;
      input.value = v;
    };
    return input;
  },

  xpathField: function(parentnode, step, confindex, caption) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null, null, null);
    //var input = xulHelper.inputField(hbox, step, confindex, caption);
    // Detail: this creates another hbox inside the current one, do we care?
    // caption
    xmlHelper.appendNode(hbox, "caption", caption,
      { width: 220 }, null);
    var input = xulHelper.singleNodeField(hbox, step, confindex);
    return input;
  },

  selectField: function(parentnode, step, confindex, caption, options, attributes) {
      var hbox = xmlHelper.appendNode(parentnode, "hbox", null, { align: "center" }, null);
      xmlHelper.appendNode(hbox, "caption", caption, null, null);
      if (!attributes)
          attributes = {};
      var menulist = xmlHelper.appendNode(hbox, "menulist", null, attributes, null);
      var menupop = xmlHelper.appendNode(menulist, "menupopup", null, null, null);
      var v = step.conf[confindex];
      var selidx = -1
      var i = 0;
      for ( var optname in options ) {
          if (!v){ // value not set, default to the first
              v=optname;
              step.conf[confindex]=v;
          }
          var disp = options[optname];
          if (!disp)
              disp = optname;
          var attrs = { "label": disp, "value" : optname };
          if ( v == optname ) {
              attrs.selected = true;
              selidx = i;
          }
          xmlHelper.appendNode(menupop, "menuitem", null, attrs, null );
          i++;
      }
      // Some times the selected item doesn't stick! This forces it
      if ( menulist.selectedIndex < 0 ) {
          //dump("forcing selectField selection to " + selidx + "\n");
          menulist.selectedIndex = selidx;
      }
      menulist.addEventListener("command", function(e) {
          step.conf[confindex]=menulist.value;
      }, false);
      return menulist;
  },


  // Basically an input field that remembers its history, and offers a pull-down
  // option to select one of the previous values. The history is kept in the
  // config, under the histindex.
  // DEPRECATED - Only used by parse_xpattern, which is about to change.
  historySelectField: function(parentnode, step, confindex, caption, histindex) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null, null, null);
    xmlHelper.appendNode(hbox, "caption", caption, { width: 220 }, null);
    var menulist = xmlHelper.appendNode(hbox, "menulist");
    menulist.setAttribute("editable",true);
    var menupop = xmlHelper.appendNode(menulist, "menupopup");
    prependHistory();

    menulist.addEventListener("command", function(e) {
      //dump("historySelectField: command event v='" + menulist.value + "' " +
      //       " l='" + menulist.label + "'\n");
      step.conf[confindex] = menulist.value;
      prependHistory();
    },false);

    menulist.addEventListener("change", function(e) {
      //dump("historySelectField: change event  v='" + menulist.value + "' " +
      //    " l='" + menulist.label + "'\n");
      step.conf[confindex] = menulist.value;
      prependHistory();
    },false);

    menulist.setNewValue = function(val) {
      //dump("setNewValue: old='" + step.conf[confindex] + "' " +
      //     "new='" + val + "'\n");
      menulist.value = val;
      prependHistory(val);
    }; // setnewValue
    return menulist;

    function prependHistory(newval) {  // inside historySelectField
      var newhist = [];
      if (newval && newval != step.conf[confindex]) { // new is usually undefined
        //dump("prependHistory: starting with " +
        //    "Old: '" + step.conf[confindex] + "' " +
        //    "new: '" + newval + "' \n");
        var oldval = step.conf[confindex];
        newhist.push(newval);
        step.conf[confindex] = newval;
        newhist.push(oldval);
      } else {
        newhist.push ( step.conf[confindex] );
        //dump("prependHistory: starting with '" + step.conf[confindex] + "' \n");
      }
      if ( step.conf[histindex] == undefined){
        //dump("prependHistory: Creating new history\n");
        step.conf[histindex] = [];
      }
      //dump("prependHistory: before: h.length=" + step.conf[histindex].length + "\n");
      var i;
      for ( i=0; (i<step.conf[histindex].length) && (newhist.length<10); i++) {
        if (step.conf[histindex][i] != step.conf[confindex] ) {
          //dump("_prependHistory: adding '" + step.conf[histindex][i] + "' \n");
          newhist.push(step.conf[histindex][i]);
        }
      }
      step.conf[histindex] = newhist;
      //dump("prependHistory: after: h.length=" + step.conf[histindex].length + "\n");
      //dump("prependHistory: menupop= " + menupop + "\n");
      xmlHelper.emptyChildren(menupop);
      for ( i=0; i<step.conf[histindex].length; i++) {
        var val = step.conf[histindex][i];
        xmlHelper.appendNode(menupop, "menuitem", null,
          { label: val, value: val, selected: (i==0) });
      }
      //xmlHelper.dumpxml(menulist);
    }; // prependHistory inside historySelectField


  }, // historySelectField

  // Simple pull-down menu.
  // Takes a simple array of strings for the values OR an array of object
  // of the form {key:"display value", value:"some value"}
  // extraoptions is usually not provided, but can be used to add options to
  // the beginning of the list, for example ["none"].
  // Some times all the values come from extraoptions, and options itself
  // can be empty.
  //
  // ...or takes a hash with option values mapping to display names,
  // for example { 'ti': 'Title', 'au': 'Author' }
  arraySelectField: function(parentnode, step, confindex, options, extraoptions) {
    //dump("arraySelectField: Starting with " + options.length + " items -----\n");
    var theSelectedItem = undefined;
    var i;

    if ( ! options ) {
      // defensive coding, any kind of non-value will do
      /*
      dump("arraySelectField called without options\n");
      dump("confindex='" + confindex + "'\n");
      dump("options='" + options + "'\n");
      dump("exraoptions='" + extraoptions + "'\n");
      */
      options = [];
    } else if (typeof(options) != "object") {
      throw new Error("Invalid options parameter to arraySelectField.");
    }

    var menulist = xmlHelper.appendNode(parentnode, "menulist");
    var menupop = xmlHelper.appendNode(menulist, "menupopup");
    var selected = (!confindex || !step.conf[confindex]);

    // build menu one way for an array, somewhat differently for a hash/object
    if (Array.isArray(options)) {
      if (extraoptions && extraoptions.length) {
        var dedupped = [];
        for (i = 0; i < extraoptions.length; i++) {
          var val = extraoptions[i];
          if (val !== "" && options.indexOf(val) < 0) {
            dedupped.push(val);
          }
        }
        options = dedupped.concat(options);
      }

      for (i = 0; i < options.length; i++) {
        let item = options[i];
        let key = '';
        let value = '';
        if (typeof item == 'object' && 'value' in item && 'key' in item) {
          key = item.key;
          value = item.value;
        } else {
          key = item;
          value = item;
        }
        if (confindex && step.conf[confindex] == value)
          selected = true;
        if (!confindex && i==0)
          selected = true;
        if (selected) {
          theSelectedItem = xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: value, selected: true });
        } else {
          xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: value });
        }
        selected = false;
      }
    } else {
      for (var key in options) {
        if (confindex && step.conf[confindex] == options[key])
          selected = true;

        if (selected) {
          theSelectedItem = xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: options[key], selected: true });
        } else {
          xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: options[key] });
        }
        selected = false;
      }
    }
    // the above setting of the selected attribute on the menuitem
    // elements doesn't seem to always stick, but setting the
    // selectedItem won't work the first time a step is drawn.
    // so we do one, and if it wasn't enough, we do the other
    if (menulist.selectedIndex < 0)
      menulist.selectedItem = theSelectedItem;

    if (menulist.selectedItem && menulist.selectedItem.value) {
        if (confindex) {
            //*dump("*** arraySelectField() setting conf[" + confindex + "]\n");
            step.conf[confindex] = menulist.selectedItem.value;
            //*dump("*** arraySelectField() has set conf[" + confindex + "]\n");
        }
      //dump("setting step.conf[" + confindex + "] to '" + step.conf[confindex] + "'\n");
    }

    menulist.addEventListener("command", function(e) {
        if (confindex) {
            step.conf[confindex] = menulist.selectedItem.value;
        }
      }, false);
    //*dump("arraySelectField() returning " + menulist + " = <" + menulist.localName + ">\n");
    return menulist;
  },

  // Force the selection to value. If not found, leaves untouched,
  // unless makeit is true, in which case will make the new option
  // at the end of the list
  selectMenulistItemWithValue: function(menulist, value, makeit) {
    var i = 0;
    dump("selectMenulistItemWithValue() searching '" + menulist + "' " +
         "(type '" + typeof(menulist) + "' " +
         "with localName '" + menulist.localName + "') " +
         "for '" + value + "', count = " + menulist.itemCount + "\n");
    while (i < menulist.itemCount) {
      var item = menulist.getItemAtIndex(i);
      
      dump("selectMenulistItemWithValue() comparing '" + item.value + "' " +
           "with '" + value + "' => " + (item.value == value) + "\n");
      
      if (item.value == value) {
        menulist.selectedItem = item;
        return true;
      }
      i++;
    }
    if ( makeit ) {
        // TODO - There is some sort of race condition here,
        // if I add debug dumps here, all works. If not, it fails
        // with "menulist.appendItem is not a function" See bub 7138
        try {
          var newitem = menulist.appendItem( value, value )
          menulist.selectedItem = newitem;
        } catch(e) {
          //dump("Caught an error when appending a menu item " + e + "\n");
          for ( var f in menulist )
            if ( typeof(menulist[f]) == "function" ) // kills some time
              //dump("menulist has function " + f + "\n");
          try {
            var newitem = menulist.appendItem( value, value )
            menulist.selectedItem = newitem;
            //dump("menulist.appendItem worked the second time !!!\n");
          } catch(e) {
            //dump("Again caught an error when appending a menu item " + e +"\n");
          }
        }
        // Actually, we should not normally get here at all, but we tend to
        // do so, because earlier, menulist.itemCount is undefined, so we
        // fail to check if the item is in the list already. Another sympton
        // of the same bug, I bet.
    } else {
        // no item found, so nothing should be selected
        menulist.selectedIndex = -1;
    }
    return false;
  },

  // A single (editable?) pull-down to select a parameter name from
  // the template, given a jspnPath prefix. For example, select
  // from the children of $.output to get the list of regular
  // output parameters.
  // groups is a boolean, defaulting to false, in which case it takes
  // only regular names. If true, it selects instead from available
  // items that are groups in the own right.
  // TODO - At some point we should refactor jsonPathField to use this
  singleJsonPathField: function( surface, step, confindex, caption,
                    jsonPrefix,  groups, extraoptions ) {
    //dump("singleJsonPathField starting g=" + groups +
    //     " p='" + jsonPrefix + "'\n");
    if (!groups)
        groups = false;
    var hb = xmlHelper.appendNode(surface, "hbox", null, {align: "center"});
    xulHelper.onlyFlexSideways(hb, surface);
    if (caption)
      xmlHelper.appendNode(hb, "caption", caption);
    var templ = step.task.getTemplate().properties.data;
    var obj = jsonPath(templ, jsonPrefix);
    if ( !obj ) {
      //dump("singleJsonPathField: '" + jsonPrefix + "' failed, " +
      //     "trying output.results\n");
      obj = jsonPath(templ, "$.output.results"); // a good guess
    }
    if ( !obj ) {
      //dump("singleJsonPathField: '" + jsonPrefix + "' failed, plain output\n");
      obj = jsonPath(templ, "$.output"); // another good guess
    }
    //obj = obj[0][0]; // it seems always to be a double array ??!!
    // but if there was no such thing in the template, we get nothing much
    // and can't dereference it. Defensive coding below:
    if ( Array.isArray(obj) )
      obj=obj[0];
    if ( Array.isArray(obj) )
      obj=obj[0];
    //dump("got obj: " + obj + "\n");
    //dump(JSON.stringify(obj) + "\n");
    var list = [];
    for ( var k in obj ) {
        if ( groups ) {
            if ( obj[k].length != 0 )  // contains elements, is a group
                list.push(k);
        } else {
            if ( obj[k].length == 0 ) // plain variable
                list.push(k);
        }
    }
    var ret = xulHelper.arraySelectField(hb, step, confindex, list,
                                         extraoptions);
    //dump("singleJsonPathField done \n");
    return ret;
  }, // singleJsonPathField

  jsonPathField: function(surface, step, confObj, confKey, caption, initial) {
    var defawlt = {path: "", key: "output"};
    var context = this;
    var outerBox = xmlHelper.appendNode(surface, "hbox", null, {align:"center"});
    xulHelper.onlyFlexSideways(outerBox, surface);
    if (caption)
      xmlHelper.appendNode(outerBox, "caption", caption);
    var box = xmlHelper.appendNode(outerBox, "hbox", null,
                                   {align: "center", flex: 1});
    var spec = confObj[confKey];
    if (typeof spec !== "object") {
      if (typeof(initial) === "object")
        spec = initial;
      else
        spec = {};
      confObj[confKey] = spec;
    }

    // If this is a path to write to (indicated by setting a default append mode),
    // provide options for appending values
    if (spec.append) {
      let toSelect = spec.append;
      let cur;
      let radioGroup = xmlHelper.appendNode(outerBox, "radiogroup", null,
        {orient: "horizontal"});
      cur = xmlHelper.appendNode(radioGroup, "radio", null,
        {label: "append", value: jsonPathHelper.APPEND});
      if (toSelect === jsonPathHelper.APPEND)
        radioGroup.selectedItem = cur;
      cur = xmlHelper.appendNode(radioGroup, "radio", null,
        {label: "concat", value: jsonPathHelper.CONCAT});
      if (toSelect === jsonPathHelper.CONCAT)
        radioGroup.selectedItem = cur;
      cur = xmlHelper.appendNode(radioGroup, "radio", null,
        {label: "replace", value: jsonPathHelper.REPLACE});
      if (toSelect === jsonPathHelper.REPLACE)
        radioGroup.selectedItem = cur;
      radioGroup.addEventListener("select", function(e) {
        confObj[confKey].append = Number(radioGroup.selectedItem.value);
      }, false);
    }

    var drawAdvanced;

    var drawBasic = function() {
      xmlHelper.emptyChildren(box);
      var lists = [];
      var popups = [];
      var toSelect = [];
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {pos: 0}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 1, editable: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 2, editable: true, disabled: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 3, editable: true, disabled: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));

      if (spec.path) {
        // Matches a JSONpath like:
        // $.output.results[*].holdings[*]
        // with groups for the keys
        let keyRegex = /^\$\.(\w*)(?:\.(\w*)\[\*\])?(?:\.(\w*)\[\*\])?$/

        let matches = keyRegex.exec(spec.path);
        if (matches) {
          for (let i = 1; i < matches.length; i++) {
            if (matches[i]) {
              // regex groups create a sparse array
              toSelect.push(matches[i]);
            }
          }
        } else {
          drawAdvanced();
        }
      }

      if (spec.key) {
        toSelect.push(spec.key);
      }

      var tmpl = step.task.getTemplate().properties.data;

      // If we have no path or key, start with the first space:
      if (toSelect.length === 0) toSelect = [Object.keys(step.task.data)[0]];

      for (var i = 0; i < toSelect.length; i++) {
        var addSeparator = false;
        var theSelectedItem = false;
        var nextTemplate = false;

        lists[i].removeAttribute('disabled');

        if (i===0) {
          var obj = step.task.data;
        } else {
          let jp = jsonPathHelper.pathFromArray(toSelect.slice(0, i));
          var obj = jsonPath(step.task.data, jp)[0];
          if (tmpl) var tmplObj = jsonPath(tmpl, jp)[0];
        }

        // Add existing values to dropdown
        for (let key in obj) {
          addSeparator = true;
          if (key == toSelect[i]) {
            theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: key, value: key, selected: true});
          } else {
            xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: key, value: key});
          }
        }

        // Add values from template
        if (tmplObj) {
          if (addSeparator === true) {
            xmlHelper.appendNode(popups[i], "menuseparator");
            addSeparator = false;
          }
          for (let key in tmplObj) {
            addSeparator = true;
            if (key == toSelect[i]) {
              theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
              {label: key, value: key, selected: true});
              nextTemplate = tmplObj[key];
            } else {
              xmlHelper.appendNode(popups[i], "menuitem", null,
              {label: key, value: key});
            }
          }
        }

        // Add selected item if not already there
        if (toSelect[i] && !theSelectedItem) {
          if (addSeparator === true)
            xmlHelper.appendNode(popups[i], "menuseparator");
          theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: toSelect[i], value: toSelect[i], selected: true});
        }

        if (theSelectedItem) {
          lists[i].selectedItem = theSelectedItem;
        } else {
          // Nothing wound up selected, select the first one
          lists[i].selectedIndex = 0;
          nextTemplate = tmplObj ? tmplObj[lists[i].value] : false;
        }
      }

      // Show template children even though top level objects aren't templated.
      // This, I think, is better than including the session object explicitly
      // in all templates, etc.
      if (i === 1 && typeof(tmpl) === 'object') {
        nextTemplate = tmpl[toSelect[0]];
      } else if (Array.isArray(nextTemplate) && typeof(nextTemplate[0]) === "object") {
        // Record template is always the first element
        nextTemplate = nextTemplate[0];
      } else nextTemplate = false;

      // Enable next drop box if it has a template
      if (nextTemplate && i < lists.length) {
        lists[i].removeAttribute('disabled');
        for (let key in nextTemplate) {
          xmlHelper.appendNode(popups[i], "menuitem", null,
          {label: key, value: key});
        }
      }

      var switchButton = xmlHelper.appendNode(box, "button", null,
        {"label": "Advanced"});

      var updateConf = function (e) {
        let selected = [];
        for (let i = 0; i < lists.length; i++) {
          if (lists[i].value)
            selected.push(lists[i].value);
        }
        let newSpec = jsonPathHelper.specFromArray(selected);
        spec.path = newSpec.path;
        spec.key = newSpec.key;
      }

      var handleSelection = function (e) {
        // Reset remaining select fields
        for (let j = Number(e.currentTarget.getAttribute("pos")) + 1; j < lists.length; j++) {
          lists[j].selectedIndex = -1;
          lists[j].setAttribute("disabled", true);
        }
        updateConf();
        // Need to redraw in case template has nested items below this
        // and more drop-downs need to be enabled/populated.
        drawBasic();
      }

      for (let i = 0; i < lists.length; i++) {
        lists[i].addEventListener("command", handleSelection, false);
        lists[i].addEventListener("change", handleSelection, false);
        lists[i].addEventListener("input", updateConf, false);
      }

      switchButton.addEventListener("command", function (e) {
        drawAdvanced();
      }, false);
    }

    drawAdvanced = function() {
      xmlHelper.emptyChildren(box);
      var pathField = xmlHelper.appendNode(box, "textbox", null,
        {"value": spec.path || "", "flex": 3, "minwidth": 120});
      var keyField = xmlHelper.appendNode(box, "textbox", null,
        {"value": spec.key || "", "flex": 1, "minwidth": 20});
      var switchButton = xmlHelper.appendNode(box, "button", null,
        {"label": "Basic"});

      pathField.addEventListener("input",
        function (e) {spec['path'] = pathField.value}, false);
      pathField.addEventListener("change",
        function (e) {spec['path'] = pathField.value}, false);
      keyField.addEventListener("input",
        function (e) {spec['key'] = keyField.value}, false);
      keyField.addEventListener("change",
        function (e) {spec['key'] = keyField.value}, false);
      switchButton.addEventListener("command", function(e) {
        drawBasic();
      }, false);
    }

    drawBasic();
    return box;
  },

  jsonPathMapField: function(surface, step, inKey, outKey, defaultIn, defaultOut) {
    let box = xmlHelper.appendNode(surface, "vbox");
    let inBox = xulHelper.jsonPathField(box, step, step.conf, inKey, "Source: ", defaultIn);
    let outBox = xulHelper.jsonPathField(box, step, step.conf, outKey, "Output: ",
                                         defaultOut || {append:jsonPathHelper.REPLACE});

    if (!step.conf[outKey]) step.conf[outKey] = {unchanged:true};
    else if (!step.conf[outKey].key) step.conf[outKey].unchanged = true;

    // Update unchanged target to represent
    let updateOut = function (e) {
      if (step.conf[outKey].unchanged && e.target.localName !== 'button') {
        Components.utils.import("resource://indexdata/ui/taskPane.js");
        step.conf[outKey].key = step.conf[inKey].key;
        step.conf[outKey].path = step.conf[inKey].path;
        xmlHelper.emptyChildren(taskPane.stepBox);
        step.draw(taskPane.stepBox);
      }
    }
    inBox.addEventListener("command", updateOut, false);
    inBox.addEventListener("change", updateOut, false);

    // Mark target changed
    let outChanged = function (e) { delete step.conf[outKey].unchanged; };
    outBox.addEventListener("command", function (e) { outChanged(); }, false);
    outBox.addEventListener("change", outChanged, false);

    return box;
  },

  // node selector, optionally takes a function to call against
  // the node once selected
  singleNodeField: function(surface, step, confKey, func) {
    var text = "";

    if (confKey)
      text = xmlHelper.nodeSpecToString(step.conf[confKey]);
    var hbox = xmlHelper.appendNode(surface, "hbox", null, {"align":"center", "flex":1}, null);
    var inbox = xmlHelper.appendNode(hbox, "vbox", null, {"flex":1}, null);
    var input = xmlHelper.appendNode(inbox, "textbox", null,
        {"value": text, "flex": 1, "minwidth": 160}, null);
    var selectButton = xmlHelper.appendNode(hbox, "button", null,
        {"label": "Select node"}, null);
    var refineButton = xmlHelper.appendNode(hbox, "button", null,
        {"label": "Refine xpath"}, null);

    var subtext = xmlHelper.appendNode(inbox, "description", null, {"class":"subtext"}, null);

    var testXpathUpdateConf = function(e) {
      let newNodeSpec = xmlHelper.nodeSpecFromString(input.value);
      // only test xpaths that don't depend on replacements
      if (input.value.indexOf("{$") === -1) {
        let matchCount = xmlHelper.getMatchCountByNodeSpec(step.getPageDoc(), newNodeSpec);
        if (matchCount === 1) {
          input.removeAttribute("class");
          subtext.setAttribute("value", "");
        } else if (matchCount > 1) {
          input.setAttribute("class", "incomplete");
          subtext.setAttribute("value", "Warning: " + matchCount + " elements match this XPath.");
        } else {
          subtext.setAttribute("value", "Warning: No elements match this XPath.");
        }
      }
      if (confKey) step.conf[confKey] = newNodeSpec;
    };

    // Defensive coding, occasionally we have a plain old string
    // in the conf. This converts to a proper nodeSpec.
    if ( confKey && typeof(step.conf[confKey]) == "string" ) {
      var newNodeSpec = xmlHelper.nodeSpecFromString(step.conf[confKey]);
      step.conf[confKey] = newNodeSpec;
    }

    input.addEventListener("input", testXpathUpdateConf, false);
    input.addEventListener("change", testXpathUpdateConf, false);

    var context = this;
    var selectNode = function(e) {
      app.newHl(step.getPageDoc(), function() {
        var node = this;
        if ( node.cf_datanode ) {
          node = node.cf_datanode;
        }
        var nodeSpec = xmlHelper.getNodeSpec(node, true);
        input.value = xmlHelper.nodeSpecToString(nodeSpec);
        if (confKey) {
          step.conf[confKey] = nodeSpec;
        }
        app.highlighter.destroy();
        step.task.connector.onStepParametersUpdate(step);
        refineButton.removeAttribute("disabled");
        input.removeAttribute("class");
        if (func) func(this);
        return false;
      });
    };
    selectButton.addEventListener("command", selectNode, false);

    refineButton.addEventListener("command", function(e) {
      let target = xmlHelper.getElementByNodeSpec(step.getPageDoc(), step.conf[confKey]);
      if (target) { 
        new XpathRefine(target, step.conf[confKey]['xpath'], function (x) {
          step.conf[confKey]['xpath'] = x;
          input.value = xmlHelper.nodeSpecToString(step.conf[confKey]);
          input.removeAttribute("class");
          step.task.connector.onStepParametersUpdate(step);
        });
      }
    }, false);

    // TODO: This doesn't trigger the node selector, so we can't have it start out in selection mode when you add
    //selectNode();
    return input;
  },

  // helpers to highlight nodes, and to remove the highlights
  // the userhighlight boolean tells if the highlight comes
  // directly from the user, of from matching.
  // If the node has cf_displaynode or cf_datanode set, does
  // the highlighting for that too (without recursing, as those
  // tend to be cyclical!)
  highlightNode: function(node, color, userhighlight ) {
    var nodes = [ node, node.cf_displaynode, node.cf_datanode  ];
    for ( var i in nodes ) {
      var n = nodes[i];
      if (n) {
        var old = "" ;
        if ( n.style ) {
          old = n.style.backgroundColor;
          n.style.backgroundColor=color;
        }
        if ( n.getAttribute ) {
          // for some reason, CDATA nodes seem not to have getAttribute()
          var oldattr = n.getAttribute("cf_old_style");
          if (oldattr == undefined ) {
            n.setAttribute("cf_old_style",old);
          }
          if (userhighlight) {
            n.setAttribute("cf_user_highlight",color);
          }
        }
      }
    }
  }, // highlightNode

  unhighlightNode: function(node, userhighlight ) {
    var nodes = [ node, node.cf_displaynode, node.cf_datanode  ];
    for ( var i in nodes ) {
      var n = nodes[i];
      if (n) {
        if ( n.getAttribute) {
          var old = n.getAttribute("cf_old_style") ;
          if (old != undefined) {
            if ( n.style )
              n.style.backgroundColor = old;
            n.cf_old_style = undefined;
          }
          if (userhighlight) {
            n.removeAttribute("cf_user_highlight");
          }
        }
      }
    }
  },

  unhighlightAll: function(node, userhighlight) {
      while (node != null) {
        xulHelper.unhighlightNode(node,userhighlight);
        xulHelper.unhighlightAll(node.firstChild,userhighlight);
        node = node.nextSibling;
        // do not recurse to nextSibling, or long pages risk
        // "too much recursion".
      }
  },

  /*
   * Creates a tab-box on the specified node consisting one tab for
   * each of the strings in the array of titles, and using the
   * specified set of attributes for the top-level tabbox element.
   * Returns an array of nodes representing the tab panels.
   */
  tabBox: function(node, titles, attributes) {
    var res = [];
    var box = xmlHelper.appendNode(node, "tabbox", null, attributes);
    var tabs = xmlHelper.appendNode(box, "tabs");
    for (var i = 0; i < titles.length; i++) {
      var tabattrs = { label: titles[i] };
      if (i == 0) tabattrs.selected = true;
      xmlHelper.appendNode(tabs, "tab", null, tabattrs);
    }
    var panels = xmlHelper.appendNode(box, "tabpanels", null,
                     { flex: 1 } );
    for (var i = 0; i < titles.length; i++) {
      res.push(xmlHelper.appendNode(panels, "tabpanel", null, 
                                    { style:'overflow: auto;'} ));
    }
    return res;
  },

  checkbox: function(surface, step, confindex, label, attrs) {
    if (!attrs )
        attrs = {};
    if (label )
        attrs.label = label;
    if (confindex != "" && step.conf[confindex]) {
      attrs.checked = true;
    }
    var cb = xmlHelper.appendNode(surface, "checkbox", null, attrs);
    cb.addEventListener("command", function(e) {
      if (confindex != "")
        step.conf[confindex] = this.checked;
    }, false);

    cb.cf_setValue = function(v) {
      if ( confindex != "" )
        step.conf[confindex] = v;
      cb.checked = v;
    };

    return cb;
  },
} // xulHelper

} /* END BUILDER ONLY WRAPPER */
