#!/bin/bash
# A simple script to test the content-proxy enabled connectors
# Intended as a developing tool, you may have to edit the 
# connector numbers and/or credentials below, if things change...

# Default engine (or override with a second argument)
#ZENG=${2:-"@:9020"}
ZENG=${2:-"connect.indexdata.com"}

QRY="helsinki"

case $1 in
  p) 
    CONN="proquest-cp"
    USER="ebsco2test"
    PASS="ebsco"
    ;;
  a)
    CONN="abc-clio-cp"
    USER="ebscodemo2"
    PASS="ebscodemo2"
    ;;
  n)
    CONN="newsbank-cp"
    USER="ebscotest"
    PASS="ebscotest"
    ;;
  o)
    CONN="ovid-journals"
    USER="azlinks"
    PASS="linking"
    QRY="water"
    ;;
  v)
    CONN="ovid_rd_insight"
    USER="ebsco999"
    PASS="deliver8"
    QRY="water"
    ;;
  *)
    echo "$0: test [engine] "
    echo "  a: abc-clio"
    echo "  n: newsbank"
    echo "  p: proquest"
    exit 1
esac


echo "Searching for $QRY with $CONN"
zoomsh \
  "set user idtest" \
  "set password idtest36" \
  "open $ZENG/$CONN?user=$USER&password=$PASS" \
  "find $QRY" \
  "set form xml" \
  "show 1" \
  "quit" \
  > /tmp/z.out

cat /tmp/z.out

echo
cat /tmp/z.out | perl -ne 's/&amp;/&/g; print $1 if /<url>(.*)<\/url>/;'
echo
echo
