#!/bin/sh
# assumes pwd is engine/src

# You can give the name of the connector to test,
# but defaults to running all

DIR=`dirname $0`            # ../../connectors/cf-zserver-regression
PLAINDIR=`basename $DIR`    # cf-zserver-regression
CONNECTORS="$1"             # default is to run all, but you can ask for one

case `uname` in 
	Linux ) ;;
	* ) export CF_APP_PATH=`pwd` ;;
esac

echo "running regression in $DIR"
CF_DISPLAY_LOCK=/tmp/cf-xvfb \
   ./cf-zserver -l cf-zserver.log unix:socket -p cf-zserver.pid -D
test $? -ne 0 && (echo "Could not start cf-zserver"; echo "You may need to run: killall cf-zserver lt-metaproxy"; exit 1)
: ${diff_opt="-u"}
: ${REGRESSION_FATAL=false}


GRET=0
error () {
    $REGRESSION_FATAL && exit 1

    plus=$1
    test -n "$plus" || plus=1   
    GRET=`expr $GRET + $plus`
}

if [ ! -z $CONNECTORS ]
then
  echo "Testing only $CONNECTORS"
  CONNECTORLIST=$CONNECTORS
else
  CONNECTORLIST=`cd $DIR/..; ls *.cf $PLAINDIR/*.cf`
fi

for C in $CONNECTORLIST
do
    CNAME=`basename $C .cf`
    CDIR=`dirname $C`
    if [ $CDIR = "." ]
    then
      CONNECTOR=$CNAME
    else
      CONNECTOR=$CDIR/$CNAME
    fi

    #echo "Testing $CONNECTOR"
    RET=0
    QRYFILE=$DIR/$CNAME.query
    # Make sure we have a query file, with plain "water" if need be
    test -f $QRYFILE ||
      echo "@attr 1=1016 @attr 2=3 @attr 3=3 @attr 4=2 "\
           "@attr 5=100 @attr 6=1 water" > $QRYFILE
    LOG=$DIR/$CNAME.log
    rm -f $LOG
    while read QRY1
    do  # for each line in the file
      echo "======================" >> $LOG
      QRY=`echo $QRY1 | sed 's/^#.*$//' `  # strip comment lines
      echo $QRY1  >> $LOG
      if [ ! -z "$QRY" ]
      then 
        zoomsh "connect unix:socket" "set databaseName $CONNECTOR" \
                  "search $QRY" \
                  "show 0 1" "show 1 1" "quit" >>$LOG
        test $? -ne 0 && RET=1
      fi
    done < $QRYFILE
    if test -f $DIR/$CNAME.out; then
	diff $diff_opt $DIR/$CNAME.out $LOG
	if test $? -ne 0; then
            #kill `cat cf-zserver.pid`
            #rm -f cf-zserver.pid
            # exit 1
            # We can *either* kill the cf-zserver and exit, *or* set error
	    echo "  $CNAME: differ"
            error 1
	else
	    echo "  $CNAME: OK"
	fi
    else
        kill `cat cf-zserver.pid`
        rm -f cf-zserver.pid
        echo "$CNAME FAIL!"
        echo "  Missing file: $CNAME.out"
        echo "  Please check that $CNAME.log looks right, and copy it to $CNAME.out"
        echo "  And add it to git with "
        echo "    cd $DIR; git add $CONNECTOR.out"
        echo "  (make sure the .query file is in git too!)"
        error 1
    fi    
  
done # connector loop
kill `cat cf-zserver.pid`
rm -f cf-zserver.pid

exit $GRET
