Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
const Ci = Components.interfaces;
const Cc = Components.classes;

function ConnectorRuntime() {
  this.connector = null; };

var CFAppender = function(logInterface) {
    this.name = "cfappend";
    this._logInterface = logInterface;
};
CFAppender.prototype.append = function (prefix, levelName, message) {
    this._logInterface.log(levelName, message);
};

CFAppender.prototype.toString = function() {
  return "CFAppender";
};

var UnicodeConverter = Cc["@mozilla.org/intl/scriptableunicodeconverter"]
  .createInstance(Ci.nsIScriptableUnicodeConverter);
UnicodeConverter.charset = "UTF-8";

var CookieManager = Cc["@mozilla.org/cookiemanager;1"].getService(Ci.nsICookieManager);

ConnectorRuntime.prototype = {
  //XPCOM STUFF used by the XPCOMUtils
  classDescription: "CF connector runtime",
  classID:          Components.ID("{1b0946b6-0e2d-4848-ae6b-299052d7a19d}"),
  contractID:       "@indexdata.com/connectorruntime;1",
  QueryInterface: XPCOMUtils
        .generateQI([Ci.nsIConnectorRuntime,Ci.nsIObserver]),
  //member functions
  init: function(modulePath, logInterface) {
    //register alias for the module path
    var ioService = Cc["@mozilla.org/network/io-service;1"]
    .getService(Ci.nsIIOService);
    var resProt = ioService.getProtocolHandler("resource")
    .QueryInterface(Ci.nsIResProtocolHandler);
    var aliasFile = Cc["@mozilla.org/file/local;1"]
    .createInstance(Ci.nsILocalFile);
    aliasFile.initWithPath(modulePath);
    var aliasURI = ioService.newFileURI(aliasFile);
    resProt.setSubstitution("indexdata", aliasURI);
    //load the required module
    Components.utils.import('resource://indexdata/runtime/Connector.js');
    Components.utils.import('resource://indexdata/runtime/Tester.js');
    Components.utils.import('resource://indexdata/util/logging.js');
    //instantiate the connector
    this.connector = new Connector();
    this.connector.setInEngineFlag(true);
    var appender = new CFAppender(logInterface);
    logging.modifyLoggers([appender]);
    this.logger = logging.getLogger();
  },
  observe: function(subject, topic, data) {
  },
  setBrowserWindow : function (browserWindow) {
    this.connector.setPageWindow(browserWindow);
  },
  loadConf: function (filePath, sessionJSON, errormessage) {
    try {
      if (sessionJSON) {
        var session = JSON.parse(UnicodeConverter.ConvertToUnicode(sessionJSON));
      } else {
        var session = {};
      }
      CookieManager.removeAll();
      this.connector.loadConfFromFile(filePath, session);
    } catch (e) {
      errormessage.value = e.message;
    }
  },
  saveConf: function (filePath, errormessage) {
    try {
      this.connector.saveConfToFile(filePath);
    } catch (e) {
      errormessage.value = e.message;
    }
  },
  runScript: function (filePath, errormessage) {
    try {
      let localFile = Cc["@mozilla.org/file/local;1"]
                      .createInstance(Ci.nsILocalFile);
      localFile.initWithPath(filePath);
      let fstream = Cc["@mozilla.org/network/file-input-stream;1"].createInstance(Ci.nsIFileInputStream);
      let cstream = Cc["@mozilla.org/intl/converter-input-stream;1"].createInstance(Ci.nsIConverterInputStream);
      // read only
      fstream.init(localFile, -1, 0, 0);
      cstream.init(fstream, "UTF-8", 0, 0);

      let script = "";

      let (str = {}) {
        let read = 0;
        do {
          read = cstream.readString(0xffffffff, str); // read as much as we can
          script += str.value;
        } while (read != 0);
      }
      cstream.close(); // closes fstream
      eval(script);
    } catch (e) {
      errormessage.value = e.message;
    }
  },
  runTask: function (taskName, optional, jsonStrInput, connectorReturn) {
    if (jsonStrInput === "") jsonStrInput = "{}";
    var context = this;
    var input = JSON.parse(UnicodeConverter.ConvertToUnicode(jsonStrInput));
    var argNames = [];
    for (var key in input)
      argNames.push(key);
    var task = this.connector.findTask(taskName, argNames);
    if (task === null) {
      if (optional)
        connectorReturn.taskDone(true, "{}");
      else if (this.connector.findTasks(taskName) === null)
        connectorReturn.taskDone(false, "Task not found");
      else
        connectorReturn.taskDone(false, "Task: no implementation of task " + taskName + " using arguments " + argNames.join() + "\n");
      return;
    }
    task.clearData();
    for (key in input)
      task.setArgValue(key, input[key]);
    task.addHandler("onTaskFinish", function (outcome, result) {
        task.removeHandler("onTaskFinish", arguments.callee);
        if (outcome) {
          connectorReturn.
            taskDone(true, UnicodeConverter.ConvertFromUnicode(JSON.stringify(result)));
        } else {
            connectorReturn.taskDone(false, UnicodeConverter.ConvertFromUnicode(result));
        }
      });
    task.run();
  },
  runTests: function (taskOrderString, connectorReturn) {
    var tester = new Tester();
    tester.onTestSuccess = function () {
      connectorReturn.testsFinished(true);
    };
    tester.onTestFailure = function () {
      connectorReturn.testsFinished(false);
    };
    if (!tester.runInOrder(this.connector, taskOrderString)) {
      connectorReturn.testsFinished(false);
    }
  },

  DOMString: function (retval) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');
    retval.value = UnicodeConverter.ConvertFromUnicode(xmlHelper.dumpxml(this.connector.getPageDoc()));
  },

  // Little helper to load a module for unit testing. 
  // Returns the imported module, zero if not found, -1 if other error
  // Logs other errors
  // If mustfind is true, counts notfound as any other error.
  _import: function(path,name,mustfind) {
    var filename = 'resource://indexdata/' + path + name;
    if ( !filename.match( /\.js$/ ) )
      filename += ".js";
    try {
      var imp = Components.utils.import(filename);
      this.logger.info("=== Running unitTest " + path + name);      
    } catch (e) {
      this.logger.error("Exception loading " + filename + ":" + e);
      if ( e.name == "NS_ERROR_FILE_NOT_FOUND"  ) {
        if (mustfind)
        this.logger.error("Failed to load " + path+name + ": File not found" );
        return 0;
      } else {        
        this.logger.error("Error loading " + path+name + " !!!" );
        this.logger.error(e.message);
        if ( e.lineNumber && e.fileName )
          this.logger.error("  in " + e.fileName + ":" + e.lineNumber  );
        return -1;
      }
    }
    return imp;
  },
  
  // unitTest - takes a name of a js file without the .js extension
  // (util/xpattern or modules/skip/skip)
  //
  // Loads that file and calls the unitTest on each exported object and on an
  // instance of each exported class.
  //
  // This method should return true if successful.
  unitTest: function (name) {
    //this.logger.info("\nRunning unitTest " + name);
    try {
      name = name.replace(/\.js$/,"");
      var imp = this._import('', name) ||
                this._import("steps/" + name + "/", name ) ||
                this._import("util/", name ) ||
                this._import('', name, true);  
                // I want to try the direct path first to give it precedence,
                // and last, to log the notfound error without any fancy path
      if (!imp || imp == -1)
        return false;
      for ( var i in imp.EXPORTED_SYMBOLS ) {
        var objtype = imp.EXPORTED_SYMBOLS[i];
        var varname = "my_" + objtype ;
        var classCode = "var "+varname+" = new " + objtype + "(); " + varname + ".unitTest();";
        var objCode = objtype + ".unitTest();";
        // this.logger.info("About to call " + objtype + ".unitTest() \n");
        try {
          var retval = eval(classCode);
        } catch (e) {
          if (e.message.slice(-17) === "not a constructor") {
            var retval = eval(objCode);
          } else {
            this.logger.error(e);
          }
        }
        if ( retval == true ) {
          this.logger.info("=== Unit test for " + objtype + " OK");
        } else { // not true, can be false, or a string
          this.logger.error("=== Unit test for " + objtype + " failed");
          if ( retval != false ) {
            this.logger.error(retval);
          }
          return false;
        }
      }
    } catch (e) {
      this.logger.error(e);
      if ( e.lineNumber && e.fileName )
        this.logger.error("  in " + e.fileName + ":" + e.lineNumber  );
      return false;
    }
    return true;
  }
};

// Generate XPCOM interface, array wrap to pass reference
var components = [ConnectorRuntime];
var NSGetFactory = XPCOMUtils.generateNSGetFactory(components);

// Local variables:
// c-basic-offset: 2
// indent-tabs-mode: nil
// End:
// vim: shiftwidth=2 tabstop=8 expandtab

