#!/bin/sh
#
#  A start script for the engine. Supports N parallel processes on
#  different ports and displays:
#    
#    $ MAX_SERVERS=4 XVFB=1   ./cf-server.sh
#    Start server on display: :6, port 9996, logfile:  logs/server:9996.log
#    Start server on display: :7, port 9997, logfile:  logs/server:9997.log
#    Start server on display: :8, port 9998, logfile:  logs/server:9998.log
#    Start server on display: :9, port 9999, logfile:  logs/server:9999.log
#
#    default is one process.

#if [ X"$GRE_HOME" = X ]; then
#	echo "Please set environment variable GRE_HOME!"
#	exit 2
#fi

: ${DEBUG=0}

# max. number of parallel servers
: ${MAX_SERVERS=1}

# server network interface
: ${CFZSERVER_HOSTNAME="@"}

# which ports cfzserver should use
: ${CFZSERVER_PORT="9999"}

: ${CFZSERVER_LOGLEVEL=default}

# the CF server program
: ${CFZSERVER_PROGRAM="./cf-zserver"}

# the CF user
: ${CFZSERVER_USER=""}

# the CF pid file prefix
: ${CFZSERVER_PID_P="logs/cfzserver"}

# the CF log file prefix
: ${CFZSERVER_LOGFILE_P="logs/cfzserver"}

test -d logs || mkdir logs
cf_base_path=`cd ../..; pwd`

if [ -n "$CFZSERVER_CFREPO_CONNECTOR_PATH" ]; then
	CF_MODULE_PATH=$cf_base_path/builder/modules; export CF_MODULE_PATH

        # the CFrepo connector path can be an absoulte or relative path (to CF home)
        case $CFZSERVER_CFREPO_CONNECTOR_PATH in
		/* ) CF_CONNECTOR_PATH=$CFZSERVER_CFREPO_CONNECTOR_PATH ;;
		 * ) CF_CONNECTOR_PATH=$cf_base_path/$CFZSERVER_CFREPO_CONNECTOR_PATH ;;
	esac
	export CF_CONNECTOR_PATH

	# cleanup: CF_BASE_PATH override CF_CONNECTOR_PATH
	unset CF_BASE_PATH
else
	CF_BASE_PATH=$cf_base_path; export CF_BASE_PATH
fi


if test -z "$MAX_SERVERS" || test $MAX_SERVERS -lt 1 -o $MAX_SERVERS -gt 1000; then
	MAX_SERVERS=2
	echo "WARNING: reset MAX_SERVERS=$MAX_SERVERS"
fi

if test -n "$CFZSERVER_USER"; then
	cf_user="-u $CFZSERVER_USER"
fi

command=$1
if test -n "$1";  then
	shift
fi

case "$command" in
	start | stop ) ;; # work will be done later in the script

	restart)
		$0 stop
		exec $0 start "$@"
		;;

	*)
        echo "Usage: `basename $0` [ start | stop | restart ]" >&2
        exit 2
        ;;
esac


######################################################################
# main
#
for server in `perl -e 'for (1 .. shift) { print qq[$_ ] }' $MAX_SERVERS`; do
	port=`expr $CFZSERVER_PORT - $server + 1`
	logfile=$CFZSERVER_LOGFILE_P-$port.log
	pidfile=$CFZSERVER_PID_P-$port.pid

        # display absolute logfile path name
	case $logfile in /*) ;; *) logfile=`pwd`/$logfile;; esac

	if [ -f $pidfile ]; then
		pid=`cat $pidfile`
		if kill -0 $pid 2>/dev/null; then
			kill $pid
			sleep 1
			kill -9 $pid >/dev/null 2>&1
		fi
		rm -f $pidfile
	fi

	if [ $command = "start" ]; then
            if test "$XVFB"; then
             	echo localhost > logs/Xvfb.hosts
		export DISPLAY=:$server
               	Xvfb $DISPLAY -auth logs/Xvfb.hosts -screen 0 800x600x24 > logs/Xvfb:$server.log 2>&1 &
            fi

	    if test -z "$DISPLAY"; then
		 echo "WARNING: display not set!"
	    fi

	    echo "Start server on display: $DISPLAY, port $port, logfile: $logfile"
	    ${CFZSERVER_PROGRAM} -D -v $CFZSERVER_LOGLEVEL -p $pidfile -l $logfile $cf_user $CFZSERVER_HOSTNAME:$port 
	fi
done

