/* This file is part of the Connector Framework
 * Copyright (C) 2008-2012 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file connector_wrap.h
 * \brief ConnectorWrap / ConnectorReturn header
 */

#include "cf_logger.h"
#include "nsIConnectorRuntime.h"
#include "nsCOMPtr.h"

class ConnectorWrap;

/** \brief handler function type for task results */
typedef void resultfunc_t(void *vp, bool success, const char *result);

/** \brief handler function type for tests (done) */
typedef void test_func_t(void *vp, bool success);

/**
 * Implements the nsIConnectorReturn interface.. Is used for us
 * to get a response from the nsiConnectorRuntime XPCOM ..
 */
class ConnectorReturn : public nsIConnectorReturn
{
public:
    NS_DECL_ISUPPORTS NS_DECL_NSICONNECTORRETURN

    ConnectorReturn(ConnectorWrap *w);
    virtual ~ConnectorReturn();
private:
    ConnectorWrap *m_wrap;
};

/**
 * Implements the nsIConnectorLog interface.. Is used for us
 * to get log messages from nsIConnectorRuntime XPCOM ..
 */
class ConnectorLog : public nsIConnectorLog
{
public:
    NS_DECL_ISUPPORTS NS_DECL_NSICONNECTORLOG

    ConnectorLog(ConnectorWrap *w);
    virtual ~ConnectorLog();
private:
    ConnectorWrap *m_wrap;
};


/**
 * Wrapper for the nsiConnectorRuntime XPCOM. Is responsible for
 * all communication with JavaScript based XPCOM ConnectorRuntime.js
 */
class ConnectorWrap {
public:
    friend class ConnectorReturn;
    friend class ConnectorLog;
    ConnectorWrap(const char *modulePath,
                  CF_Logger *log_int);
    ~ConnectorWrap();
    bool loadConf(const char *filePath, const char *sessionJSON, char **errormessage);
    bool saveConf(const char *filePath, char **errormessage);
    bool runScript(const char *filePath, char **errormessage);
    bool setBrowserWindow(nsIDOMWindow *win);
    void runTask(const char *taskName, bool optional,
                 const char *jsonStrInput,
		 void *vp, resultfunc_t *resultfunc);
    void runTests(const char *taskOrder, void *vp,
                  resultfunc_t *resultfunc, test_func_t *test_func);
    bool unitTest(const char *name);
    bool DOMString(char **retval);
private:
    nsCOMPtr<nsIConnectorRuntime> m_c;
    nsCOMPtr<nsIConnectorReturn> m_return;
    nsCOMPtr<nsIConnectorLog> m_log;
    resultfunc_t *m_resultfunc;
    test_func_t *m_test_func;
    void *m_vp;
    CF_Logger *m_logger;
    nsresult init(const char *modulePath);
};

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

