#!/bin/bash
# Unit test script for rpn_to_json
#

LOG=rpn_to_json_unittest.log
OUT=rpn_to_json_unittest.out

function t() {
  echo 
  echo $*
  ./rpn_to_json $* 2>&1
} >> $LOG

echo "rpn_to_json_unittest starting" > $LOG

# Simple tests
t water
t @attr 1=title water
t @attr 1=4 water

# And 
t @and  water fire
t @and  @attr 1=title water fire
t @and  water @attr 1=title fire  
t @and  @attr 1=author water  @attr 1=title fire

# Relation - special cases for years
t @attr 1=title @attr 2=1 water  # lt
t @attr 1=title @attr 2=2 water  # le
t @attr 1=title @attr 2=3 water  # eq
t @attr 1=title @attr 2=4 water  # ge
t @attr 1=title @attr 2=5 water  # gt
t @attr 1=title @attr 2=100 water  # phonetic - invalid
t @attr 1=title @attr 2=101 water  # stem - invalid
t @attr 1=title @attr 2=102 water  # relevance - invalid
t @attr 1=title @attr 2=103 water  # alwaysmatches - invalid
# non-numerical years
t @attr 1=year @attr 2=1 water  # lt
t @attr 1=year @attr 2=2 water  # le
t @attr 1=year @attr 2=3 water  # eq
t @attr 1=year @attr 2=4 water  # ge
t @attr 1=year @attr 2=5 water  # gt
t @attr 1=year @attr 2=100 water  # phonetic - invalid
t @attr 1=year @attr 2=101 water  # stem - invalid
t @attr 1=year @attr 2=102 water  # relevance - invalid
t @attr 1=year @attr 2=103 water  # alwaysmatches - invalid
t @attr 1=year @attr 2=1 2000  # lt
t @attr 1=year @attr 2=2 2000  # le
t @attr 1=year @attr 2=3 2000  # eq
t @attr 1=year @attr 2=4 2000  # ge
t @attr 1=year @attr 2=5 2000  # gt
t @attr 1=year @attr 2=100 2000  # phonetic - invalid
t @attr 1=year @attr 2=101 2000  # stem - invalid
t @attr 1=year @attr 2=102 2000  # relevance - invalid
t @attr 1=year @attr 2=103 2000  # alwaysmatches - invalid
t @and @attr 1=year @attr 2=4 1995   @attr 1=year @attr 2=2 2005  
t @and @attr 1=year @attr 2=5 1995   @attr 1=year @attr 2=1 2005
t @and @attr 1=year @attr 2=3 1995   @attr 1=year @attr 2=3 2005


# structure attrs
t @attr 1=title @attr 4=1 water  # phrase
t @attr 1=title @attr 4=2 water  # word
t @attr 1=title @attr 4=3 water  # key
t @attr 1=title @attr 4=4 water  # year
t @attr 1=title @attr 4=107 water  # localnumber

# truncation, without capability flags
# simple queries fail, fullqueries succeed
t @attr 1=title @attr 5=1 water  # left
t @attr 1=title @attr 5=2 water  # right
t @attr 1=title @attr 5=3 water  # both
t @attr 1=title @attr 5=100 water  # none
t @attr 1=title @attr 5=101 water  # mask
t @attr 1=title @attr 5=104 water  # z39.58
t @attr 1=title @attr 5=999 water  # invalid
# And then with flags, only testing the simple transforms
# (fullquery doesn't look at flags)
t -s -c trunc-right,trunc-asterisk @attr 5=1 water
t -s -c trunc-right,trunc-questionmark @attr 5=1 water
t -s -c trunc-left,trunc-asterisk @attr 5=2 water
t -s -c trunc-both,trunc-asterisk @attr 5=3 water
# trunc-any is old, outdated flag, should not work
t -s -c trunc-any,trunc-asterisk @attr 5=3 water
# wildcards in the term
t -s -c query-wildcard @attr 5=104 water#elon  # not supported '#'
t -s -c query-wildcard @attr 5=104 water?elon  # no wildcard
t -s -c trunc-asterisk @attr 5=104 water?elon  # no flag
t -s -c query-wildcard,trunc-asterisk @attr 5=104 water?elon  
t -s -c query-wildcard,trunc-questionmark @attr 5=104 water?elon  
t -s -c query-wildcard,trunc-asterisk @attr 5=104 ?termel?
t -s -c query-wildcard,trunc-asterisk @attr 5=104 w?t?rm?l?n  


# Check the results
if [ ! -f $OUT ]
then
  echo "No file $OUT"
  echo "Please verify $LOG carefully, and if all is well"
  echo "  cp $LOG $OUT"
  echo "  git add $OUT"
  exit 1
else 
  diff $OUT $LOG
  if test $? -ne 0
  then
    echo
    echo "$LOG and $OUT DIFFER"
    echo rpn_to_json_unittest FAILED
    exit 1
  fi
fi

echo "rpn_to_json_unittest OK"
exit 0

