#!/bin/sh
# Copyright (C) 2009-2010 by Index Data ApS. 
# http://www.indexdata.com
#
# parallel connector test
#
# env DISPLAY=:1.0 MAX_CLIENTS=2 ./test-connector.sh
#

: ${DEBUG=1}
: ${CF_LOGS_DIR="./logs"}
test -d ${CF_LOGS_DIR} || mkdir -p ${CF_LOGS_DIR}

CF_BASE_PATH=`cd ../..; pwd`
if test -z "$1"; then
	test $DEBUG -ge 1  && echo "Testing all connectors in $CF_BASE_PATH/connectors"
	FILES=$CF_BASE_PATH/connectors/*.cf
else
	FILES="$@"
fi

# CF test commands
: ${CF_COMMANDS="test init?,search,parse,next,parse,next"}
: ${CF_RUN="./cfrun"}

: ${SLEEP=0.01}

# max. number of parallel scripts
: ${MAX_CLIENTS=1}

# apt-get install procmail
lockfile_program=lockfile
if which $lockfile_program >/dev/null 2>&1; then :
else
	if [ $MAX_CLIENTS -gt 1 ]; then
	   echo "$lockfile_program(1) not found, run in non-parallel mode"
	fi
	MAX_CLIENTS=1
	lockfile_program=true
fi

# evil linux distro shipped without a time(1) command
time=`which time`

if [ prefs.js -nt defaults/preferences/prefs.js ]; then
	echo ""
	echo "!!!WARNING: ./prefs.js is newer... don't forget to run make!!!"
	echo ""
fi

if ! [ -n "$HOME" -a -d "$HOME" -a -w "$HOME" ]; then
	echo ""
	echo "!!!WARNING: env variable HOME not set or not writable, the engine will fail!!!"
	echo ""
fi
	
if test "$XVFB"; then
	# On Ubuntu 8.10, Xvfb has a nasty habit of dying after
	# serving a small number of clients, if the screen size is not
	# explicitly set.

	# apt-get install xvfb
	if ! which Xvfb >/dev/null; then
		echo "WARNING: Xvfb (Virtual Framebuffer fake X server) not found!"
	fi

	: ${XVFB_SCREEN="-screen 0 800x600x24"}
	echo localhost > ${CF_LOGS_DIR}/Xvfb.hosts
	( Xvfb :1 $XVFB_SCREEN -auth ${CF_LOGS_DIR}/Xvfb.hosts > ${CF_LOGS_DIR}/Xvfb.out 2>&1 & )
	export DISPLAY=:1.0
fi

if test -z "$DISPLAY"; then
	echo "WARNING: display not set!"
fi

if test -z "$CF_RUN" -o ! -x "$CF_RUN"; then
	echo "WARNING: cfrun program \"$CF_RUN\" does not exists. Don't forget to run make!"
fi

counter=0
temp_prefix=`mktemp -t _test_connectors.XXXXXXXXXXXXXX` || exit 2
rm -f $temp_prefix.*

for c in $FILES; do
	# Add pathname and/or suffix if they are missing
	if echo "$c" | grep -q / ; then
		true
	else
		c="../../connectors/$c"
	fi
	if echo "$c" | grep -q '\.cf$' ; then
		true
	else
		c="$c.cf"
	fi
	counter=`expr $counter + 1`
	rest=`perl -e "print $counter % $MAX_CLIENTS"`

	# check for absolute path names
	case $c in 
		/*) ;;
		* ) c=`echo $(pwd)/$c | perl -npe 'while (s,/[^/]+/\.\.,,g) {}'` ;;
	esac

	if [ ! -f $c ]; then
		echo "Connector $c does not exist!"
		exit 2
	fi

	# each ./cfrun runs on it's on X server
	# perl -e 'for(0..7) {print qq{Xvfb :$_ -auth hosts >& logs/xvfb.$_.log &\n}}' | sh
	# export DISPLAY=":${rest}.0"

	(
	lockfile=$temp_prefix.$rest.lock
	$lockfile_program -1 -r 400 $lockfile
	rtime=`perl -e 'print time'`

	bc=`basename $c .cf`
	msg=""
	if [ $DEBUG -ge 2 ]; then 
		msg=", lockfile: $lockfile"
	fi

	test $DEBUG -ge 1 && echo "$bc: Testing"$msg

	in=${CF_LOGS_DIR}/$bc.input
	out=${CF_LOGS_DIR}/$bc.stdout
	err=${CF_LOGS_DIR}/$bc.stderr
	(
		echo "cf $c"
		echo "$CF_COMMANDS"
		echo "quit"
	) >$in
	CF_MODULE_PATH=$CF_BASE_PATH/builder/modules $time ${CF_RUN} < $in > $out 2> $err
	msg=""
	OK=false

	if [ $DEBUG -ge 1 ]; then 
		rtime2=`perl -e 'print time'`
		msg=" (in `expr $rtime2 - $rtime` sec) "
	fi

        if grep -qx 'OK' $out ; then
                OK=true
        fi

	if $OK; then
		test $DEBUG -ge 1 && echo "$bc: OK$msg"
		echo $bc >> $temp_prefix.ok

		# keep a copy of the error file which will
		# not be overridden by a later test run
		if [ $DEBUG -ge 3 ]; then
		     tmp_err=`mktemp $err.XXXXXX` || exit 2
		     cp -f $err $tmp_err
		fi
	else
		test $DEBUG -ge 1 && echo "$bc: Failed"
		echo $bc >> $temp_prefix.failed

		# keep a copy of the error file which will
		# not be overridden by a later test run
		if [ $DEBUG -ge 2 ]; then
		     tmp_err=`mktemp $err.XXXXXX` || exit 2
		     cp -f $err $tmp_err
		fi
	fi

	rm -f $lockfile
	) &

	# run in foreground?
	if  [ $MAX_CLIENTS -le 1 ]; then
		wait;
	else 
		# be polite to old hardware
		sleep $SLEEP
	fi		
done

wait

touch $temp_prefix.ok $temp_prefix.failed
ok=`wc -l < $temp_prefix.ok`
failed=`wc -l < $temp_prefix.failed`

if [ $DEBUG -ge 1 ]; then
	echo ""
	echo "===> Status: run $counter test(s), ok: $ok, failed: $failed"
fi

if [ $DEBUG -ge 1 -a $failed -ge 1 ]; then
	echo "===> Please fix me:"
	cat $temp_prefix.failed
fi
rm -f $temp_prefix.* $temp_prefix

if [ $failed -eq 0 ]; then
	exit 0
else
	exit 1
fi

