#!/bin/sh
# Copyright (C) 2009-2010 by Index Data ApS. 
# http://www.indexdata.com
#
# parallel connector test
#
# env DISPLAY=:1.0 MAX_CLIENTS=2 ./test-connector.sh
#

: ${DEBUG=1}
: ${CF_LOGS_DIR="./logs"}
test -d ${CF_LOGS_DIR} || mkdir -p ${CF_LOGS_DIR}

CF_BASE_PATH=`cd ../..; pwd`
FILES="$1"
NO=$2

# CF test commands
: ${CF_COMMANDS="test search"}
: ${CF_RUN="./cfrun"}
: ${CF_LOOP="10"}
: ${XVFB=1}

if [ prefs.js -nt defaults/preferences/prefs.js ]; then
	echo ""
	echo "!!!WARNING: ./prefs.js is newer... don't forget to run make!!!"
	echo ""
fi

if ! [ -n "$HOME" -a -d "$HOME" -a -w "$HOME" ]; then
	echo ""
	echo "!!!WARNING: env variable HOME not set or not writable, the engine will fail!!!"
	echo ""
fi
	
if test "$XVFB"; then
	# On Ubuntu 8.10, Xvfb has a nasty habit of dying after
	# serving a small number of clients, if the screen size is not
	# explicitly set.

	# apt-get install xvfb
	if ! which Xvfb >/dev/null; then
		echo "WARNING: Xvfb (Virtual Framebuffer fake X server) not found!"
	fi

	: ${XVFB_SCREEN="-screen 0 800x600x24"}
	echo localhost > ${CF_LOGS_DIR}/Xvfb.hosts
	( Xvfb :${XVFB} $XVFB_SCREEN -auth ${CF_LOGS_DIR}/Xvfb.hosts > ${CF_LOGS_DIR}/Xvfb.${XVFB}.out 2>&1 & )
	export DISPLAY=:${XVFB}
fi

if test -z "$DISPLAY"; then
	echo "WARNING: display not set!"
fi

if test -z "$CF_RUN" -o ! -x "$CF_RUN"; then
	echo "WARNING: cfrun program \"$CF_RUN\" does not exists. Don't forget to run make!"
fi

c=$FILES
if [  -z "$c" ]; then
	echo "usage: $0 connector"
	exit 2
fi

# Add pathname and/or suffix if they are missing
if echo "$c" | grep -q / ; then
	true
else
	c="../../connectors/$c"
fi
if echo "$c" | grep -q '\.cf$' ; then
	true
else
	c="$c.cf"
fi


# check for absolute path names
case $c in 
	/*) ;;
	* ) c=`echo $(pwd)/$c | perl -npe 'while (s,/[^/]+/\.\.,,g) {}'` ;;
esac

if [ ! -f $c ]; then
	echo "Connector $c does not exist!"
	exit 2
fi


bc=`basename $c .cf`
if [ -n "$NO" ]; then
	bc=${bc}.$NO
fi

in=${CF_LOGS_DIR}/$bc.input
out=${CF_LOGS_DIR}/$bc.stdout
err=${CF_LOGS_DIR}/$bc.stderr
(
	echo "cf $c"
	echo "$CF_COMMANDS"
	echo "quit"
) >$in

rm -f $out $err
for i in `perl -e 'print "a " x $ARGV[0]' $CF_LOOP`
do
	#printf "."
	CF_MODULE_PATH=$CF_BASE_PATH/builder/modules ${CF_RUN} < $in >> $out 2>> $err
done

echo ""

egrep -c '^OK$' $out

