#!/usr/bin/perl
#
# json2json - pretty-print JSON
#
#  debian$ apt-get install libjson-perl
# macport$ port install p5-json
#

use JSON;

use strict;
use warnings;

my $json = new JSON;

if (@ARGV && $ARGV[0] eq "-s") {
    # Sort
    $json->canonical(1);
    shift;
}

while (<>) {
    chomp;

    my $perl = $json->decode($_);
    print $json->pretty->encode($perl);
}

