var EXPORTED_SYMBOLS = ["Download"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/textHelper.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');

var Download = function () {
  this.conf = {};
  this.conf['sourcearg'] = '';
  this.conf['sourceurl'] = '';
  this.conf['targetpath'] = '';
  this.conf['result'] = '';
};
Download.prototype = new Step();
Download.prototype.constructor = Download;

Download.prototype.init = function(task) {};

Download.prototype.draw = function(surface) {
  var context = this;
  var captionWidth = 140;

  var hbox = xmlHelper.appendNode(surface, "hbox", null, { align: "center" });
  xmlHelper.appendNode(hbox, "caption", "Argument for source URL");
  var arglist = this.task.getArgNames();
  var list = new Array ( "Constant source URL");
  list = list.concat(arglist);
  var argSelector = xulHelper.arraySelectField(hbox, this,"param", list);
  argSelector.addEventListener("command", function(e) {
        context.conf["sourcearg"] = this.selectedItem.value;
      },false);


  xulHelper.inputField(surface, this, "sourceurl", "Constant source URL", captionWidth);
  xulHelper.inputField(surface, this, "targetpath", "Target path on local filesystem", captionWidth);
  hbox = xmlHelper.appendNode(surface, "hbox");
  xulHelper.captionField(hbox, "Result to store local filename", { width: captionWidth });
  var containerSelect = xulHelper.resultSelectField(hbox, this, "result");
};
Download.prototype.run = function (task) {
  var url="";
  if (!this.conf['sourcearg'] ||
      this.conf['sourcearg'] == "Constant source URL" )
    url = this.conf['sourceurl'];
  else
    url = task.getArgValue(this.conf['sourcearg']);

  if (!url)
    throw new StepError("Source URL not specified");

  var filename = this.conf['targetpath'];
  if (!filename)
      throw new StepError("Target path not specified");

  filename += '/';
  filename += new Date().getTime();
  filename += '-';
  filename += textHelper.randString(8);

  var ioserv = Components.
    classes["@mozilla.org/network/io-service;1"].
    getService(Components.interfaces.nsIIOService);
  var channel = ioserv.newChannel(url, 0, null);
  var stream = channel.open();

  if (channel instanceof Components.interfaces.nsIHttpChannel && channel.responseStatus != 200) {
      throw new StepError("HTTP error downloading file: " + channel.responseStatus);
  }

  var bstream = Components.classes["@mozilla.org/binaryinputstream;1"]
  .createInstance(Components.interfaces.nsIBinaryInputStream);
  bstream.setInputStream(stream);

  var size = 0;
  var file_data = "";
  while(size = bstream.available()) {
      file_data += bstream.readBytes(size);
  }

  // pngBinary already exists
  var aFile = Components.
    classes["@mozilla.org/file/local;1"].
    createInstance(Components.interfaces.nsILocalFile);

  aFile.initWithPath(filename);
  aFile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0644);

  var stream = Components.
    classes["@mozilla.org/network/safe-file-output-stream;1"].
    createInstance(Components.interfaces.nsIFileOutputStream);
  stream.init(aFile, 0x04 | 0x08 | 0x20, 0600, 0); // write, create, truncate

  stream.write(file_data, file_data.length);
  if (stream instanceof Components.interfaces.nsISafeOutputStream) {
      stream.finish();
  } else {
      stream.close();
  }
  task.output[this.conf['result']] = [filename];
};

Download.prototype.getClassName = function () {
  return "Download";
};

Download.prototype.getDisplayName = function () {
  return "Download";
};

Download.prototype.getDescription = function () {
  return "Download file to a specified path ";
};

Download.prototype.getVersion = function () {
  return "0.1";
};

Download.prototype.getUsedArgs = function () {
  return [this.conf['sourcearg']];
};

Download.prototype.renderArgs = function () {
  if (!this.conf['sourcearg'] ||
    this.conf['sourcearg'] == "Constant source URL" ) {
    return this.conf['sourceurl'];
  } else {
    return this.conf['sourcearg'] ;
  }
};
