var EXPORTED_SYMBOLS = ["IfElse"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/runtime/Block.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/runtime/Conditional.js');

var IfElse = function () {
 this.conf = {};
 this.conditionals = [];
};
IfElse.prototype = new Step();
IfElse.prototype.constructor = IfElse;

IfElse.prototype.setDefaults = function () {
  // array of arrays for conditions for each conditional
  this.conf.conditionses = [[],[{operator:'always', operands:[]}]];
  let len = this.conf.conditionses.length;
  for (let i = 0; i < len; i++) {
    let label = i < 1 ? "if" : i < len-1 ? "else if" : "else";
    this.blocks.push(new Block(null, 'if'+i, label, this));
  }
};

IfElse.prototype.init = function(task) {
  for (let i = 0; i < this.conf.conditionses.length; i++) {
    this.conditionals.push(new Conditional(this.conf.conditionses[i], this.task.data));
  }
};


IfElse.prototype.draw = function(surface) {
  xmlHelper.appendNode(surface, "caption", "If: ");
  var condBox = xmlHelper.appendNode(surface, "vbox");
  this.conditionals[0].draw(condBox, this);
};

IfElse.prototype.run = function (task, block) {
  for (let i = 0; i < this.conditionals.length; i++) {
    if (this.conditionals[i].eval()) {
      this.blocks[i].run(block);
      break;
    }
  }
};

IfElse.prototype.getClassName = function () {
  return "IfElse";
};

IfElse.prototype.getDisplayName = function () {
  return "Conditional";
};

IfElse.prototype.getDescription = function () {
  return "If... Else If... Else";
};

IfElse.prototype.getVersion = function () {
  return "1.0";
};

IfElse.prototype.getUsedArgs = function () {
   return [];
}

IfElse.prototype.renderBlockArgs = function (i) {
  if (i == this.conditionals.length-1) return "";
  return String(this.conditionals[i]);
};

IfElse.prototype.renderArgs = function () {
  return "(" +this.conditionals.length + " cases)";
};

